/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.kil;

import org.kframework.backend.java.builtins.IntToken;
import org.kframework.backend.java.kil.BuiltinList;
import org.kframework.backend.java.kil.DataStructureLookup;
import org.kframework.backend.java.kil.Kind;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.symbolic.Matcher;
import org.kframework.backend.java.symbolic.Transformer;
import org.kframework.backend.java.symbolic.Unifier;
import org.kframework.backend.java.symbolic.Visitor;
import org.kframework.kil.ASTNode;

public class ListLookup
extends Term
implements DataStructureLookup {
    private final Term list;
    private final Term key;

    public ListLookup(Term list, Term key, Kind kind) {
        super(kind);
        this.list = list;
        this.key = key;
    }

    public Term evaluateLookup() {
        if (!(this.list instanceof BuiltinList)) {
            return this;
        }
        if (!(this.key instanceof IntToken)) {
            return this;
        }
        int index = ((IntToken)this.key).intValue();
        Term value = ((BuiltinList)this.list).get(index);
        return value;
    }

    public Term key() {
        return this.key;
    }

    public Term list() {
        return this.list;
    }

    @Override
    public boolean isSymbolic() {
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1;
            this.hashCode = this.hashCode * 47 + this.key.hashCode();
            this.hashCode = this.hashCode * 47 + this.list.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ListLookup)) {
            return false;
        }
        ListLookup mapLookup = (ListLookup)object;
        return this.key.equals(mapLookup.key) && this.list.equals(mapLookup.list);
    }

    public String toString() {
        return this.list.toString() + "[" + this.key + "]";
    }

    @Override
    public void accept(Unifier unifier, Term patten) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(Matcher matcher, Term pattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTNode accept(Transformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

