/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.kil;

import org.kframework.backend.java.kil.Bottom;
import org.kframework.backend.java.kil.BuiltinMap;
import org.kframework.backend.java.kil.DataStructureLookup;
import org.kframework.backend.java.kil.Kind;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.symbolic.Matcher;
import org.kframework.backend.java.symbolic.Transformer;
import org.kframework.backend.java.symbolic.Unifier;
import org.kframework.backend.java.symbolic.Visitor;
import org.kframework.kil.ASTNode;

public class MapLookup
extends Term
implements DataStructureLookup {
    private final Term map;
    private final Term key;

    public MapLookup(Term map, Term key, Kind kind) {
        super(kind);
        this.map = map;
        this.key = key;
    }

    public Term evaluateLookup() {
        if (!(this.map instanceof BuiltinMap)) {
            return this;
        }
        Term value = ((BuiltinMap)this.map).get(this.key);
        if (value != null) {
            return value;
        }
        if (this.map.isGround() && this.key.isGround()) {
            return new Bottom(this.kind);
        }
        if (((BuiltinMap)this.map).isEmpty()) {
            return new Bottom(this.kind);
        }
        return this;
    }

    public Term key() {
        return this.key;
    }

    public Term map() {
        return this.map;
    }

    @Override
    public boolean isSymbolic() {
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1;
            this.hashCode = this.hashCode * 47 + this.key.hashCode();
            this.hashCode = this.hashCode * 47 + this.map.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MapLookup)) {
            return false;
        }
        MapLookup mapLookup = (MapLookup)object;
        return this.key.equals(mapLookup.key) && this.map.equals(mapLookup.map);
    }

    public String toString() {
        return this.map.toString() + "[" + this.key + "]";
    }

    @Override
    public void accept(Unifier unifier, Term patten) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(Matcher matcher, Term pattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTNode accept(Transformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

