/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.kil;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kframework.backend.java.kil.BuiltinMap;
import org.kframework.backend.java.kil.Kind;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.symbolic.Matcher;
import org.kframework.backend.java.symbolic.Transformer;
import org.kframework.backend.java.symbolic.Unifier;
import org.kframework.backend.java.symbolic.Visitor;
import org.kframework.kil.ASTNode;

public class MapUpdate
extends Term {
    private final Term map;
    private final ImmutableSet<Term> removeSet;
    private final ImmutableMap<Term, Term> updateMap;

    public MapUpdate(Term map, Set<Term> removeSet, Map<Term, Term> updateMap) {
        super(Kind.KITEM);
        this.map = map;
        this.removeSet = ImmutableSet.copyOf(removeSet);
        this.updateMap = ImmutableMap.copyOf(updateMap);
    }

    public Term evaluateUpdate() {
        if (this.removeSet.isEmpty() && this.updateMap().isEmpty()) {
            return this.map;
        }
        if (!(this.map instanceof BuiltinMap)) {
            return this;
        }
        BuiltinMap builtinMap = (BuiltinMap)this.map;
        HashMap<Term, Term> entries = new HashMap<Term, Term>(builtinMap.getEntries());
        HashSet<Term> keysToRemove = new HashSet<Term>();
        for (Term nextKey : this.removeSet) {
            if (entries.remove(nextKey) == null) continue;
            keysToRemove.add(nextKey);
        }
        if (this.removeSet.size() > keysToRemove.size()) {
            return new MapUpdate(builtinMap, Sets.difference(this.removeSet, keysToRemove), this.updateMap);
        }
        entries.putAll(this.updateMap);
        if (builtinMap.hasFrame()) {
            return new BuiltinMap(entries, builtinMap.frame());
        }
        return new BuiltinMap(entries);
    }

    public Term map() {
        return this.map;
    }

    public ImmutableSet<Term> removeSet() {
        return this.removeSet;
    }

    public ImmutableMap<Term, Term> updateMap() {
        return this.updateMap;
    }

    @Override
    public boolean isSymbolic() {
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1;
            this.hashCode = this.hashCode * 47 + this.map.hashCode();
            this.hashCode = this.hashCode * 47 + this.removeSet.hashCode();
            this.hashCode = this.hashCode * 47 + this.updateMap.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MapUpdate)) {
            return false;
        }
        MapUpdate mapUpdate = (MapUpdate)object;
        return this.map.equals(mapUpdate.map) && this.removeSet.equals(mapUpdate.removeSet) && this.updateMap.equals(mapUpdate.updateMap);
    }

    public String toString() {
        String s = this.map.toString();
        for (Term key : this.removeSet) {
            s = s + "[" + key + " <- undef]";
        }
        for (Map.Entry entry : this.updateMap.entrySet()) {
            s = s + "[" + entry.getKey() + " <- " + entry.getValue() + "]";
        }
        return s;
    }

    @Override
    public void accept(Unifier unifier, Term pattern) {
        unifier.unify(this, pattern);
    }

    @Override
    public void accept(Matcher matcher, Term pattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTNode accept(Transformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

