/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.kil;

import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.Token;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.symbolic.Matcher;
import org.kframework.backend.java.symbolic.Transformer;
import org.kframework.backend.java.symbolic.Unifier;
import org.kframework.backend.java.symbolic.Visitor;
import org.kframework.kil.ASTNode;

public class MetaVariable
extends Token {
    public static final String SORT_NAME = "MetaVariable";
    private final String name;
    private final String sort;

    public MetaVariable(String name, String sort) {
        this.name = name;
        this.sort = sort;
    }

    public MetaVariable(Variable variable) {
        this(variable.name(), variable.sort());
    }

    @Override
    public String sort() {
        return SORT_NAME;
    }

    @Override
    public String value() {
        return this.name + ":" + this.sort;
    }

    public Variable variable() {
        return new Variable(this.name, this.sort);
    }

    public String variableName() {
        return this.name;
    }

    public String variableSort() {
        return this.sort;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MetaVariable)) {
            return false;
        }
        MetaVariable metaVariable = (MetaVariable)object;
        return this.name.equals(metaVariable.name) && this.sort.equals(metaVariable.sort);
    }

    @Override
    public void accept(Unifier unifier, Term pattern) {
        unifier.unify(this, pattern);
    }

    @Override
    public void accept(Matcher matcher, Term pattern) {
        matcher.match(this, pattern);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) {
        return transformer.transform(this);
    }
}

