/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.kil;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.kframework.backend.java.builtins.BoolToken;
import org.kframework.backend.java.indexing.IndexingPair;
import org.kframework.backend.java.kil.Cell;
import org.kframework.backend.java.kil.Definition;
import org.kframework.backend.java.kil.JavaSymbolicObject;
import org.kframework.backend.java.kil.KItem;
import org.kframework.backend.java.kil.KLabelConstant;
import org.kframework.backend.java.kil.KList;
import org.kframework.backend.java.kil.Kind;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.TermContext;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.symbolic.BottomUpVisitor;
import org.kframework.backend.java.symbolic.Transformer;
import org.kframework.backend.java.symbolic.UninterpretedConstraint;
import org.kframework.backend.java.symbolic.Visitor;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Attributes;

public class Rule
extends JavaSymbolicObject {
    private final String label;
    private final Term leftHandSide;
    private final Term rightHandSide;
    private final ImmutableList<Term> requires;
    private final ImmutableList<Term> ensures;
    private final ImmutableSet<Variable> freshVariables;
    private final UninterpretedConstraint lookups;
    private final IndexingPair indexingPair;
    private final boolean containsKCell;
    private final boolean hasUnboundedVars;
    private final boolean isSortPredicate;
    private final String predSort;
    private final KItem sortPredArg;
    private int hashCode = 0;
    private boolean tempContainsKCell = false;

    public Rule(String label, Term leftHandSide, Term rightHandSide, Collection<Term> requires, Collection<Term> ensures, Collection<Variable> freshVariables, UninterpretedConstraint lookups, Attributes attributes, Definition definition) {
        this.label = label;
        this.leftHandSide = leftHandSide;
        this.rightHandSide = rightHandSide;
        this.requires = ImmutableList.copyOf(requires);
        this.ensures = ImmutableList.copyOf(ensures);
        this.freshVariables = ImmutableSet.copyOf(freshVariables);
        this.lookups = lookups;
        super.setAttributes(attributes);
        List<IndexingPair> indexingPairs = leftHandSide.getIndexingPairs(definition);
        this.indexingPair = indexingPairs.size() == 1 ? (IndexingPair)indexingPairs.iterator().next() : IndexingPair.TOP;
        leftHandSide.accept(new BottomUpVisitor(){

            @Override
            public void visit(Cell cell) {
                if (cell.getLabel().equals("k")) {
                    Rule.this.tempContainsKCell = true;
                } else if (cell.contentKind() == Kind.CELL_COLLECTION) {
                    super.visit(cell);
                }
            }
        });
        this.containsKCell = this.tempContainsKCell;
        this.hasUnboundedVars = super.containsAttribute("hasUnboundedVars");
        boolean bl = this.isSortPredicate = super.containsAttribute("function") && this.functionKLabel().toString().startsWith("is");
        if (this.isSortPredicate) {
            this.predSort = this.functionKLabel().toString().substring(2);
            assert (leftHandSide instanceof KItem && rightHandSide.equals(BoolToken.TRUE) && ((KList)((KItem)leftHandSide).kList()).size() == 1) : "unexpected sort predicate rule: " + this;
            Term arg = ((KList)((KItem)leftHandSide).kList()).get(0);
            assert (arg instanceof KItem) : "unexpected sort predicate rule: " + this;
            this.sortPredArg = (KItem)arg;
        } else {
            this.predSort = null;
            this.sortPredArg = null;
        }
    }

    public String label() {
        return this.label;
    }

    public ImmutableList<Term> requires() {
        return this.requires;
    }

    public ImmutableList<Term> ensures() {
        return this.ensures;
    }

    public ImmutableSet<Variable> freshVariables() {
        return this.freshVariables;
    }

    public boolean hasUnboundedVariables() {
        return this.hasUnboundedVars;
    }

    public boolean isSortPredicate() {
        return this.isSortPredicate;
    }

    public String getPredSort() {
        assert (this.isSortPredicate);
        return this.predSort;
    }

    public KItem getSortPredArgument() {
        assert (this.isSortPredicate);
        return this.sortPredArg;
    }

    public KLabelConstant functionKLabel() {
        assert (super.containsAttribute("function"));
        return (KLabelConstant)((KItem)this.leftHandSide).kLabel();
    }

    public Rule getFreshRule(TermContext context) {
        return this.substitute(Variable.getFreshSubstitution(this.variableSet()), context);
    }

    public IndexingPair indexingPair() {
        return this.indexingPair;
    }

    public Term leftHandSide() {
        return this.leftHandSide;
    }

    public UninterpretedConstraint lookups() {
        return this.lookups;
    }

    public boolean containsKCell() {
        return this.containsKCell;
    }

    public Term rightHandSide() {
        return this.rightHandSide;
    }

    @Override
    public Rule substitute(Map<Variable, ? extends Term> substitution, TermContext context) {
        return (Rule)super.substitute(substitution, context);
    }

    @Override
    public Rule substituteWithBinders(Variable variable, Term term, TermContext context) {
        return (Rule)super.substituteWithBinders(variable, term, context);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Rule)) {
            return false;
        }
        Rule rule = (Rule)object;
        return this.label.equals(rule.label) && this.leftHandSide.equals(rule.leftHandSide) && this.rightHandSide.equals(rule.rightHandSide) && this.requires.equals(rule.requires) && this.ensures.equals(rule.ensures) && this.lookups.equals(rule.lookups) && this.freshVariables.equals(rule.freshVariables);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1;
            this.hashCode = this.hashCode * 47 + this.label.hashCode();
            this.hashCode = this.hashCode * 47 + this.leftHandSide.hashCode();
            this.hashCode = this.hashCode * 47 + this.rightHandSide.hashCode();
            this.hashCode = this.hashCode * 47 + this.requires.hashCode();
            this.hashCode = this.hashCode * 47 + this.ensures.hashCode();
            this.hashCode = this.hashCode * 47 + this.lookups.hashCode();
            this.hashCode = this.hashCode * 47 + this.freshVariables.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        String string = "rule ";
        if (this.label != null && !this.label.isEmpty()) {
            string = string + "[" + this.label + "]: ";
        }
        string = string + this.leftHandSide + " => " + this.rightHandSide;
        if (this.requires != null) {
            string = string + " requires " + this.requires;
        }
        if (!this.lookups.equalities().isEmpty()) {
            string = this.requires == null ? string + " when " : string + "  /\\  ";
            string = string + this.lookups;
        }
        if (this.ensures != null) {
            string = string + " ensures " + this.ensures;
        }
        return string;
    }

    @Override
    public ASTNode accept(Transformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

