/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.kil;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.kframework.backend.java.kil.BuiltinSet;
import org.kframework.backend.java.kil.Kind;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.symbolic.Matcher;
import org.kframework.backend.java.symbolic.Transformer;
import org.kframework.backend.java.symbolic.Unifier;
import org.kframework.backend.java.symbolic.Visitor;
import org.kframework.kil.ASTNode;

public class SetUpdate
extends Term {
    private final Term set;
    private final ImmutableSet<Term> removeSet;

    public SetUpdate(Term set, Set<Term> removeSet) {
        super(Kind.KITEM);
        this.set = set;
        this.removeSet = ImmutableSet.copyOf(removeSet);
    }

    public Term evaluateUpdate() {
        if (this.removeSet.isEmpty()) {
            return this.set;
        }
        if (!(this.set instanceof BuiltinSet)) {
            return this;
        }
        BuiltinSet builtinSet = (BuiltinSet)this.set;
        HashSet<Term> elems = new HashSet<Term>(builtinSet.elements());
        HashSet<Term> elemsToRemove = new HashSet<Term>();
        for (Term nextElem : this.removeSet) {
            if (!elems.remove(nextElem)) continue;
            elemsToRemove.add(nextElem);
        }
        if (this.removeSet.size() > elemsToRemove.size()) {
            return new SetUpdate(this.set, Sets.difference(elems, elemsToRemove));
        }
        if (builtinSet.hasFrame()) {
            return new BuiltinSet(elems, builtinSet.frame());
        }
        return new BuiltinSet(elems);
    }

    public Term base() {
        return this.set;
    }

    public ImmutableSet<Term> removeSet() {
        return this.removeSet;
    }

    @Override
    public boolean isSymbolic() {
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1;
            this.hashCode = this.hashCode * 47 + this.set.hashCode();
            this.hashCode = this.hashCode * 47 + this.removeSet.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SetUpdate)) {
            return false;
        }
        SetUpdate mapUpdate = (SetUpdate)object;
        return this.set.equals(mapUpdate.set) && this.removeSet.equals(mapUpdate.removeSet);
    }

    public String toString() {
        String s = this.set.toString();
        for (Term key : this.removeSet) {
            s = s + "[" + key + " <- undef]";
        }
        return s;
    }

    @Override
    public void accept(Unifier unifier, Term pattern) {
        unifier.unify(this, pattern);
    }

    @Override
    public void accept(Matcher matcher, Term pattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTNode accept(Transformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

