/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.kil;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kframework.backend.java.indexing.IndexingPair;
import org.kframework.backend.java.kil.Cell;
import org.kframework.backend.java.kil.Definition;
import org.kframework.backend.java.kil.JavaSymbolicObject;
import org.kframework.backend.java.kil.Kind;
import org.kframework.backend.java.kil.TermContext;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.symbolic.BinderSubstitutionTransformer;
import org.kframework.backend.java.symbolic.BottomUpVisitor;
import org.kframework.backend.java.symbolic.Evaluator;
import org.kframework.backend.java.symbolic.KILtoBackendJavaKILTransformer;
import org.kframework.backend.java.symbolic.LocalEvaluator;
import org.kframework.backend.java.symbolic.Matchable;
import org.kframework.backend.java.symbolic.SymbolicConstraint;
import org.kframework.backend.java.symbolic.Transformable;
import org.kframework.backend.java.symbolic.Unifiable;
import org.kframework.krun.K;
import org.kframework.utils.general.IndexingStatistics;

public abstract class Term
extends JavaSymbolicObject
implements Transformable,
Matchable,
Unifiable,
Comparable<Term> {
    protected final Kind kind;
    protected int hashCode = 0;

    protected Term(Kind kind) {
        this.kind = kind;
    }

    public static Term of(org.kframework.kil.Term kilTerm, Definition definition) {
        if (K.get_indexing_stats) {
            IndexingStatistics.kilTransformationStopWatch.start();
        }
        KILtoBackendJavaKILTransformer transformer = new KILtoBackendJavaKILTransformer(definition.context());
        Term term = transformer.transformTerm(kilTerm, definition);
        if (K.get_indexing_stats) {
            IndexingStatistics.kilTransformationStopWatch.stop();
        }
        return term;
    }

    public List<IndexingPair> getIndexingPairs(final Definition definition) {
        final ArrayList<IndexingPair> indexingPairs = new ArrayList<IndexingPair>();
        this.accept(new BottomUpVisitor(){

            @Override
            public void visit(Cell cell) {
                if (cell.getLabel().equals("k")) {
                    indexingPairs.add(IndexingPair.getIndexingPair(cell.getContent(), definition));
                } else if (cell.contentKind() == Kind.CELL_COLLECTION) {
                    super.visit(cell);
                }
            }
        });
        return indexingPairs;
    }

    public abstract boolean isSymbolic();

    public Kind kind() {
        return this.kind;
    }

    public Term evaluate(TermContext context) {
        return this.evaluate(null, context);
    }

    public Term evaluate(SymbolicConstraint constraint, TermContext context) {
        return Evaluator.evaluate(this, constraint, context);
    }

    @Override
    public Term substitute(Map<Variable, ? extends Term> substitution, TermContext context) {
        return (Term)super.substitute(substitution, context);
    }

    @Override
    public Term substituteWithBinders(Map<Variable, ? extends Term> substitution, TermContext context) {
        return (Term)super.substituteWithBinders(substitution, context);
    }

    public Term substituteAndEvaluate(Map<Variable, ? extends Term> substitution, TermContext context) {
        if (substitution.isEmpty() || this.isGround()) {
            return this;
        }
        BinderSubstitutionTransformer transformer = new BinderSubstitutionTransformer(substitution, context);
        transformer.getPostTransformer().addTransformer(new LocalEvaluator(context));
        return (Term)this.accept(transformer);
    }

    @Override
    public Term substituteWithBinders(Variable variable, Term term, TermContext context) {
        return (Term)super.substituteWithBinders(variable, term, context);
    }

    @Override
    public int compareTo(Term o) {
        return this.toString().compareTo(o.toString());
    }
}

