/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.kil;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.kframework.backend.java.kil.Kind;
import org.kframework.backend.java.kil.MetaVariable;
import org.kframework.backend.java.kil.Sorted;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.symbolic.Matcher;
import org.kframework.backend.java.symbolic.Transformer;
import org.kframework.backend.java.symbolic.Unifier;
import org.kframework.backend.java.symbolic.Visitor;
import org.kframework.kil.ASTNode;

public class Variable
extends Term
implements Sorted {
    protected static final String VARIABLE_PREFIX = "_";
    protected static int counter = 0;
    private static Map<Integer, Variable> deserializationAnonymousVariableMap = new HashMap<Integer, Variable>();
    private final String name;
    private final String sort;
    private final boolean anonymous;

    public static Map<Variable, Variable> getFreshSubstitution(Set<Variable> variableSet) {
        HashMap<Variable, Variable> substitution = new HashMap<Variable, Variable>();
        for (Variable variable : variableSet) {
            substitution.put(variable, variable.getFreshCopy());
        }
        return substitution;
    }

    public static Variable getFreshVariable(String sort) {
        return new Variable(VARIABLE_PREFIX + counter++, sort, true);
    }

    public Variable(String name, String sort, boolean anonymous) {
        super(Kind.of(sort));
        assert (name != null && sort != null);
        this.name = name;
        this.sort = sort;
        this.anonymous = anonymous;
    }

    public Variable(String name, String sort) {
        this(name, sort, false);
    }

    public Variable(MetaVariable metaVariable) {
        this(metaVariable.variableName(), metaVariable.variableSort());
    }

    public Variable getFreshCopy() {
        return Variable.getFreshVariable(this.sort);
    }

    public String name() {
        return this.name;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public String sort() {
        return this.sort;
    }

    @Override
    public boolean isSymbolic() {
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Variable)) {
            return false;
        }
        Variable variable = (Variable)object;
        return this.name.equals(variable.name) && this.sort.equals(variable.sort);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1;
            this.hashCode = this.hashCode * 47 + this.name.hashCode();
            this.hashCode = this.hashCode * 47 + this.sort.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this.name + ":" + this.sort;
    }

    @Override
    public void accept(Unifier unifier, Term pattern) {
        unifier.unify(this, pattern);
    }

    @Override
    public void accept(Matcher matcher, Term pattern) {
        matcher.match(this, pattern);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode accept(Transformer transformer) {
        return transformer.transform(this);
    }

    private Object readResolve() {
        if (this.anonymous) {
            int id = Integer.parseInt(this.name.substring(VARIABLE_PREFIX.length()));
            if (id < counter) {
                Variable variable = deserializationAnonymousVariableMap.get(id);
                if (variable == null) {
                    variable = Variable.getFreshVariable(this.sort);
                    deserializationAnonymousVariableMap.put(id, variable);
                }
                return variable;
            }
            counter = id + 1;
            return this;
        }
        return this;
    }
}

