/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.ksimulation;

import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Solver;
import com.microsoft.z3.Status;
import com.microsoft.z3.Z3Exception;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.kframework.backend.java.kil.Cell;
import org.kframework.backend.java.kil.ConstrainedTerm;
import org.kframework.backend.java.kil.JavaSymbolicObject;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.kil.Z3Term;
import org.kframework.backend.java.symbolic.JavaSymbolicKRun;
import org.kframework.backend.java.symbolic.KILtoZ3;
import org.kframework.backend.java.symbolic.SymbolicConstraint;
import org.kframework.backend.java.util.Z3Wrapper;
import org.kframework.krun.K;
import org.kframework.krun.KRunExecutionException;

public class Adjuster {
    private JavaSymbolicKRun impl;
    private JavaSymbolicKRun spec;

    public Adjuster(JavaSymbolicKRun impl, JavaSymbolicKRun spec) {
        this.impl = impl;
        this.spec = spec;
    }

    public boolean isSat(ConstrainedTerm implElem, ConstrainedTerm specElem) throws KRunExecutionException, Z3Exception {
        if (this.impl.getSimulationRewriter().getSimulationMap().isEmpty() || this.spec.getSimulationRewriter().getSimulationMap().isEmpty()) {
            return true;
        }
        ConstrainedTerm implside = this.impl.simulationSteps(implElem);
        ConstrainedTerm specside = this.spec.simulationSteps(specElem);
        if (specside == null) {
            return true;
        }
        if (implside == null) {
            return false;
        }
        if (K.smt.equals("none")) {
            return implside.term().equals(specside.term());
        }
        Map<Variable, Variable> implVars = implside.constraint().rename(implside.term().variableSet());
        Map<Variable, Variable> specVars = specside.constraint().rename(specside.term().variableSet());
        JavaSymbolicObject newImplTerm = implside.term().substituteWithBinders(implVars, implside.termContext());
        Object newImplContent = ((Cell)newImplTerm).getContent();
        JavaSymbolicObject newSpecTerm = specside.term().substituteWithBinders(specVars, specside.termContext());
        Object newSepcContent = ((Cell)newSpecTerm).getContent();
        JavaSymbolicObject newImplside = implside.constraint().substituteWithBinders(implVars, implside.termContext());
        JavaSymbolicObject newSpecside = specside.constraint().substituteWithBinders(specVars, specside.termContext());
        HashSet<Variable> allVarsInTerm = new HashSet<Variable>();
        allVarsInTerm.addAll(implVars.values());
        allVarsInTerm.addAll(specVars.values());
        HashSet<Variable> allVars = new HashSet<Variable>();
        allVars.addAll(newImplside.variableSet());
        allVars.addAll(newSpecside.variableSet());
        allVars.addAll(implVars.values());
        allVars.addAll(specVars.values());
        Context context = Z3Wrapper.newContext();
        KILtoZ3 transformer = new KILtoZ3(allVars, context);
        Solver solver = context.MkSolver();
        BoolExpr first = context.MkEq(((Z3Term)newImplContent.accept(transformer)).expression(), ((Z3Term)newSepcContent.accept(transformer)).expression());
        if (allVarsInTerm.isEmpty()) {
            solver.Assert(first);
            if (solver.Check() == Status.SATISFIABLE) {
                return true;
            }
            if (solver.Check() == Status.UNKNOWN) {
                return implside.term().equals(specside.term());
            }
            return false;
        }
        ArrayList<BoolExpr> temp = new ArrayList<BoolExpr>();
        temp.add(first);
        for (SymbolicConstraint.Equality equality : ((SymbolicConstraint)newImplside).equalities()) {
            BoolExpr tempBoolExpr = context.MkEq(((Z3Term)equality.leftHandSide().accept(transformer)).expression(), ((Z3Term)equality.rightHandSide().accept(transformer)).expression());
            temp.add(tempBoolExpr);
        }
        BoolExpr[] newImplEqualities = new BoolExpr[temp.size()];
        for (int i = 0; i < temp.size(); ++i) {
            newImplEqualities[i] = (BoolExpr)temp.get(i);
        }
        temp = new ArrayList();
        for (SymbolicConstraint.Equality equality : ((SymbolicConstraint)newSpecside).equalities()) {
            BoolExpr tempBoolExpr = context.MkEq(((Z3Term)equality.leftHandSide().accept(transformer)).expression(), ((Z3Term)equality.rightHandSide().accept(transformer)).expression());
            temp.add(tempBoolExpr);
        }
        BoolExpr[] newSpecEqualities = new BoolExpr[temp.size()];
        for (int i = 0; i < temp.size(); ++i) {
            newSpecEqualities[i] = (BoolExpr)temp.get(i);
        }
        BoolExpr forAllLeftSide = context.MkAnd(newImplEqualities);
        BoolExpr forAllRightSide = context.MkAnd(newSpecEqualities);
        Expr[] varsInZ3 = new Expr[allVarsInTerm.size()];
        Iterator iter = allVarsInTerm.iterator();
        int i = 0;
        while (iter.hasNext()) {
            varsInZ3[i] = ((Z3Term)((Term)iter.next()).accept(transformer)).expression();
        }
        solver.Assert(context.MkForall(varsInZ3, context.MkImplies(forAllLeftSide, forAllRightSide), 1, null, null, null, null));
        if (solver.Check() == Status.SATISFIABLE) {
            return true;
        }
        if (solver.Check() == Status.UNKNOWN) {
            return implside.term().equals(specside.term());
        }
        return false;
    }
}

