/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.strategies;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.kframework.backend.java.kil.Rule;
import org.kframework.backend.java.strategies.Strategy;

public class CompositeStrategy
implements Strategy {
    private LinkedList<Strategy> stack = new LinkedList();

    public void push(Strategy s) {
        this.stack.addFirst(s);
    }

    public Strategy pop() {
        return this.stack.pollFirst();
    }

    @Override
    public void reset(Collection<Rule> rules) {
        Iterator<Strategy> it = this.stack.descendingIterator();
        while (it.hasNext()) {
            Strategy top = it.next();
            top.reset(rules);
            if (!it.hasNext() || !top.hasNext()) break;
            rules = top.next();
        }
    }

    @Override
    public Collection<Rule> next() {
        if (this.stack.isEmpty()) {
            return null;
        }
        if (!this.stack.peekFirst().hasNext()) {
            Strategy top = this.stack.pollFirst();
            top.reset(this.next());
            this.stack.addFirst(top);
        }
        return new LinkedHashSet<Rule>(this.stack.peekFirst().next());
    }

    @Override
    public boolean hasNext() {
        if (this.stack.isEmpty()) {
            return false;
        }
        boolean result = this.stack.peekFirst().hasNext();
        if (!result) {
            Strategy top = this.stack.pollFirst();
            result = this.hasNext();
            this.stack.addFirst(top);
        }
        return result;
    }
}

