/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.strategies;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.kframework.backend.java.kil.Rule;
import org.kframework.backend.java.strategies.Strategy;

public class PriorityStrategy
implements Strategy {
    private Iterator<Integer> priorityIterator;
    private HashMap<Integer, HashSet<Rule>> priorityMap = new HashMap();
    private TreeSet<Integer> priorities = new TreeSet();

    public PriorityStrategy() {
        this.priorityIterator = this.priorities.descendingIterator();
    }

    @Override
    public void reset(Collection<Rule> rules) {
        this.priorityMap.clear();
        this.priorities.clear();
        for (Rule r : rules) {
            Integer p = 0;
            if (r.containsAttribute("priority")) {
                p = Integer.parseInt(r.getAttribute("priority"));
            }
            if (!this.priorityMap.containsKey(p)) {
                this.priorityMap.put(p, new HashSet());
            }
            this.priorityMap.get(p).add(r);
            this.priorities.add(p);
        }
        this.priorityIterator = this.priorities.descendingIterator();
    }

    @Override
    public Collection<Rule> next() {
        return this.priorityMap.get(this.priorityIterator.next());
    }

    @Override
    public boolean hasNext() {
        return this.priorityIterator.hasNext();
    }
}

