/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.strategies;

import java.util.Collection;
import java.util.LinkedList;
import org.kframework.backend.java.kil.Rule;
import org.kframework.backend.java.strategies.Strategy;

public class TransitionStrategy
implements Strategy {
    private Collection<Rule> transition;
    private Collection<Rule> structural;
    private Collection<String> tags;

    public TransitionStrategy(Collection<String> tags) {
        this.tags = tags;
    }

    public boolean nextIsTransition() {
        return this.structural == null && this.transition != null;
    }

    @Override
    public void reset(Collection<Rule> rules) {
        this.transition = new LinkedList<Rule>();
        this.structural = new LinkedList<Rule>();
        for (Rule r : rules) {
            boolean t = false;
            for (String s : this.tags) {
                if (!r.containsAttribute(s)) continue;
                t = true;
                break;
            }
            if (t) {
                this.transition.add(r);
                continue;
            }
            this.structural.add(r);
        }
    }

    @Override
    public Collection<Rule> next() {
        Collection<Rule> n = null;
        if (this.structural != null) {
            n = this.structural;
            this.structural = null;
        } else if (this.transition != null) {
            n = this.transition;
            this.transition = null;
        }
        return n;
    }

    @Override
    public boolean hasNext() {
        return this.structural != null || this.transition != null;
    }
}

