/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.symbolic;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kframework.backend.java.kil.BuiltinList;
import org.kframework.backend.java.kil.BuiltinMap;
import org.kframework.backend.java.kil.BuiltinMgu;
import org.kframework.backend.java.kil.BuiltinSet;
import org.kframework.backend.java.kil.CellCollection;
import org.kframework.backend.java.kil.KCollection;
import org.kframework.backend.java.kil.KItem;
import org.kframework.backend.java.kil.KLabelFreezer;
import org.kframework.backend.java.kil.KLabelInjection;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.Token;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.symbolic.CopyOnWriteTransformer;
import org.kframework.compile.utils.ConfigurationStructureMap;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Bag;
import org.kframework.kil.Cell;
import org.kframework.kil.FreezerLabel;
import org.kframework.kil.Hole;
import org.kframework.kil.KApp;
import org.kframework.kil.KInjectedLabel;
import org.kframework.kil.KItemProjection;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.KSequence;
import org.kframework.kil.ListItem;
import org.kframework.kil.Map;
import org.kframework.kil.MapItem;
import org.kframework.kil.Set;
import org.kframework.kil.SetItem;
import org.kframework.kil.loader.Context;

public class BackendJavaKILtoKILTransformer
extends CopyOnWriteTransformer {
    private final Context context;
    private final ConfigurationStructureMap configurationStructureMap;
    private Cell currentCell;

    public BackendJavaKILtoKILTransformer(Context context) {
        this.context = context;
        this.configurationStructureMap = context.getConfigurationStructureMap();
    }

    @Override
    public ASTNode transform(org.kframework.backend.java.kil.Cell cell) {
        if (cell.getLabel().startsWith("value_cell_label_prefix_")) {
            this.currentCell = this.configurationStructureMap.get((Object)cell.getLabel().substring((int)"value_cell_label_prefix_".length())).cell;
            return cell.getContent().accept(this);
        }
        Cell returnCell = new Cell();
        String label = cell.getLabel();
        this.currentCell = this.configurationStructureMap.get((Object)label).cell;
        returnCell.setLabel(label);
        returnCell.setEndLabel(label);
        returnCell.setContents((org.kframework.kil.Term)cell.getContent().accept(this));
        return returnCell;
    }

    @Override
    public ASTNode transform(CellCollection cellCollection) {
        Multimap<String, org.kframework.backend.java.kil.Cell> cellMap = cellCollection.cellMap();
        List<org.kframework.kil.Term> terms = this.currentCell.getCellTerms();
        ArrayList<org.kframework.kil.Term> contents = new ArrayList<org.kframework.kil.Term>();
        for (org.kframework.kil.Term term : terms) {
            if (!(term instanceof Cell)) continue;
            String key = ((Cell)term).getLabel();
            for (org.kframework.backend.java.kil.Cell cell : cellMap.get(key)) {
                contents.add((Cell)this.transform(cell));
            }
        }
        if (cellCollection.hasFrame()) {
            contents.add((org.kframework.kil.Term)cellCollection.frame().accept(this));
        }
        return new Bag(contents);
    }

    @Override
    public ASTNode transform(org.kframework.backend.java.kil.Hole hole) {
        return Hole.KITEM_HOLE;
    }

    @Override
    public ASTNode transform(KItem kItem) {
        return new KApp((org.kframework.kil.Term)kItem.kLabel().accept(this), (org.kframework.kil.Term)kItem.kList().accept(this));
    }

    @Override
    public ASTNode transform(org.kframework.backend.java.kil.KItemProjection kItemProj) {
        return new KItemProjection(kItemProj.kind().toString(), (org.kframework.kil.Term)kItemProj.term().accept(this));
    }

    @Override
    public ASTNode transform(org.kframework.backend.java.kil.KLabelConstant kLabelConstant) {
        return KLabelConstant.of(kLabelConstant.label(), this.context);
    }

    @Override
    public ASTNode transform(KLabelFreezer kLabelFreezer) {
        return new FreezerLabel((org.kframework.kil.Term)kLabelFreezer.term().accept(this));
    }

    @Override
    public ASTNode transform(KLabelInjection kLabelInjection) {
        return new KInjectedLabel((org.kframework.kil.Term)kLabelInjection.term().accept(this));
    }

    @Override
    public ASTNode transform(org.kframework.backend.java.kil.KList kList) {
        List<org.kframework.kil.Term> terms = this.transformTerms(kList);
        return new KList(terms);
    }

    @Override
    public ASTNode transform(org.kframework.backend.java.kil.KSequence kSequence) {
        List<org.kframework.kil.Term> terms = this.transformTerms(kSequence);
        return new KSequence(terms);
    }

    private List<org.kframework.kil.Term> transformTerms(KCollection kCollection) {
        ArrayList<org.kframework.kil.Term> terms = new ArrayList<org.kframework.kil.Term>();
        for (Term term : kCollection) {
            terms.add((org.kframework.kil.Term)term.accept(this));
        }
        if (kCollection.hasFrame()) {
            terms.add((org.kframework.kil.Term)kCollection.frame().accept(this));
        }
        return terms;
    }

    @Override
    public ASTNode transform(BuiltinSet set) {
        ArrayList<org.kframework.kil.Term> items = new ArrayList<org.kframework.kil.Term>();
        for (Term entry : set.elements()) {
            items.add(new SetItem((org.kframework.kil.Term)entry.accept(this)));
        }
        Collections.sort(items);
        if (set.hasFrame()) {
            items.add((org.kframework.kil.Term)set.frame().accept(this));
        }
        return new Set(items);
    }

    @Override
    public ASTNode transform(BuiltinList builtinList) {
        ArrayList<org.kframework.kil.Term> items = new ArrayList<org.kframework.kil.Term>();
        for (Term entry : builtinList.elementsLeft()) {
            items.add(new ListItem((org.kframework.kil.Term)entry.accept(this)));
        }
        if (builtinList.hasFrame()) {
            items.add((org.kframework.kil.Term)builtinList.frame().accept(this));
        }
        for (Term entry : builtinList.elementsRight()) {
            items.add(new ListItem((org.kframework.kil.Term)entry.accept(this)));
        }
        return new org.kframework.kil.List(items);
    }

    @Override
    public ASTNode transform(BuiltinMap map) {
        java.util.Map<Term, Term> entries = map.getEntries();
        ArrayList<Term> keys = new ArrayList<Term>(entries.keySet());
        Collections.sort(keys);
        ArrayList<org.kframework.kil.Term> items = new ArrayList<org.kframework.kil.Term>();
        for (Term key : keys) {
            Term value = entries.get(key);
            items.add(new MapItem((org.kframework.kil.Term)key.accept(this), (org.kframework.kil.Term)value.accept(this)));
        }
        if (map.hasFrame()) {
            items.add((org.kframework.kil.Term)map.frame().accept(this));
        }
        return new Map(items);
    }

    @Override
    public ASTNode transform(Token token) {
        return org.kframework.kil.Token.kAppOf(token.sort(), token.value());
    }

    @Override
    public ASTNode transform(Variable variable) {
        org.kframework.kil.Variable node = new org.kframework.kil.Variable(variable.name(), variable.sort());
        return node;
    }

    @Override
    public ASTNode transform(BuiltinMgu mgu) {
        return new KApp(new KLabelConstant("'someMgu(" + mgu.constraint().toString() + ")"), new KList());
    }
}

