/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.symbolic;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.Set;
import org.kframework.backend.java.kil.JavaSymbolicObject;
import org.kframework.backend.java.kil.KItem;
import org.kframework.backend.java.kil.KLabel;
import org.kframework.backend.java.kil.KLabelConstant;
import org.kframework.backend.java.kil.KList;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.TermContext;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.symbolic.LocalTransformer;
import org.kframework.backend.java.symbolic.SubstitutionTransformer;
import org.kframework.kil.ASTNode;

public class BinderSubstitutionTransformer
extends SubstitutionTransformer {
    public BinderSubstitutionTransformer(Map<Variable, ? extends Term> substitution, TermContext context) {
        super(substitution, context);
        this.preTransformer.addTransformer(new BinderSubstitution(context));
    }

    private class BinderSubstitution
    extends LocalTransformer {
        public BinderSubstitution(TermContext context) {
            super(context);
        }

        @Override
        public ASTNode transform(KItem kItem) {
            KLabelConstant kLabelConstant;
            if (!(kItem.kLabel() instanceof KLabel) || !(kItem.kList() instanceof KList)) {
                return super.transform(kItem);
            }
            assert (kItem.kLabel() instanceof KLabel) : "KLabel variables are not supported";
            assert (kItem.kList() instanceof KList) : "KList must be concrete";
            KLabel kLabel = (KLabel)kItem.kLabel();
            KList kList = (KList)kItem.kList();
            if (kLabel instanceof KLabelConstant && (kLabelConstant = (KLabelConstant)kLabel).isBinder()) {
                assert (kList.getContents().size() == 2 && !kList.hasFrame()) : "Only supporting binders of the form lambda x. e for now";
                Term boundVars = kList.get(0);
                Term bindingExp = kList.get(1);
                Set<Variable> variables = boundVars.variableSet();
                Map<Variable, Variable> freshSubstitution = Variable.getFreshSubstitution(variables);
                JavaSymbolicObject freshBoundVars = boundVars.substitute(freshSubstitution, this.context);
                JavaSymbolicObject freshbindingExp = bindingExp.substitute(freshSubstitution, this.context);
                kList = new KList(ImmutableList.of(freshBoundVars, freshbindingExp));
                kItem = new KItem(kLabel, kList, this.context);
            }
            return super.transform(kItem);
        }
    }
}

