/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.symbolic;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.kframework.backend.java.kil.Definition;
import org.kframework.backend.java.kil.KLabelConstant;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.TermContext;
import org.kframework.kil.Production;
import org.kframework.krun.K;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.file.FileUtil;
import org.kframework.utils.file.KPaths;
import org.kframework.utils.general.GlobalSettings;

public class BuiltinFunction {
    private static final String hookPropertiesFileName = "hooks.properties";
    private static final ImmutableSet hookMetaModules = ImmutableSet.of("#META-K", "MetaK", "Visitor", "#IO");
    private static final Map<KLabelConstant, Method> table = new HashMap<KLabelConstant, Method>();

    public static void init(Definition definition) {
        try {
            String separator = System.getProperty("file.separator");
            String path = KPaths.getKBase(false) + separator + "include" + separator + "java";
            Properties properties = new Properties();
            FileUtil.loadProperties(properties, path + separator + hookPropertiesFileName);
            for (String label : definition.context().labels.keySet()) {
                block5: for (Production production : definition.context().productionsOf(label)) {
                    if (!production.getKLabel().equals(label) || !production.containsAttribute("hook")) continue;
                    String hookAttribute = production.getAttribute("hook");
                    String hookPrefix = hookAttribute.substring(0, hookAttribute.indexOf(":"));
                    if (K.do_kompilation && hookMetaModules.contains(hookPrefix)) continue;
                    String hook = properties.getProperty(hookAttribute);
                    if (hook == null) {
                        GlobalSettings.kem.register(new KException(KException.ExceptionType.HIDDENWARNING, KException.KExceptionGroup.CRITICAL, "missing entry in hooks.properties for hook " + hookAttribute, production.getFilename(), production.getLocation()));
                        continue;
                    }
                    try {
                        String className = hook.substring(0, hook.lastIndexOf(46));
                        String methodName = hook.substring(hook.lastIndexOf(46) + 1);
                        Class<?> c = Class.forName(className);
                        for (Method method : c.getDeclaredMethods()) {
                            if (!method.getName().equals(methodName)) continue;
                            table.put(KLabelConstant.of(label, TermContext.of(definition)), method);
                            continue block5;
                        }
                    }
                    catch (Exception e) {
                        GlobalSettings.kem.register(new KException(KException.ExceptionType.WARNING, KException.KExceptionGroup.CRITICAL, "missing implementation for hook " + hookAttribute + ":\n" + hook, production.getFilename(), production.getLocation()));
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Term invoke(TermContext context, KLabelConstant label, Term ... arguments) throws IllegalAccessException, IllegalArgumentException {
        Object[] args = Arrays.copyOf(arguments, arguments.length + 1, Object[].class);
        args[arguments.length] = context;
        try {
            Method method = table.get(label);
            Term t = (Term)method.invoke(null, args);
            return t;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            assert (false) : "Builtin functions should not throw checked exceptions";
            return null;
        }
    }

    public static boolean isBuiltinKLabel(KLabelConstant label) {
        return table.containsKey(label);
    }
}

