/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.symbolic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kframework.backend.java.kil.KItem;
import org.kframework.backend.java.kil.KLabelConstant;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.symbolic.KastStructureCheckerPlugin;
import org.kframework.backend.java.symbolic.LocalVisitor;
import org.kframework.backend.java.symbolic.PluggableKastStructureChecker;
import org.kframework.kil.Production;

public class CheckingNestedStructureDepth
implements KastStructureCheckerPlugin {
    private final Map<String, Integer> nestedLevelOfSort = new HashMap<String, Integer>();
    private final Map<String, Integer> maxNestedLevelOfSort = new HashMap<String, Integer>();
    private final LocalVisitor preVisitor = new IncNestedLevelOfSort();
    private final LocalVisitor postVisitor = new DecNestedLevelOfSort();
    private PluggableKastStructureChecker checker;
    private static final Map<KLabelConstant, Set<String>> cachedSortsOfKLabel = new HashMap<KLabelConstant, Set<String>>();

    public CheckingNestedStructureDepth() {
        this.setMaxNestedLevelOf("AExp", 2);
        this.setMaxNestedLevelOf("BExp", 1);
        this.setMaxNestedLevelOf("Block", 2);
    }

    @Override
    public void registerTo(PluggableKastStructureChecker checker) {
        assert (this.checker == null);
        this.checker = checker;
    }

    @Override
    public void reset() {
        this.nestedLevelOfSort.clear();
        this.preVisitor.resetProceed();
        this.postVisitor.resetProceed();
    }

    @Override
    public LocalVisitor getPreVisitor() {
        return this.preVisitor;
    }

    @Override
    public LocalVisitor getPostVisitor() {
        return this.postVisitor;
    }

    public void setMaxNestedLevelOf(String sort, int level) {
        this.maxNestedLevelOfSort.put(sort, level);
    }

    private Set<String> computeSortsOf(KLabelConstant kLabel) {
        Set<String> sorts = cachedSortsOfKLabel.get(kLabel);
        if (sorts == null) {
            HashSet<String> set = new HashSet<String>();
            for (Production prod : kLabel.productions()) {
                set.add(prod.getSort());
            }
            cachedSortsOfKLabel.put(kLabel, set);
            sorts = set;
        }
        return sorts;
    }

    private class DecNestedLevelOfSort
    extends LocalVisitor {
        private DecNestedLevelOfSort() {
        }

        @Override
        public void visit(KItem kItem) {
            if (!(kItem.kLabel() instanceof KLabelConstant)) {
                return;
            }
            KLabelConstant kLabel = (KLabelConstant)kItem.kLabel();
            for (String sort : CheckingNestedStructureDepth.this.computeSortsOf(kLabel)) {
                CheckingNestedStructureDepth.this.nestedLevelOfSort.put(sort, (Integer)CheckingNestedStructureDepth.this.nestedLevelOfSort.get(sort) - 1);
            }
        }

        @Override
        public void visit(Variable variable) {
            CheckingNestedStructureDepth.this.nestedLevelOfSort.put(variable.sort(), (Integer)CheckingNestedStructureDepth.this.nestedLevelOfSort.get(variable.sort()) - 1);
        }
    }

    private class IncNestedLevelOfSort
    extends LocalVisitor {
        private IncNestedLevelOfSort() {
        }

        @Override
        public void visit(KItem kItem) {
            if (!(kItem.kLabel() instanceof KLabelConstant)) {
                return;
            }
            KLabelConstant kLabel = (KLabelConstant)kItem.kLabel();
            for (String sort : CheckingNestedStructureDepth.this.computeSortsOf(kLabel)) {
                this.check(sort);
            }
        }

        @Override
        public void visit(Variable variable) {
            this.check(variable.sort());
        }

        private void check(String sort) {
            if (CheckingNestedStructureDepth.this.nestedLevelOfSort.get(sort) == null) {
                CheckingNestedStructureDepth.this.nestedLevelOfSort.put(sort, 0);
            }
            int depth = (Integer)CheckingNestedStructureDepth.this.nestedLevelOfSort.get(sort) + 1;
            Integer maxDepth = (Integer)CheckingNestedStructureDepth.this.maxNestedLevelOfSort.get(sort);
            if (maxDepth != null && depth > maxDepth) {
                this.proceed = false;
                CheckingNestedStructureDepth.this.checker.flagFailure(CheckingNestedStructureDepth.this);
                return;
            }
            CheckingNestedStructureDepth.this.nestedLevelOfSort.put(sort, depth);
        }
    }
}

