/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.symbolic;

import java.io.File;
import java.io.IOException;
import org.kframework.backend.BasicBackend;
import org.kframework.backend.java.indexing.IndexingTable;
import org.kframework.backend.java.indexing.pathIndex.PathIndex;
import org.kframework.backend.java.symbolic.KILtoBackendJavaKILTransformer;
import org.kframework.compile.FlattenModules;
import org.kframework.compile.ResolveConfigurationAbstraction;
import org.kframework.compile.checks.CheckConfigurationCells;
import org.kframework.compile.checks.CheckRewrite;
import org.kframework.compile.checks.CheckVariables;
import org.kframework.compile.sharing.DeclareCellLabels;
import org.kframework.compile.tags.AddDefaultComputational;
import org.kframework.compile.tags.AddOptionalTags;
import org.kframework.compile.tags.AddStrictStar;
import org.kframework.compile.transformers.AddEmptyLists;
import org.kframework.compile.transformers.AddHeatingConditions;
import org.kframework.compile.transformers.AddInjections;
import org.kframework.compile.transformers.AddKCell;
import org.kframework.compile.transformers.AddPredicates;
import org.kframework.compile.transformers.AddStreamCells;
import org.kframework.compile.transformers.AddTopCellConfig;
import org.kframework.compile.transformers.AddTopCellRules;
import org.kframework.compile.transformers.Cell2DataStructure;
import org.kframework.compile.transformers.CompleteSortLatice;
import org.kframework.compile.transformers.ContextsToHeating;
import org.kframework.compile.transformers.DataStructureToLookupUpdate;
import org.kframework.compile.transformers.DesugarStreams;
import org.kframework.compile.transformers.FlattenSyntax;
import org.kframework.compile.transformers.FreezeUserFreezers;
import org.kframework.compile.transformers.RemoveBrackets;
import org.kframework.compile.transformers.RemovePreincludedRules;
import org.kframework.compile.transformers.RemoveSyntacticCasts;
import org.kframework.compile.transformers.ResolveAnonymousVariables;
import org.kframework.compile.transformers.ResolveBinder;
import org.kframework.compile.transformers.ResolveBlockingInput;
import org.kframework.compile.transformers.ResolveBuiltins;
import org.kframework.compile.transformers.ResolveFunctions;
import org.kframework.compile.transformers.ResolveHybrid;
import org.kframework.compile.transformers.ResolveListOfK;
import org.kframework.compile.transformers.ResolveOpenCells;
import org.kframework.compile.transformers.ResolveRewrite;
import org.kframework.compile.transformers.SetVariablesInferredSort;
import org.kframework.compile.transformers.StrictnessToContexts;
import org.kframework.compile.utils.CheckVisitorStep;
import org.kframework.compile.utils.CompileDataStructures;
import org.kframework.compile.utils.CompileToBuiltins;
import org.kframework.compile.utils.CompilerSteps;
import org.kframework.compile.utils.InitializeConfigurationStructure;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Definition;
import org.kframework.kil.loader.AddConsesVisitor;
import org.kframework.kil.loader.CollectConsesVisitor;
import org.kframework.kil.loader.CollectSubsortsVisitor;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.main.FirstStep;
import org.kframework.main.LastStep;
import org.kframework.utils.BinaryLoader;
import org.kframework.utils.Stopwatch;
import org.kframework.utils.general.GlobalSettings;

public class JavaSymbolicBackend
extends BasicBackend {
    public static final String DEFINITION_FILENAME = "java_symbolic_definition.bin";
    public static final String RULE_TABLE_INDEX = "table";
    public static final String PATH_INDEX = "path";

    public JavaSymbolicBackend(Stopwatch sw, Context context) {
        super(sw, context);
    }

    @Override
    public Definition lastStep(Definition javaDef) {
        org.kframework.backend.java.kil.Definition definition = new KILtoBackendJavaKILTransformer(this.context, true).transformDefinition(javaDef);
        if (GlobalSettings.ruleIndex.equals(RULE_TABLE_INDEX)) {
            definition.setIndex(new IndexingTable(definition));
        } else if (GlobalSettings.ruleIndex.equals(PATH_INDEX)) {
            definition.setIndex(new PathIndex(definition));
        }
        assert (definition.getIndex() != null);
        BinaryLoader.save(new File(this.context.dotk, DEFINITION_FILENAME).toString(), definition);
        return javaDef;
    }

    @Override
    public void run(Definition def) throws IOException {
    }

    @Override
    public String getDefaultStep() {
        return "LastStep";
    }

    @Override
    public CompilerSteps<Definition> getCompilationSteps() {
        CompilerSteps<Definition> steps = new CompilerSteps<Definition>(this.context);
        steps.add(new FirstStep(this, this.context));
        steps.add(new CheckVisitorStep(new CheckConfigurationCells(this.context), this.context));
        steps.add(new RemoveBrackets(this.context));
        steps.add(new SetVariablesInferredSort(this.context));
        steps.add(new AddEmptyLists(this.context));
        steps.add(new RemoveSyntacticCasts(this.context));
        steps.add(new CheckVisitorStep(new CheckVariables(this.context), this.context));
        steps.add(new CheckVisitorStep(new CheckRewrite(this.context), this.context));
        steps.add(new FlattenModules(this.context));
        steps.add(new CompleteSortLatice(this.context));
        steps.add(new CheckVisitorStep(new AddConsesVisitor(this.context), this.context));
        steps.add(new CheckVisitorStep(new CollectConsesVisitor(this.context), this.context));
        steps.add(new CheckVisitorStep(new CollectSubsortsVisitor(this.context), this.context));
        steps.add(new DefinitionSerializer(this.context));
        steps.add(new StrictnessToContexts(this.context));
        steps.add(new FreezeUserFreezers(this.context));
        steps.add(new ContextsToHeating(this.context));
        steps.add(new AddHeatingConditions(this.context));
        steps.add(new DesugarStreams(this.context, true));
        steps.add(new ResolveFunctions(this.context));
        steps.add(new AddKCell(this.context));
        steps.add(new AddStreamCells(this.context));
        steps.add(new AddTopCellConfig(this.context));
        steps.add(new AddTopCellRules(this.context));
        steps.add(new ResolveBinder(this.context));
        steps.add(new ResolveAnonymousVariables(this.context));
        steps.add(new AddPredicates(this.context));
        steps.add(new ResolveBuiltins(this.context));
        steps.add(new ResolveListOfK(this.context));
        steps.add(new AddInjections(this.context));
        steps.add(new FlattenSyntax(this.context));
        steps.add(new ResolveBlockingInput(this.context, false));
        steps.add(new InitializeConfigurationStructure(this.context));
        steps.add(new ResolveHybrid(this.context));
        steps.add(new ResolveConfigurationAbstraction(this.context));
        steps.add(new ResolveOpenCells(this.context));
        steps.add(new ResolveRewrite(this.context));
        steps.add(new CompileToBuiltins(this.context));
        steps.add(new CompileDataStructures(this.context));
        steps.add(new Cell2DataStructure(this.context));
        steps.add(new DataStructureToLookupUpdate(this.context));
        steps.add(new AddStrictStar(this.context));
        steps.add(new AddDefaultComputational(this.context));
        steps.add(new AddOptionalTags(this.context));
        steps.add(new DeclareCellLabels(this.context));
        steps.add(new RemovePreincludedRules(this.context));
        steps.add(new LastStep(this, this.context));
        return steps;
    }

    private class DefinitionSerializer
    extends CopyOnWriteTransformer {
        public DefinitionSerializer(Context context) {
            super("Serialize Compiled Definition to XML", context);
        }

        @Override
        public ASTNode transform(Definition node) throws TransformerException {
            BinaryLoader.save(new File(this.context.dotk, "defx-java.bin").toString(), node);
            return node;
        }
    }
}

