/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.symbolic;

import edu.uci.ics.jung.graph.DirectedGraph;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kframework.backend.java.kil.ConstrainedTerm;
import org.kframework.backend.java.kil.Definition;
import org.kframework.backend.java.kil.JavaSymbolicObject;
import org.kframework.backend.java.kil.Rule;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.TermContext;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.symbolic.BackendJavaKILtoKILTransformer;
import org.kframework.backend.java.symbolic.BottomUpVisitor;
import org.kframework.backend.java.symbolic.BuiltinFunction;
import org.kframework.backend.java.symbolic.KILtoBackendJavaKILTransformer;
import org.kframework.backend.java.symbolic.SpecificationCompilerSteps;
import org.kframework.backend.java.symbolic.SymbolicConstraint;
import org.kframework.backend.java.symbolic.SymbolicRewriter;
import org.kframework.backend.java.util.TestCaseGenerationUtil;
import org.kframework.backend.unparser.UnparserFilter;
import org.kframework.compile.transformers.DataStructureToLookupUpdate;
import org.kframework.compile.utils.CompileToBuiltins;
import org.kframework.compile.utils.CompilerStepDone;
import org.kframework.compile.utils.ConfigurationSubstitutionVisitor;
import org.kframework.compile.utils.MetaK;
import org.kframework.compile.utils.RuleCompilerSteps;
import org.kframework.compile.utils.Substitution;
import org.kframework.kil.Bag;
import org.kframework.kil.Cell;
import org.kframework.kil.GenericToken;
import org.kframework.kil.IntBuiltin;
import org.kframework.kil.KSequence;
import org.kframework.kil.MapBuiltin;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.Rewrite;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.krun.K;
import org.kframework.krun.KRunExecutionException;
import org.kframework.krun.SubstitutionFilter;
import org.kframework.krun.api.KRun;
import org.kframework.krun.api.KRunDebugger;
import org.kframework.krun.api.KRunProofResult;
import org.kframework.krun.api.KRunResult;
import org.kframework.krun.api.KRunState;
import org.kframework.krun.api.SearchResult;
import org.kframework.krun.api.SearchResults;
import org.kframework.krun.api.SearchType;
import org.kframework.krun.api.TestGenResult;
import org.kframework.krun.api.TestGenResults;
import org.kframework.krun.api.Transition;
import org.kframework.krun.api.UnsupportedBackendOptionException;
import org.kframework.krun.ioserver.filesystem.portable.PortableFileSystem;
import org.kframework.utils.BinaryLoader;
import org.kframework.utils.general.IndexingStatistics;

public class JavaSymbolicKRun
implements KRun {
    private final Definition definition;
    private final Context context;
    private final KILtoBackendJavaKILTransformer transformer;
    private SymbolicRewriter simulationRewriter;

    public JavaSymbolicKRun(Context context) throws KRunExecutionException {
        this.definition = (Definition)BinaryLoader.load(new File(context.kompiled, "java_symbolic_definition.bin").toString());
        if (this.definition == null) {
            throw new KRunExecutionException("cannot load definition");
        }
        BuiltinFunction.init(this.definition);
        this.context = this.definition.context();
        this.context.kompiled = context.kompiled;
        this.transformer = new KILtoBackendJavaKILTransformer(this.context);
    }

    public Definition getDefinition() {
        return this.definition;
    }

    @Override
    public KRunResult<KRunState> run(org.kframework.kil.Term cfg) throws KRunExecutionException {
        if (K.get_indexing_stats) {
            IndexingStatistics.totalKrunStopwatch.start();
            KRunResult<KRunState> result = this.internalRun(cfg, -1);
            IndexingStatistics.totalKrunStopwatch.stop();
            IndexingStatistics.print();
            return result;
        }
        return this.internalRun(cfg, -1);
    }

    private KRunResult<KRunState> internalRun(org.kframework.kil.Term cfg, int bound) throws KRunExecutionException {
        ConstrainedTerm result = this.javaKILRun(cfg, bound);
        org.kframework.kil.Term kilTerm = (org.kframework.kil.Term)result.term().accept(new BackendJavaKILtoKILTransformer(this.context));
        KRunResult<KRunState> returnResult = new KRunResult<KRunState>(new KRunState(kilTerm, this.context));
        UnparserFilter unparser = new UnparserFilter(true, K.color, K.parens, this.context);
        kilTerm.accept(unparser);
        returnResult.setRawOutput(unparser.getResult());
        return returnResult;
    }

    private ConstrainedTerm javaKILRun(org.kframework.kil.Term cfg, int bound) {
        ConstrainedTerm rewriteResult;
        if (K.get_indexing_stats) {
            IndexingStatistics.preProcessStopWatch.start();
        }
        SymbolicRewriter symbolicRewriter = new SymbolicRewriter(this.definition);
        Term term = Term.of(cfg, this.definition);
        TermContext termContext = TermContext.of(this.definition, new PortableFileSystem());
        SymbolicConstraint constraint = new SymbolicConstraint(termContext);
        term = term.evaluate(termContext);
        ConstrainedTerm constrainedTerm = new ConstrainedTerm(term, constraint, termContext);
        if (K.get_indexing_stats) {
            IndexingStatistics.preProcessStopWatch.stop();
        }
        if (K.get_indexing_stats) {
            IndexingStatistics.totalRewriteStopwatch.start();
            rewriteResult = symbolicRewriter.rewrite(constrainedTerm, bound);
            IndexingStatistics.totalRewriteStopwatch.stop();
        } else {
            rewriteResult = symbolicRewriter.rewrite(constrainedTerm, bound);
        }
        return rewriteResult;
    }

    @Override
    public KRunProofResult<Set<org.kframework.kil.Term>> prove(Module module, org.kframework.kil.Term cfg) throws KRunExecutionException {
        TermContext termContext;
        block11: {
            termContext = TermContext.of(this.definition, new PortableFileSystem());
            Map<org.kframework.kil.Term, org.kframework.kil.Term> substitution = null;
            if (cfg != null) {
                Module mod;
                block10: {
                    cfg = this.run(cfg).getResult().getRawResult();
                    ConfigurationSubstitutionVisitor configurationSubstitutionVisitor = new ConfigurationSubstitutionVisitor(this.context);
                    cfg.accept(configurationSubstitutionVisitor);
                    substitution = configurationSubstitutionVisitor.getSubstitution();
                    mod = module;
                    try {
                        mod = (Module)module.accept(new Substitution(substitution, this.context));
                    }
                    catch (TransformerException e) {
                        if ($assertionsDisabled) break block10;
                        throw new AssertionError((Object)"This should not have happened!");
                    }
                }
                module = mod;
            }
            try {
                module = new SpecificationCompilerSteps(this.context).compile(module, null);
            }
            catch (CompilerStepDone e) {
                if ($assertionsDisabled) break block11;
                throw new AssertionError((Object)"dead code");
            }
        }
        ArrayList<ConstrainedTerm> proofResults = new ArrayList<ConstrainedTerm>();
        DataStructureToLookupUpdate mapTransformer = new DataStructureToLookupUpdate(this.context);
        try {
            ArrayList<Rule> rules = new ArrayList<Rule>();
            for (ModuleItem moduleItem : module.getItems()) {
                assert (moduleItem instanceof org.kframework.kil.Rule);
                Rule rule = this.transformer.transformRule((org.kframework.kil.Rule)moduleItem.accept(mapTransformer), this.definition);
                Rule freshRule = rule.getFreshRule(termContext);
            }
            SymbolicRewriter symbolicRewriter = new SymbolicRewriter(this.definition);
            for (ModuleItem moduleItem : module.getItems()) {
                org.kframework.kil.Rule kilRule = (org.kframework.kil.Rule)moduleItem;
                org.kframework.kil.Term kilLeftHandSide = ((Rewrite)kilRule.getBody()).getLeft();
                org.kframework.kil.Term kilRightHandSide = ((Rewrite)kilRule.getBody()).getRight();
                org.kframework.kil.Term kilRequires = kilRule.getRequires();
                org.kframework.kil.Term kilEnsures = kilRule.getEnsures();
                org.kframework.kil.Rule kilDummyRule = new org.kframework.kil.Rule(kilRightHandSide, MetaK.kWrap(KSequence.EMPTY, "k"), kilRequires, kilEnsures, this.context);
                Rule dummyRule = this.transformer.transformRule((org.kframework.kil.Rule)kilDummyRule.accept(mapTransformer), this.definition);
                SymbolicConstraint initialConstraint = new SymbolicConstraint(termContext);
                initialConstraint.addAll(dummyRule.requires());
                ConstrainedTerm initialTerm = new ConstrainedTerm(this.transformer.transformTerm(kilLeftHandSide, this.definition), initialConstraint, termContext);
                SymbolicConstraint targetConstraint = new SymbolicConstraint(termContext);
                targetConstraint.addAll(dummyRule.ensures());
                ConstrainedTerm targetTerm = new ConstrainedTerm(dummyRule.leftHandSide(), dummyRule.lookups().getSymbolicConstraint(termContext), targetConstraint, termContext);
                proofResults.addAll(symbolicRewriter.proveRule(initialTerm, targetTerm, rules));
            }
            System.err.println(proofResults.isEmpty());
            System.err.println(proofResults);
            return new KRunProofResult<Set<org.kframework.kil.Term>>(proofResults.isEmpty(), Collections.emptySet());
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public KRunResult<SearchResults> search(Integer bound, Integer depth, SearchType searchType, org.kframework.kil.Rule pattern, org.kframework.kil.Term cfg, RuleCompilerSteps compilationInfo) throws KRunExecutionException {
        SymbolicRewriter symbolicRewriter = new SymbolicRewriter(this.definition);
        PortableFileSystem fs = new PortableFileSystem();
        CompileToBuiltins builtinTransformer = new CompileToBuiltins(this.context);
        try {
            pattern = (org.kframework.kil.Rule)builtinTransformer.transform(pattern);
            cfg = (org.kframework.kil.Term)cfg.accept(builtinTransformer);
        }
        catch (TransformerException e) {
            e.report();
        }
        TermContext termContext = TermContext.of(this.definition, fs);
        ConstrainedTerm initialTerm = new ConstrainedTerm(Term.of(cfg, this.definition), termContext);
        ConstrainedTerm targetTerm = new ConstrainedTerm(Term.of(cfg, this.definition), termContext);
        List<Rule> claims = Collections.emptyList();
        if (bound == null) {
            bound = -1;
        }
        if (depth == null) {
            depth = -1;
        }
        Cell c = new Cell();
        c.setLabel("generatedTop");
        c.setContents(new Bag());
        pattern.setBody(new Rewrite(pattern.getBody(), c, this.context));
        Rule patternRule = this.transformer.transformRule(pattern, this.definition);
        ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
        List<Map<Variable, Term>> hits = symbolicRewriter.search(initialTerm, targetTerm, claims, patternRule, bound, depth, searchType);
        for (Map<Variable, Term> map : hits) {
            HashMap<String, org.kframework.kil.Term> substitutionMap = new HashMap<String, org.kframework.kil.Term>();
            for (Variable var : map.keySet()) {
                org.kframework.kil.Term kilTerm = (org.kframework.kil.Term)map.get(var).accept(new BackendJavaKILtoKILTransformer(this.context));
                substitutionMap.put(var.toString(), kilTerm);
            }
            try {
                org.kframework.kil.Term rawResult = (org.kframework.kil.Term)pattern.getBody().accept(new SubstitutionFilter(substitutionMap, this.context));
                searchResults.add(new SearchResult(new KRunState(rawResult, this.context), substitutionMap, compilationInfo, this.context));
            }
            catch (TransformerException e) {
                e.report();
            }
        }
        return new KRunResult<SearchResults>(new SearchResults(searchResults, null, false, this.context));
    }

    @Override
    public KRunResult<TestGenResults> generate(Integer bound, Integer depth, SearchType searchType, org.kframework.kil.Rule pattern, org.kframework.kil.Term cfg, RuleCompilerSteps compilationInfo) throws KRunExecutionException {
        if (searchType != SearchType.STAR) {
            throw new UnsupportedOperationException("Search type should be SearchType.STAR");
        }
        org.kframework.kil.Term o = ((Bag)((Cell)cfg).getContents()).getContents().get(0);
        o = ((Bag)((Cell)o).getContents()).getContents().get(1);
        HashMap<org.kframework.kil.Term, org.kframework.kil.Term> stateMap = new HashMap<org.kframework.kil.Term, org.kframework.kil.Term>();
        stateMap.put(GenericToken.kAppOf("Id", "x"), IntBuiltin.kAppOf("3"));
        stateMap.put(GenericToken.kAppOf("Id", "$1"), IntBuiltin.kAppOf("1"));
        ((Cell)o).setContents(new MapBuiltin(this.context.dataStructureSortOf("MyMap"), Collections.emptyList(), stateMap));
        SymbolicRewriter symbolicRewriter = new SymbolicRewriter(this.definition);
        final TermContext termContext = TermContext.of(this.definition, new PortableFileSystem());
        ConstrainedTerm initCfg = new ConstrainedTerm(Term.of(cfg, this.definition), termContext);
        ArrayList<TestGenResult> generatorResults = new ArrayList<TestGenResult>();
        ArrayList<String> strRules = new ArrayList<String>();
        for (Rule rule : this.definition.rules()) {
            strRules.add(rule.toString());
        }
        Collections.sort(strRules);
        for (String s : strRules) {
            System.out.println(s);
        }
        if (bound == null) {
            bound = -1;
        }
        if (depth == null) {
            depth = -1;
        }
        for (Rule rule : this.definition.functionRules().values()) {
            System.out.println(rule);
        }
        List<ConstrainedTerm> resultCfgs = symbolicRewriter.generate(initCfg, null, null, bound, depth);
        for (ConstrainedTerm result : resultCfgs) {
            JavaSymbolicObject pgm = Term.of(cfg, this.definition);
            pgm = ((Term)pgm).substituteWithBinders(result.constraint().substitution(), termContext);
            final HashMap subst = new HashMap();
            pgm.accept(new BottomUpVisitor(){

                @Override
                public void visit(Variable var) {
                    subst.put(var, TestCaseGenerationUtil.getSimplestTermOfSort(var.sort(), termContext));
                }
            });
            pgm = ((Term)pgm).substituteWithBinders((Map)subst, termContext);
            org.kframework.kil.Term pgmTerm = (org.kframework.kil.Term)pgm.accept(new BackendJavaKILtoKILTransformer(this.context));
            org.kframework.kil.Term kilTerm = (org.kframework.kil.Term)result.term().accept(new BackendJavaKILtoKILTransformer(this.context));
            generatorResults.add(new TestGenResult(new KRunState(kilTerm, this.context), Collections.singletonMap("B:Bag", kilTerm), compilationInfo, this.context, pgmTerm, result.constraint()));
        }
        return new KRunResult<TestGenResults>(new TestGenResults(generatorResults, null, true, this.context));
    }

    @Override
    public KRunProofResult<DirectedGraph<KRunState, Transition>> modelCheck(org.kframework.kil.Term formula, org.kframework.kil.Term cfg) throws KRunExecutionException {
        throw new UnsupportedBackendOptionException("--ltlmc");
    }

    @Override
    public KRunResult<KRunState> step(org.kframework.kil.Term cfg, int steps) throws KRunExecutionException {
        return this.internalRun(cfg, steps);
    }

    public SymbolicRewriter getSimulationRewriter() {
        return this.simulationRewriter;
    }

    public void initialSimulationRewriter() {
        this.simulationRewriter = new SymbolicRewriter(this.definition);
    }

    public ConstrainedTerm simulationSteps(ConstrainedTerm cfg) throws KRunExecutionException {
        ConstrainedTerm result = this.simulationRewriter.computeSimulationStep(cfg);
        return result;
    }

    public ArrayList<ConstrainedTerm> steps(ConstrainedTerm cfg) throws KRunExecutionException {
        ArrayList<ConstrainedTerm> results = this.simulationRewriter.rewriteAll(cfg);
        return results;
    }

    @Override
    public KRunDebugger debug(org.kframework.kil.Term cfg) {
        throw new UnsupportedBackendOptionException("--debug");
    }

    @Override
    public KRunDebugger debug(DirectedGraph<KRunState, Transition> graph) {
        throw new UnsupportedBackendOptionException("--debug");
    }

    @Override
    public void setBackendOption(String key, Object value) {
    }
}

