/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.symbolic;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kframework.backend.java.builtins.BoolToken;
import org.kframework.backend.java.builtins.Int32Token;
import org.kframework.backend.java.builtins.IntToken;
import org.kframework.backend.java.builtins.StringToken;
import org.kframework.backend.java.builtins.UninterpretedToken;
import org.kframework.backend.java.kil.BuiltinList;
import org.kframework.backend.java.kil.BuiltinMap;
import org.kframework.backend.java.kil.BuiltinMgu;
import org.kframework.backend.java.kil.BuiltinSet;
import org.kframework.backend.java.kil.CellCollection;
import org.kframework.backend.java.kil.ConcreteCollectionVariable;
import org.kframework.backend.java.kil.Definition;
import org.kframework.backend.java.kil.Hole;
import org.kframework.backend.java.kil.KItem;
import org.kframework.backend.java.kil.KLabelFreezer;
import org.kframework.backend.java.kil.KLabelInjection;
import org.kframework.backend.java.kil.KSequence;
import org.kframework.backend.java.kil.Kind;
import org.kframework.backend.java.kil.ListLookup;
import org.kframework.backend.java.kil.MapKeyChoice;
import org.kframework.backend.java.kil.Rule;
import org.kframework.backend.java.kil.SetElementChoice;
import org.kframework.backend.java.kil.SetLookup;
import org.kframework.backend.java.kil.TermContext;
import org.kframework.backend.java.kil.Token;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.symbolic.BuiltinFunction;
import org.kframework.backend.java.symbolic.MacroExpander;
import org.kframework.backend.java.symbolic.UninterpretedConstraint;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Attribute;
import org.kframework.kil.Bag;
import org.kframework.kil.BoolBuiltin;
import org.kframework.kil.BuiltinLookup;
import org.kframework.kil.Cell;
import org.kframework.kil.DataStructureSort;
import org.kframework.kil.FreezerHole;
import org.kframework.kil.FreezerLabel;
import org.kframework.kil.GenericToken;
import org.kframework.kil.Int32Builtin;
import org.kframework.kil.IntBuiltin;
import org.kframework.kil.KApp;
import org.kframework.kil.KInjectedLabel;
import org.kframework.kil.KItemProjection;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.ListBuiltin;
import org.kframework.kil.ListUpdate;
import org.kframework.kil.Map;
import org.kframework.kil.MapBuiltin;
import org.kframework.kil.MapLookup;
import org.kframework.kil.MapUpdate;
import org.kframework.kil.Module;
import org.kframework.kil.Production;
import org.kframework.kil.Rewrite;
import org.kframework.kil.SetBuiltin;
import org.kframework.kil.SetUpdate;
import org.kframework.kil.StringBuiltin;
import org.kframework.kil.Term;
import org.kframework.kil.TermComment;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.CopyOnWriteTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;

public class KILtoBackendJavaKILTransformer
extends CopyOnWriteTransformer {
    private boolean freshRules = false;
    private Definition definition = null;
    private java.util.Map<org.kframework.kil.Variable, Integer> concreteCollectionSize = Collections.emptyMap();

    public KILtoBackendJavaKILTransformer(Context context) {
        super("Transform KIL into java backend KIL", context);
    }

    public KILtoBackendJavaKILTransformer(Context context, boolean freshRules) {
        this(context);
        this.freshRules = freshRules;
    }

    public Definition transformDefinition(org.kframework.kil.Definition node) {
        try {
            Definition transformedDef = (Definition)node.accept(this);
            BuiltinFunction.init(transformedDef);
            Definition expandedDefinition = new MacroExpander(transformedDef).processDefinition();
            return KILtoBackendJavaKILTransformer.evaluateDefinition(expandedDefinition);
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rule transformRule(org.kframework.kil.Rule node, Definition definition) {
        this.definition = definition;
        Rule rule = null;
        try {
            rule = new MacroExpander(definition).processRule((Rule)node.accept(this));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        finally {
            this.definition = null;
        }
        return rule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.kframework.backend.java.kil.Term transformTerm(Term node, Definition definition) {
        this.definition = definition;
        org.kframework.backend.java.kil.Term term = null;
        try {
            term = new MacroExpander(definition).processTerm((org.kframework.backend.java.kil.Term)node.accept(this));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        finally {
            this.definition = null;
        }
        return term;
    }

    @Override
    public ASTNode transform(KApp node) throws TransformerException {
        if (node.getLabel() instanceof org.kframework.kil.Token) {
            if (node.getLabel() instanceof BoolBuiltin) {
                return BoolToken.of(((BoolBuiltin)node.getLabel()).booleanValue());
            }
            if (node.getLabel() instanceof IntBuiltin) {
                return IntToken.of(((IntBuiltin)node.getLabel()).bigIntegerValue());
            }
            if (node.getLabel() instanceof Int32Builtin) {
                return Int32Token.of(((Int32Builtin)node.getLabel()).intValue());
            }
            if (node.getLabel() instanceof StringBuiltin) {
                return StringToken.of(((StringBuiltin)node.getLabel()).stringValue());
            }
            if (node.getLabel() instanceof GenericToken) {
                return UninterpretedToken.of(((GenericToken)node.getLabel()).tokenSort(), ((GenericToken)node.getLabel()).value());
            }
            assert (false) : "unsupported Token " + node.getLabel();
        }
        org.kframework.backend.java.kil.Term kLabel = (org.kframework.backend.java.kil.Term)node.getLabel().accept(this);
        org.kframework.backend.java.kil.Term kList = (org.kframework.backend.java.kil.Term)node.getChild().accept(this);
        if (kList instanceof Variable) {
            kList = new org.kframework.backend.java.kil.KList((Variable)kList);
        }
        return new KItem(kLabel, kList, TermContext.of(this.definition));
    }

    @Override
    public ASTNode transform(KItemProjection node) throws TransformerException {
        return new org.kframework.backend.java.kil.KItemProjection(Kind.of(node.projectedKind()), (org.kframework.backend.java.kil.Term)node.getTerm().accept(this));
    }

    @Override
    public ASTNode transform(KLabelConstant node) throws TransformerException {
        return org.kframework.backend.java.kil.KLabelConstant.of(node.getLabel(), TermContext.of(this.definition));
    }

    @Override
    public ASTNode transform(org.kframework.kil.KLabelInjection node) throws TransformerException {
        return new KLabelInjection((org.kframework.backend.java.kil.Term)node.getTerm().accept(this));
    }

    @Override
    public ASTNode transform(KInjectedLabel node) throws TransformerException {
        org.kframework.backend.java.kil.Term term = (org.kframework.backend.java.kil.Term)node.getTerm().accept(this);
        return new KLabelInjection(term);
    }

    @Override
    public ASTNode transform(FreezerLabel node) throws TransformerException {
        org.kframework.backend.java.kil.Term term = (org.kframework.backend.java.kil.Term)node.getTerm().accept(this);
        return new KLabelFreezer(term);
    }

    @Override
    public ASTNode transform(org.kframework.kil.Hole node) throws TransformerException {
        return Hole.HOLE;
    }

    @Override
    public ASTNode transform(FreezerHole node) throws TransformerException {
        return Hole.HOLE;
    }

    @Override
    public ASTNode transform(org.kframework.kil.Token node) throws TransformerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTNode transform(org.kframework.kil.List node) throws TransformerException {
        ArrayList<Term> list = new ArrayList<Term>();
        KILtoBackendJavaKILTransformer.flattenList(list, node.getContents());
        if (list.isEmpty()) {
            return new org.kframework.backend.java.kil.KList();
        }
        return super.transform(node);
    }

    @Override
    public ASTNode transform(org.kframework.kil.KSequence node) throws TransformerException {
        ArrayList<Term> list = new ArrayList<Term>();
        KILtoBackendJavaKILTransformer.flattenKSequence(list, node.getContents());
        Variable variable = null;
        if (!list.isEmpty() && list.get(list.size() - 1) instanceof org.kframework.kil.Variable && ((Term)list.get(list.size() - 1)).getSort().equals("K")) {
            variable = (Variable)((Term)list.remove(list.size() - 1)).accept(this);
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (Term term : list) {
            builder.add((org.kframework.backend.java.kil.Term)term.accept(this));
        }
        return new KSequence((ImmutableList<org.kframework.backend.java.kil.Term>)builder.build(), variable);
    }

    @Override
    public ASTNode transform(KList node) throws TransformerException {
        ArrayList<Term> list = new ArrayList<Term>();
        KILtoBackendJavaKILTransformer.flattenKList(list, node.getContents());
        Variable variable = null;
        if (!list.isEmpty() && list.get(list.size() - 1) instanceof org.kframework.kil.Variable && ((Term)list.get(list.size() - 1)).getSort().equals("KList")) {
            variable = (Variable)((Term)list.remove(list.size() - 1)).accept(this);
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (Term term : list) {
            builder.add((org.kframework.backend.java.kil.Term)term.accept(this));
        }
        return new org.kframework.backend.java.kil.KList((ImmutableList<org.kframework.backend.java.kil.Term>)builder.build(), variable);
    }

    @Override
    public ASTNode transform(Cell node) throws TransformerException {
        if (node.getContents() instanceof Bag) {
            CellCollection cellCollection = (CellCollection)node.getContents().accept(this);
            return new org.kframework.backend.java.kil.Cell<CellCollection>(node.getLabel(), cellCollection);
        }
        if (node.getContents() instanceof Cell) {
            ArrayListMultimap<String, org.kframework.backend.java.kil.Cell> cells = ArrayListMultimap.create();
            org.kframework.backend.java.kil.Cell cell = (org.kframework.backend.java.kil.Cell)node.getContents().accept(this);
            cells.put(cell.getLabel(), cell);
            return new org.kframework.backend.java.kil.Cell<CellCollection>(node.getLabel(), new CellCollection(cells, this.context));
        }
        org.kframework.backend.java.kil.Term content = (org.kframework.backend.java.kil.Term)node.getContents().accept(this);
        if (content instanceof KItem) {
            return new org.kframework.backend.java.kil.Cell<KItem>(node.getLabel(), (KItem)content);
        }
        if (content instanceof Token) {
            return new org.kframework.backend.java.kil.Cell<Token>(node.getLabel(), (Token)content);
        }
        if (content instanceof KSequence) {
            return new org.kframework.backend.java.kil.Cell<KSequence>(node.getLabel(), (KSequence)content);
        }
        if (content instanceof org.kframework.backend.java.kil.KList) {
            return new org.kframework.backend.java.kil.Cell<org.kframework.backend.java.kil.KList>(node.getLabel(), (org.kframework.backend.java.kil.KList)content);
        }
        if (content instanceof BuiltinList) {
            return new org.kframework.backend.java.kil.Cell<BuiltinList>(node.getLabel(), (BuiltinList)content);
        }
        if (content instanceof BuiltinSet) {
            return new org.kframework.backend.java.kil.Cell<BuiltinSet>(node.getLabel(), (BuiltinSet)content);
        }
        if (content instanceof org.kframework.backend.java.kil.SetUpdate) {
            return new org.kframework.backend.java.kil.Cell<org.kframework.backend.java.kil.SetUpdate>(node.getLabel(), (org.kframework.backend.java.kil.SetUpdate)content);
        }
        if (content instanceof BuiltinMap) {
            return new org.kframework.backend.java.kil.Cell<BuiltinMap>(node.getLabel(), (BuiltinMap)content);
        }
        if (content instanceof org.kframework.backend.java.kil.MapUpdate) {
            return new org.kframework.backend.java.kil.Cell<org.kframework.backend.java.kil.MapUpdate>(node.getLabel(), (org.kframework.backend.java.kil.MapUpdate)content);
        }
        if (content instanceof Variable) {
            return new org.kframework.backend.java.kil.Cell<org.kframework.backend.java.kil.Term>(node.getLabel(), content);
        }
        if (content instanceof BuiltinMgu) {
            return new org.kframework.backend.java.kil.Cell<BuiltinMgu>(node.getLabel(), (BuiltinMgu)content);
        }
        throw new RuntimeException();
    }

    @Override
    public ASTNode transform(Bag node) throws TransformerException {
        ArrayList<Term> contents = new ArrayList<Term>();
        Bag.flatten(contents, node.getContents());
        ArrayListMultimap<String, org.kframework.backend.java.kil.Cell> cells = ArrayListMultimap.create();
        Variable variable = null;
        for (Term term : contents) {
            if (term instanceof TermComment) continue;
            if (term instanceof Cell) {
                org.kframework.backend.java.kil.Cell cell = (org.kframework.backend.java.kil.Cell)term.accept(this);
                cells.put(cell.getLabel(), cell);
                continue;
            }
            if (variable == null && term instanceof org.kframework.kil.Variable && term.getSort().equals("Bag")) {
                variable = (Variable)term.accept(this);
                continue;
            }
            throw new RuntimeException();
        }
        return new CellCollection(cells, variable, this.context);
    }

    @Override
    public ASTNode transform(ListBuiltin node) throws TransformerException {
        ArrayList<org.kframework.backend.java.kil.Term> elementsLeft = new ArrayList<org.kframework.backend.java.kil.Term>(node.elementsLeft().size());
        for (Term entry : node.elementsLeft()) {
            org.kframework.backend.java.kil.Term newEntry = (org.kframework.backend.java.kil.Term)entry.accept(this);
            elementsLeft.add(newEntry);
        }
        ArrayList<org.kframework.backend.java.kil.Term> elementsRight = new ArrayList<org.kframework.backend.java.kil.Term>(node.elementsRight().size());
        for (Term entry : node.elementsRight()) {
            org.kframework.backend.java.kil.Term newEntry = (org.kframework.backend.java.kil.Term)entry.accept(this);
            elementsRight.add(newEntry);
        }
        ArrayList<org.kframework.backend.java.kil.Term> baseTerms = new ArrayList<org.kframework.backend.java.kil.Term>(node.baseTerms().size());
        for (Term term : node.baseTerms()) {
            baseTerms.add((org.kframework.backend.java.kil.Term)term.accept(this));
        }
        org.kframework.backend.java.kil.Term base = null;
        if (node.hasViewBase()) {
            base = (Variable)node.viewBase().accept(this);
        } else if (!node.baseTerms().isEmpty()) {
            if (node.baseTerms().size() == 1 && !(node.baseTerms().iterator().next().accept(this) instanceof KItem)) {
                base = (org.kframework.backend.java.kil.Term)node.baseTerms().iterator().next().accept(this);
            } else {
                org.kframework.backend.java.kil.Term result = BuiltinList.of(null, 0, 0, elementsLeft, new ArrayList<org.kframework.backend.java.kil.Term>());
                baseTerms.add(BuiltinList.of(null, 0, 0, new ArrayList<org.kframework.backend.java.kil.Term>(), elementsRight));
                for (org.kframework.backend.java.kil.Term baseTerm : baseTerms) {
                    result = new KItem(org.kframework.backend.java.kil.KLabelConstant.of("'_List_", TermContext.of(this.definition)), new org.kframework.backend.java.kil.KList(ImmutableList.of(result, baseTerm)), TermContext.of(this.definition));
                }
                return result;
            }
        }
        return BuiltinList.of(base, 0, 0, elementsLeft, elementsRight);
    }

    @Override
    public ASTNode transform(SetBuiltin node) throws TransformerException {
        HashSet<org.kframework.backend.java.kil.Term> entries = new HashSet<org.kframework.backend.java.kil.Term>(node.elements().size());
        for (Term entry : node.elements()) {
            org.kframework.backend.java.kil.Term key = (org.kframework.backend.java.kil.Term)entry.accept(this);
            entries.add(key);
        }
        if (node.isLHSView()) {
            if (node.hasViewBase()) {
                org.kframework.backend.java.kil.Term base = (org.kframework.backend.java.kil.Term)node.viewBase().accept(this);
                if (base instanceof org.kframework.backend.java.kil.SetUpdate) {
                    org.kframework.backend.java.kil.SetUpdate setUpdate = (org.kframework.backend.java.kil.SetUpdate)base;
                    return new org.kframework.backend.java.kil.SetUpdate(setUpdate.base(), setUpdate.removeSet());
                }
                return new BuiltinSet(entries, (Variable)base);
            }
            return new BuiltinSet(entries);
        }
        ArrayList<org.kframework.backend.java.kil.Term> baseTerms = new ArrayList<org.kframework.backend.java.kil.Term>(node.baseTerms().size());
        for (Term term : node.baseTerms()) {
            baseTerms.add((org.kframework.backend.java.kil.Term)term.accept(this));
        }
        baseTerms.add(new BuiltinSet(entries));
        org.kframework.backend.java.kil.Term result = (org.kframework.backend.java.kil.Term)baseTerms.get(0);
        for (int i = 1; i < baseTerms.size(); ++i) {
            result = new KItem(org.kframework.backend.java.kil.KLabelConstant.of("'_Set_", TermContext.of(this.definition)), new org.kframework.backend.java.kil.KList(ImmutableList.of(result, baseTerms.get(i))), TermContext.of(this.definition));
        }
        return result;
    }

    @Override
    public ASTNode transform(MapBuiltin node) throws TransformerException {
        HashMap<org.kframework.backend.java.kil.Term, org.kframework.backend.java.kil.Term> entries = new HashMap<org.kframework.backend.java.kil.Term, org.kframework.backend.java.kil.Term>(node.elements().size());
        for (Map.Entry<Term, Term> entry : node.elements().entrySet()) {
            org.kframework.backend.java.kil.Term key = (org.kframework.backend.java.kil.Term)entry.getKey().accept(this);
            org.kframework.backend.java.kil.Term value = (org.kframework.backend.java.kil.Term)entry.getValue().accept(this);
            entries.put(key, value);
        }
        if (node.isLHSView()) {
            if (node.hasViewBase()) {
                org.kframework.backend.java.kil.Term base = (org.kframework.backend.java.kil.Term)node.viewBase().accept(this);
                if (base instanceof org.kframework.backend.java.kil.MapUpdate) {
                    org.kframework.backend.java.kil.MapUpdate mapUpdate = (org.kframework.backend.java.kil.MapUpdate)base;
                    entries.putAll(mapUpdate.updateMap());
                    return new org.kframework.backend.java.kil.MapUpdate(mapUpdate.map(), mapUpdate.removeSet(), entries);
                }
                return new BuiltinMap(entries, (Variable)base);
            }
            return new BuiltinMap(entries);
        }
        ArrayList<org.kframework.backend.java.kil.Term> baseTerms = new ArrayList<org.kframework.backend.java.kil.Term>(node.baseTerms().size());
        for (Term term : node.baseTerms()) {
            baseTerms.add((org.kframework.backend.java.kil.Term)term.accept(this));
        }
        baseTerms.add(new BuiltinMap(entries));
        org.kframework.backend.java.kil.Term result = (org.kframework.backend.java.kil.Term)baseTerms.get(0);
        for (int i = 1; i < baseTerms.size(); ++i) {
            result = new KItem(org.kframework.backend.java.kil.KLabelConstant.of("'_Map_", TermContext.of(this.definition)), new org.kframework.backend.java.kil.KList(ImmutableList.of(result, baseTerms.get(i))), TermContext.of(this.definition));
        }
        return result;
    }

    @Override
    public ASTNode transform(Map node) throws TransformerException {
        return new BuiltinMap();
    }

    @Override
    public ASTNode transform(ListUpdate node) throws TransformerException {
        Variable base = (Variable)node.base().accept(this);
        return BuiltinList.of(base, node.removeLeft().size(), node.removeRight().size(), Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public ASTNode transform(SetUpdate node) throws TransformerException {
        Variable set = (Variable)node.set().accept(this);
        HashSet<org.kframework.backend.java.kil.Term> removeSet = new HashSet<org.kframework.backend.java.kil.Term>(node.removeEntries().size());
        for (Term term : node.removeEntries()) {
            removeSet.add((org.kframework.backend.java.kil.Term)term.accept(this));
        }
        return new org.kframework.backend.java.kil.SetUpdate(set, removeSet);
    }

    @Override
    public ASTNode transform(MapUpdate node) throws TransformerException {
        Variable map = (Variable)node.map().accept(this);
        HashSet<org.kframework.backend.java.kil.Term> removeSet = new HashSet<org.kframework.backend.java.kil.Term>(node.removeEntries().size());
        for (Term term : node.removeEntries().keySet()) {
            removeSet.add((org.kframework.backend.java.kil.Term)term.accept(this));
        }
        HashMap<org.kframework.backend.java.kil.Term, org.kframework.backend.java.kil.Term> updateMap = new HashMap<org.kframework.backend.java.kil.Term, org.kframework.backend.java.kil.Term>(node.updateEntries().size());
        for (Map.Entry<Term, Term> entry : node.updateEntries().entrySet()) {
            org.kframework.backend.java.kil.Term key = (org.kframework.backend.java.kil.Term)entry.getKey().accept(this);
            org.kframework.backend.java.kil.Term value = (org.kframework.backend.java.kil.Term)entry.getValue().accept(this);
            updateMap.put(key, value);
        }
        return new org.kframework.backend.java.kil.MapUpdate(map, removeSet, updateMap);
    }

    @Override
    public ASTNode transform(org.kframework.kil.Variable node) throws TransformerException {
        if (node.getSort().equals("Bag")) {
            return new Variable(node.getName(), Kind.CELL_COLLECTION.toString());
        }
        if (node.getSort().equals("K")) {
            return new Variable(node.getName(), "K");
        }
        if (node.getSort().equals("KList")) {
            return new Variable(node.getName(), "KList");
        }
        DataStructureSort dataStructureSort = this.context.dataStructureSortOf(node.getSort());
        if (dataStructureSort != null) {
            String sort = null;
            if (dataStructureSort.type().equals("List")) {
                sort = "MyList";
            } else if (dataStructureSort.type().equals("Map")) {
                sort = "MyMap";
            } else if (dataStructureSort.type().equals("Set")) {
                sort = "MySet";
            } else assert (false) : "unexpected data structure " + dataStructureSort.type();
            if (this.concreteCollectionSize.containsKey(node)) {
                return new ConcreteCollectionVariable(node.getName(), sort, this.concreteCollectionSize.get(node));
            }
            return new Variable(node.getName(), sort);
        }
        return new Variable(node.getName(), node.getSort());
    }

    @Override
    public ASTNode transform(org.kframework.kil.Rule node) throws TransformerException {
        org.kframework.backend.java.kil.Term term;
        assert (node.getBody() instanceof Rewrite);
        this.concreteCollectionSize = node.getConcreteDataStructureSize();
        Rewrite rewrite = (Rewrite)node.getBody();
        org.kframework.backend.java.kil.Term leftHandSide = (org.kframework.backend.java.kil.Term)rewrite.getLeft().accept(this);
        org.kframework.backend.java.kil.Term rightHandSide = (org.kframework.backend.java.kil.Term)rewrite.getRight().accept(this);
        ArrayList<org.kframework.backend.java.kil.Term> requires = new ArrayList<org.kframework.backend.java.kil.Term>();
        ArrayList<org.kframework.backend.java.kil.Term> ensures = new ArrayList<org.kframework.backend.java.kil.Term>();
        ArrayList<Variable> freshVariables = new ArrayList<Variable>();
        if (node.getRequires() != null) {
            term = (org.kframework.backend.java.kil.Term)node.getRequires().accept(this);
            if (term instanceof KItem && (((KItem)term).kLabel().toString().equals(KLabelConstant.ANDBOOL_KLABEL.getLabel()) || ((KItem)term).kLabel().toString().equals(KLabelConstant.BOOL_ANDBOOL_KLABEL.getLabel()))) {
                for (org.kframework.backend.java.kil.Term item : ((org.kframework.backend.java.kil.KList)((KItem)term).kList()).getContents()) {
                    if (item instanceof KItem && ((KItem)item).kLabel().toString().equals("'fresh(_)")) {
                        freshVariables.add((Variable)((org.kframework.backend.java.kil.KList)((KItem)item).kList()).get(0));
                        continue;
                    }
                    requires.add(item);
                }
            } else if (term instanceof KItem && ((KItem)term).kLabel().toString().equals("'fresh(_)")) {
                freshVariables.add((Variable)((org.kframework.backend.java.kil.KList)((KItem)term).kList()).get(0));
            } else {
                requires.add(term);
            }
        }
        if (node.getEnsures() != null) {
            term = (org.kframework.backend.java.kil.Term)node.getEnsures().accept(this);
            if (term instanceof KItem && ((KItem)term).kLabel().toString().equals("'_andBool_")) {
                for (org.kframework.backend.java.kil.Term item : ((org.kframework.backend.java.kil.KList)((KItem)term).kList()).getContents()) {
                    ensures.add(item);
                }
            } else {
                ensures.add(term);
            }
        }
        UninterpretedConstraint lookups = new UninterpretedConstraint();
        for (BuiltinLookup lookup : node.getLookups()) {
            Kind kind;
            Variable base = (Variable)lookup.base().accept(this);
            org.kframework.backend.java.kil.Term key = (org.kframework.backend.java.kil.Term)lookup.key().accept(this);
            switch (lookup.kind()) {
                case KItem: {
                    kind = Kind.KITEM;
                    break;
                }
                case K: {
                    kind = Kind.K;
                    break;
                }
                case KList: {
                    kind = Kind.KLIST;
                    break;
                }
                case KLabel: {
                    kind = Kind.KLABEL;
                    break;
                }
                case BagItem: {
                    kind = Kind.CELL;
                    break;
                }
                case Bag: {
                    kind = Kind.CELL_COLLECTION;
                    break;
                }
                default: {
                    assert (false) : "unexpected lookup kind";
                    kind = null;
                }
            }
            if (lookup instanceof org.kframework.kil.SetLookup) {
                if (lookup.choice()) {
                    lookups.add(new SetElementChoice(base), key);
                    continue;
                }
                lookups.add(new SetLookup(base, key), BoolToken.TRUE);
                continue;
            }
            org.kframework.backend.java.kil.Term value = (org.kframework.backend.java.kil.Term)lookup.value().accept(this);
            if (lookup instanceof MapLookup) {
                if (lookup.choice()) {
                    lookups.add(new MapKeyChoice(base), key);
                }
                lookups.add(new org.kframework.backend.java.kil.MapLookup(base, key, kind), value);
                continue;
            }
            lookups.add(new ListLookup(base, key, kind), value);
        }
        assert (leftHandSide.kind() == rightHandSide.kind() || (leftHandSide.kind() == Kind.KITEM || leftHandSide.kind() == Kind.K || leftHandSide.kind() == Kind.KLIST) && (rightHandSide.kind() == Kind.KITEM || rightHandSide.kind() == Kind.K || rightHandSide.kind() == Kind.KLIST));
        this.concreteCollectionSize = Collections.emptyMap();
        Rule rule = new Rule(node.getLabel(), leftHandSide, rightHandSide, requires, ensures, freshVariables, lookups, node.getAttributes(), this.definition);
        if (this.freshRules) {
            return rule.getFreshRule(TermContext.of(this.definition));
        }
        return rule;
    }

    @Override
    public ASTNode transform(org.kframework.kil.Definition node) {
        Definition definition;
        this.definition = definition = new Definition(this.context);
        Module singletonModule = node.getSingletonModule();
        for (org.kframework.kil.Rule rule : singletonModule.getRules()) {
            if (rule.containsAttribute(Attribute.PREDICATE.getKey()) || rule.containsAttribute(Attribute.ANYWHERE.getKey()) && !rule.containsAttribute("alphaRule")) continue;
            try {
                definition.addRule((Rule)rule.accept(this));
            }
            catch (TransformerException e) {
                System.err.println(rule);
                System.err.flush();
                e.printStackTrace();
            }
        }
        for (String kLabelName : singletonModule.getModuleKLabels()) {
            definition.addKLabel(org.kframework.backend.java.kil.KLabelConstant.of(kLabelName, TermContext.of(definition)));
        }
        Set<Production> productions = singletonModule.getSyntaxByTag("strict", this.context);
        productions.addAll(singletonModule.getSyntaxByTag("seqstrict", this.context));
        for (Production production : productions) {
            definition.addFrozenKLabel(org.kframework.backend.java.kil.KLabelConstant.of(production.getKLabel(), TermContext.of(definition)));
        }
        this.definition = null;
        return definition;
    }

    private static Definition evaluateDefinition(Definition definition) {
        ArrayList<Rule> partiallyEvaluatedRules = new ArrayList<Rule>();
        while (true) {
            boolean change = false;
            partiallyEvaluatedRules.clear();
            for (Rule rule : definition.functionRules().values()) {
                Rule evaluatedRule = KILtoBackendJavaKILTransformer.evaluateRule(rule, definition);
                partiallyEvaluatedRules.add(evaluatedRule);
                if (evaluatedRule.equals(rule)) continue;
                change = true;
            }
            if (!change) break;
            definition.functionRules().clear();
            definition.addRuleCollection(partiallyEvaluatedRules);
        }
        partiallyEvaluatedRules.clear();
        for (Rule rule : Iterables.concat(definition.rules(), definition.macros())) {
            partiallyEvaluatedRules.add(KILtoBackendJavaKILTransformer.evaluateRule(rule, definition));
        }
        definition.rules().clear();
        definition.macros().clear();
        definition.addRuleCollection(partiallyEvaluatedRules);
        return definition;
    }

    private static Rule evaluateRule(Rule rule, Definition definition) {
        TermContext termContext = TermContext.of(definition);
        org.kframework.backend.java.kil.Term rightHandSide = rule.rightHandSide().evaluate(termContext);
        ArrayList<org.kframework.backend.java.kil.Term> requires = new ArrayList<org.kframework.backend.java.kil.Term>();
        for (org.kframework.backend.java.kil.Term term : rule.requires()) {
            requires.add(term.evaluate(termContext));
        }
        ArrayList<org.kframework.backend.java.kil.Term> ensures = new ArrayList<org.kframework.backend.java.kil.Term>();
        for (org.kframework.backend.java.kil.Term term : rule.ensures()) {
            ensures.add(term.evaluate(termContext));
        }
        UninterpretedConstraint lookups = new UninterpretedConstraint();
        for (UninterpretedConstraint.Equality equality : rule.lookups().equalities()) {
            lookups.add(equality.leftHandSide().evaluate(termContext), equality.rightHandSide().evaluate(termContext));
        }
        return new Rule(rule.label(), rule.leftHandSide(), rightHandSide, requires, ensures, rule.freshVariables(), lookups, rule.getAttributes(), definition);
    }

    private static void flattenKSequence(List<Term> flatList, List<Term> nestedList) {
        for (Term term : nestedList) {
            if (term instanceof org.kframework.kil.KSequence) {
                org.kframework.kil.KSequence kSequence = (org.kframework.kil.KSequence)term;
                KILtoBackendJavaKILTransformer.flattenKSequence(flatList, kSequence.getContents());
                continue;
            }
            flatList.add(term);
        }
    }

    private static void flattenKList(List<Term> flatList, List<Term> nestedList) {
        for (Term term : nestedList) {
            if (term instanceof KList) {
                KList kList = (KList)term;
                KILtoBackendJavaKILTransformer.flattenKList(flatList, kList.getContents());
                continue;
            }
            flatList.add(term);
        }
    }

    private static void flattenList(List<Term> flatList, List<Term> nestedList) {
        for (Term term : nestedList) {
            if (term instanceof org.kframework.kil.List) {
                org.kframework.kil.List list = (org.kframework.kil.List)term;
                KILtoBackendJavaKILTransformer.flattenKList(flatList, list.getContents());
                continue;
            }
            flatList.add(term);
        }
    }
}

