/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.symbolic;

import com.microsoft.z3.ArithExpr;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Z3Exception;
import java.util.Set;
import org.kframework.backend.java.builtins.BoolToken;
import org.kframework.backend.java.builtins.IntToken;
import org.kframework.backend.java.kil.KItem;
import org.kframework.backend.java.kil.KLabelConstant;
import org.kframework.backend.java.kil.KList;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.kil.Z3Term;
import org.kframework.backend.java.symbolic.CopyOnWriteTransformer;
import org.kframework.kil.ASTNode;

public class KILtoZ3
extends CopyOnWriteTransformer {
    private final Context context;
    private final Set<Variable> boundVariables;

    public KILtoZ3(Set<Variable> boundVariables, Context context) {
        this.boundVariables = boundVariables;
        this.context = context;
    }

    @Override
    public ASTNode transform(BoolToken boolToken) {
        try {
            return new Z3Term(this.context.MkBool(boolToken.booleanValue()));
        }
        catch (Z3Exception e) {
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public ASTNode transform(IntToken intToken) {
        try {
            return new Z3Term(this.context.MkInt(intToken.bigIntegerValue().longValue()));
        }
        catch (Z3Exception e) {
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public ASTNode transform(KItem kItem) {
        if (!(kItem.kLabel() instanceof KLabelConstant)) {
            throw new RuntimeException();
        }
        KLabelConstant kLabel = (KLabelConstant)kItem.kLabel();
        if (!(kItem.kList() instanceof KList)) {
            throw new RuntimeException();
        }
        KList kList = (KList)kItem.kList();
        if (kList.hasFrame()) {
            throw new RuntimeException();
        }
        try {
            if (kLabel.label().equals("'notBool_") && kList.size() == 1) {
                BoolExpr booleanExpression = (BoolExpr)((Z3Term)kList.get(0).accept(this)).expression();
                return new Z3Term(this.context.MkNot(booleanExpression));
            }
            if (kLabel.label().equals("'_andBool_") && kList.size() == 2) {
                BoolExpr[] booleanExpressions = new BoolExpr[]{(BoolExpr)((Z3Term)kList.get(0).accept(this)).expression(), (BoolExpr)((Z3Term)kList.get(1).accept(this)).expression()};
                return new Z3Term(this.context.MkAnd(booleanExpressions));
            }
            if (kLabel.label().equals("'_orBool_") && kList.size() == 2) {
                BoolExpr[] booleanExpressions = new BoolExpr[]{(BoolExpr)((Z3Term)kList.get(0).accept(this)).expression(), (BoolExpr)((Z3Term)kList.get(1).accept(this)).expression()};
                return new Z3Term(this.context.MkOr(booleanExpressions));
            }
            if (kLabel.label().equals("'_==Bool_") && kList.size() == 2) {
                BoolExpr booleanExpression1 = (BoolExpr)((Z3Term)kList.get(0).accept(this)).expression();
                BoolExpr booleanExpression2 = (BoolExpr)((Z3Term)kList.get(1).accept(this)).expression();
                return new Z3Term(this.context.MkEq(booleanExpression1, booleanExpression2));
            }
            if (kLabel.label().equals("'_=/=Bool_") && kList.size() == 2) {
                BoolExpr booleanExpression1 = (BoolExpr)((Z3Term)kList.get(0).accept(this)).expression();
                BoolExpr booleanExpression2 = (BoolExpr)((Z3Term)kList.get(1).accept(this)).expression();
                return new Z3Term(this.context.MkNot(this.context.MkEq(booleanExpression1, booleanExpression2)));
            }
            if (kLabel.label().equals("'_+Int_") && kList.size() == 2) {
                ArithExpr[] arithmeticExpressions = new ArithExpr[]{(ArithExpr)((Z3Term)kList.get(0).accept(this)).expression(), (ArithExpr)((Z3Term)kList.get(1).accept(this)).expression()};
                return new Z3Term(this.context.MkAdd(arithmeticExpressions));
            }
            if (kLabel.label().equals("'_-Int_") && kList.size() == 2) {
                ArithExpr[] arithmeticExpressions = new ArithExpr[]{(ArithExpr)((Z3Term)kList.get(0).accept(this)).expression(), (ArithExpr)((Z3Term)kList.get(1).accept(this)).expression()};
                return new Z3Term(this.context.MkSub(arithmeticExpressions));
            }
            if (kLabel.label().equals("'_*Int_") && kList.size() == 2) {
                ArithExpr[] arithmeticExpressions = new ArithExpr[]{(ArithExpr)((Z3Term)kList.get(0).accept(this)).expression(), (ArithExpr)((Z3Term)kList.get(1).accept(this)).expression()};
                return new Z3Term(this.context.MkMul(arithmeticExpressions));
            }
            if (kLabel.label().equals("'_/Int_") && kList.size() == 2) {
                ArithExpr arithmeticExpression1 = (ArithExpr)((Z3Term)kList.get(0).accept(this)).expression();
                ArithExpr arithmeticExpression2 = (ArithExpr)((Z3Term)kList.get(1).accept(this)).expression();
                return new Z3Term(this.context.MkDiv(arithmeticExpression1, arithmeticExpression2));
            }
            if (kLabel.label().equals("'_>Int_") && kList.size() == 2) {
                ArithExpr arithmeticExpression1 = (ArithExpr)((Z3Term)kList.get(0).accept(this)).expression();
                ArithExpr arithmeticExpression2 = (ArithExpr)((Z3Term)kList.get(1).accept(this)).expression();
                return new Z3Term(this.context.MkGt(arithmeticExpression1, arithmeticExpression2));
            }
            if (kLabel.label().equals("'_>=Int_") && kList.size() == 2) {
                ArithExpr arithmeticExpression1 = (ArithExpr)((Z3Term)kList.get(0).accept(this)).expression();
                ArithExpr arithmeticExpression2 = (ArithExpr)((Z3Term)kList.get(1).accept(this)).expression();
                return new Z3Term(this.context.MkGe(arithmeticExpression1, arithmeticExpression2));
            }
            if (kLabel.label().equals("'_<Int_") && kList.size() == 2) {
                ArithExpr arithmeticExpression1 = (ArithExpr)((Z3Term)kList.get(0).accept(this)).expression();
                ArithExpr arithmeticExpression2 = (ArithExpr)((Z3Term)kList.get(1).accept(this)).expression();
                return new Z3Term(this.context.MkLt(arithmeticExpression1, arithmeticExpression2));
            }
            if (kLabel.label().equals("'_<=Int_") && kList.size() == 2) {
                ArithExpr arithmeticExpression1 = (ArithExpr)((Z3Term)kList.get(0).accept(this)).expression();
                ArithExpr arithmeticExpression2 = (ArithExpr)((Z3Term)kList.get(1).accept(this)).expression();
                return new Z3Term(this.context.MkLe(arithmeticExpression1, arithmeticExpression2));
            }
            if (kLabel.label().equals("'_==Int_") && kList.size() == 2) {
                ArithExpr arithmeticExpression1 = (ArithExpr)((Z3Term)kList.get(0).accept(this)).expression();
                ArithExpr arithmeticExpression2 = (ArithExpr)((Z3Term)kList.get(1).accept(this)).expression();
                return new Z3Term(this.context.MkEq(arithmeticExpression1, arithmeticExpression2));
            }
            if (kLabel.label().equals("'_=/=Int_") && kList.size() == 2) {
                ArithExpr arithmeticExpression1 = (ArithExpr)((Z3Term)kList.get(0).accept(this)).expression();
                ArithExpr arithmeticExpression2 = (ArithExpr)((Z3Term)kList.get(1).accept(this)).expression();
                return new Z3Term(this.context.MkNot(this.context.MkEq(arithmeticExpression1, arithmeticExpression2)));
            }
            if (kLabel.label().equals("'_==K_") && kList.size() == 2) {
                Expr expression1 = ((Z3Term)kList.get(0).accept(this)).expression();
                Expr expression2 = ((Z3Term)kList.get(1).accept(this)).expression();
                return new Z3Term(this.context.MkEq(expression1, expression2));
            }
            if (kLabel.label().equals("'_=/=K_") && kList.size() == 2) {
                Expr expression1 = ((Z3Term)kList.get(0).accept(this)).expression();
                Expr expression2 = ((Z3Term)kList.get(1).accept(this)).expression();
                return new Z3Term(this.context.MkNot(this.context.MkEq(expression1, expression2)));
            }
            if (kLabel.label().equals("'[E]K_._") && kList.size() == 2) {
                ArithExpr expression1 = (ArithExpr)((Z3Term)kList.get(0).accept(this)).expression();
                BoolExpr expression2 = (BoolExpr)((Z3Term)kList.get(1).accept(this)).expression();
                Expr[] newExpr = new Expr[]{expression1};
                return new Z3Term(this.context.MkExists(newExpr, expression2, 1, null, null, null, null));
            }
            if (kLabel.label().equals("'[A]K_._") && kList.size() == 2) {
                ArithExpr expression1 = (ArithExpr)((Z3Term)kList.get(0).accept(this)).expression();
                BoolExpr expression2 = (BoolExpr)((Z3Term)kList.get(1).accept(this)).expression();
                Expr[] newExpr = new Expr[]{expression1};
                return new Z3Term(this.context.MkForall(newExpr, expression2, 1, null, null, null, null));
            }
            throw new RuntimeException("cannot translate term to Z3 format " + kItem);
        }
        catch (ClassCastException e) {
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
        catch (Z3Exception e) {
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public ASTNode transform(Variable variable) {
        return KILtoZ3.valueOf(variable, this.context);
    }

    public static Z3Term valueOf(Variable variable, Context context) {
        try {
            if (variable.sort().equals("Bool")) {
                return new Z3Term(context.MkBoolConst(variable.name()));
            }
            return new Z3Term(context.MkIntConst(variable.name()));
        }
        catch (Z3Exception e) {
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
    }
}

