/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.symbolic;

import java.util.ArrayList;
import org.kframework.backend.java.kil.Definition;
import org.kframework.backend.java.kil.JavaSymbolicObject;
import org.kframework.backend.java.kil.Rule;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.symbolic.StepRewriter;
import org.kframework.backend.java.symbolic.TermTransformer;
import org.kframework.backend.java.symbolic.UninterpretedConstraint;

public class MacroExpander
extends TermTransformer {
    private final StepRewriter rewriter;

    public MacroExpander(Definition definition) {
        super(definition);
        this.rewriter = new StepRewriter(definition.macros(), definition);
    }

    public Definition processDefinition() {
        Definition processedDefinition = new Definition(this.definition.context());
        processedDefinition.addKLabelCollection(this.definition.kLabels());
        processedDefinition.addFrozenKLabelCollection(this.definition.frozenKLabels());
        for (Rule rule : this.definition.rules()) {
            processedDefinition.addRule(this.processRule(rule));
        }
        for (Rule rule : this.definition.functionRules().values()) {
            processedDefinition.addRule(this.processRule(rule));
        }
        processedDefinition.addRuleCollection(this.definition.macros());
        return processedDefinition;
    }

    public Rule processRule(Rule rule) {
        Term processedLeftHandSide = this.processTerm(rule.leftHandSide());
        Term processedRightHandSide = this.processTerm(rule.rightHandSide());
        ArrayList<Term> processedRequires = new ArrayList<Term>(rule.requires().size());
        for (Term conditionItem : rule.requires()) {
            processedRequires.add(this.processTerm(conditionItem));
        }
        ArrayList<Term> processedEnsures = new ArrayList<Term>(rule.ensures().size());
        for (Term conditionItem : rule.ensures()) {
            processedEnsures.add(this.processTerm(conditionItem));
        }
        UninterpretedConstraint processedLookups = (UninterpretedConstraint)this.expandMacro(rule.lookups());
        return new Rule(rule.label(), processedLeftHandSide, processedRightHandSide, processedRequires, processedEnsures, rule.freshVariables(), processedLookups, rule.getAttributes(), this.definition);
    }

    public Term processTerm(Term term) {
        return (Term)this.expandMacro(term);
    }

    private JavaSymbolicObject expandMacro(JavaSymbolicObject node) {
        JavaSymbolicObject expandedNode = (JavaSymbolicObject)node.accept(this);
        while (node != expandedNode) {
            node = expandedNode;
            expandedNode = (JavaSymbolicObject)node.accept(this);
        }
        return node;
    }

    @Override
    protected Term transformTerm(Term term) {
        Term transformedTerm = this.rewriter.getOneSuccessor(term);
        return transformedTerm != null ? transformedTerm : term;
    }
}

