/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.symbolic;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kframework.backend.java.builtins.BoolToken;
import org.kframework.backend.java.builtins.IntToken;
import org.kframework.backend.java.kil.BuiltinList;
import org.kframework.backend.java.kil.BuiltinMap;
import org.kframework.backend.java.kil.BuiltinMgu;
import org.kframework.backend.java.kil.BuiltinSet;
import org.kframework.backend.java.kil.Cell;
import org.kframework.backend.java.kil.CellCollection;
import org.kframework.backend.java.kil.ConcreteCollectionVariable;
import org.kframework.backend.java.kil.DataStructureLookup;
import org.kframework.backend.java.kil.Hole;
import org.kframework.backend.java.kil.JavaSymbolicObject;
import org.kframework.backend.java.kil.KCollection;
import org.kframework.backend.java.kil.KItem;
import org.kframework.backend.java.kil.KLabelConstant;
import org.kframework.backend.java.kil.KLabelFreezer;
import org.kframework.backend.java.kil.KLabelInjection;
import org.kframework.backend.java.kil.KList;
import org.kframework.backend.java.kil.KSequence;
import org.kframework.backend.java.kil.Kind;
import org.kframework.backend.java.kil.MetaVariable;
import org.kframework.backend.java.kil.Rule;
import org.kframework.backend.java.kil.Sorted;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.TermContext;
import org.kframework.backend.java.kil.Token;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.symbolic.AbstractMatcher;
import org.kframework.backend.java.symbolic.PatternMatchingFailure;
import org.kframework.backend.java.symbolic.UnificationFailure;
import org.kframework.backend.java.symbolic.UninterpretedConstraint;
import org.kframework.kil.loader.Context;

public class PatternMatcher
extends AbstractMatcher {
    private Map<Variable, Term> fSubstitution = new HashMap<Variable, Term>();
    private final Collection<Collection<Map<Variable, Term>>> multiSubstitutions;
    private boolean isStarNested;
    private final TermContext termContext;

    public static boolean matchable(Term subject, Term pattern, TermContext context) {
        PatternMatcher matcher = new PatternMatcher(context);
        try {
            matcher.match(subject, pattern);
        }
        catch (PatternMatchingFailure e) {
            return false;
        }
        return true;
    }

    public static List<Map<Variable, Term>> patternMatch(Term subject, Rule rule, TermContext context) {
        PatternMatcher matcher = new PatternMatcher(context);
        if (!matcher.patternMatch(subject, rule.leftHandSide())) {
            return Collections.emptyList();
        }
        ArrayList<Map<Variable, Term>> substitutions = new ArrayList<Map<Variable, Term>>();
        block0: for (Map<Variable, Term> subst : PatternMatcher.getMultiSubstitutions(matcher)) {
            for (Variable variable : rule.freshVariables()) {
                subst.put(variable, IntToken.fresh());
            }
            ArrayList<Map<Variable, Term>> multiSubsts = new ArrayList<Map<Variable, Term>>(Collections.singletonList(subst));
            for (UninterpretedConstraint.Equality equality : rule.lookups().equalities()) {
                Term nonLookup;
                Term lookup = equality.leftHandSide() instanceof DataStructureLookup ? equality.leftHandSide() : equality.rightHandSide();
                Term term = nonLookup = equality.leftHandSide() == lookup ? equality.rightHandSide() : equality.leftHandSide();
                assert (lookup instanceof DataStructureLookup) : "one side of the equality should be an instance of DataStructureLookup";
                Term evaluatedLookup = lookup.substituteAndEvaluate(subst, context);
                if (nonLookup instanceof Variable) {
                    Variable variable = (Variable)nonLookup;
                    if (!PatternMatcher.checkOrderedSortedCondition(variable, evaluatedLookup, context)) continue block0;
                    for (Map map : multiSubsts) {
                        map.put(variable, evaluatedLookup);
                    }
                    continue;
                }
                PatternMatcher lookupMatcher = new PatternMatcher(context);
                if (!lookupMatcher.patternMatch(evaluatedLookup, nonLookup)) continue block0;
                ArrayList<Map<Variable, Term>> product = new ArrayList<Map<Variable, Term>>();
                for (Map<Variable, Term> subst1 : PatternMatcher.getMultiSubstitutions(lookupMatcher)) {
                    for (Map map : multiSubsts) {
                        Map<Variable, Term> composedSubst = PatternMatcher.composeSubstitution(subst1, map);
                        if (composedSubst == null) continue;
                        product.add(composedSubst);
                    }
                }
                if (product.isEmpty()) continue block0;
                multiSubsts = product;
            }
            Iterator iter = multiSubsts.iterator();
            block6: while (iter.hasNext()) {
                Map nextSubst = (Map)iter.next();
                for (Term require : rule.requires()) {
                    if (require.substituteAndEvaluate(nextSubst, context).equals(BoolToken.TRUE)) continue;
                    iter.remove();
                    continue block6;
                }
            }
            substitutions.addAll(multiSubsts);
        }
        return substitutions;
    }

    private static List<Map<Variable, Term>> getMultiSubstitutions(PatternMatcher matcher) {
        if (!matcher.multiSubstitutions.isEmpty()) {
            assert (matcher.multiSubstitutions.size() <= 2);
            ArrayList<Map<Variable, Term>> result = new ArrayList<Map<Variable, Term>>();
            Iterator<Collection<Map<Variable, Term>>> iterator = matcher.multiSubstitutions.iterator();
            if (matcher.multiSubstitutions.size() == 1) {
                for (Map<Variable, Term> subst : iterator.next()) {
                    Map<Variable, Term> composedSubst = PatternMatcher.composeSubstitution(matcher.fSubstitution, subst);
                    if (composedSubst == null) continue;
                    result.add(composedSubst);
                }
            } else {
                Collection<Map<Variable, Term>> substitutions = iterator.next();
                Collection<Map<Variable, Term>> otherSubstitutions = iterator.next();
                for (Map<Variable, Term> subst1 : substitutions) {
                    for (Map<Variable, Term> subst2 : otherSubstitutions) {
                        Map<Variable, Term> composedSubst = PatternMatcher.composeSubstitution(matcher.fSubstitution, subst1);
                        if (composedSubst == null || (composedSubst = PatternMatcher.composeSubstitution(composedSubst, subst2)) == null) continue;
                        result.add(composedSubst);
                    }
                }
            }
            return result;
        }
        return Collections.singletonList(matcher.fSubstitution);
    }

    private static Map<Variable, Term> composeSubstitution(Map<Variable, Term> subst1, Map<Variable, Term> subst2) {
        HashMap<Variable, Term> result = new HashMap<Variable, Term>(subst1);
        for (Map.Entry<Variable, Term> entry : subst2.entrySet()) {
            Variable variable = entry.getKey();
            Term term = entry.getValue();
            Term otherTerm = (Term)result.get(variable);
            if (otherTerm == null) {
                result.put(variable, term);
                continue;
            }
            if (otherTerm.equals(term)) continue;
            return null;
        }
        return result;
    }

    private PatternMatcher(TermContext context) {
        this.termContext = context;
        this.multiSubstitutions = new ArrayList<Collection<Map<Variable, Term>>>();
    }

    private boolean patternMatch(Term subject, Term pattern) {
        try {
            this.isStarNested = false;
            this.match(subject, pattern);
            return true;
        }
        catch (PatternMatchingFailure e) {
            return false;
        }
    }

    @Override
    public void match(Term subject, Term pattern) {
        if (subject.kind().isComputational()) {
            assert (pattern.kind().isComputational());
            subject = KCollection.upKind(subject, pattern.kind());
            pattern = KCollection.upKind(pattern, subject.kind());
        }
        if (subject.kind() == Kind.CELL || subject.kind() == Kind.CELL_COLLECTION) {
            Context context = this.termContext.definition().context();
            subject = CellCollection.upKind(subject, pattern.kind(), context);
            pattern = CellCollection.upKind(pattern, subject.kind(), context);
        }
        assert (subject.kind() == pattern.kind()) : "kind mismatch between " + subject + " (" + (Object)((Object)subject.kind()) + ")" + " and " + pattern + " (" + (Object)((Object)pattern.kind()) + ")";
        if (pattern.isSymbolic()) {
            assert (pattern instanceof Variable);
            Variable variable = (Variable)pattern;
            if (variable instanceof ConcreteCollectionVariable && !((ConcreteCollectionVariable)variable).matchConcreteSize(subject)) {
                this.fail(variable, subject);
            }
            this.addSubstitution(variable, subject);
        } else if (!subject.equals(pattern)) {
            subject.accept(this, pattern);
        }
    }

    private static boolean checkOrderedSortedCondition(Variable variable, Term term, TermContext termContext) {
        String sortOfVar = variable.sort();
        String sortOfTerm = term instanceof Sorted ? ((Sorted)((Object)term)).sort() : term.kind().toString();
        return termContext.definition().context().isSubsortedEq(sortOfVar, sortOfTerm);
    }

    private void addSubstitution(Variable variable, Term term) {
        Term subst;
        if (!PatternMatcher.checkOrderedSortedCondition(variable, term, this.termContext)) {
            this.fail(variable, term);
        }
        if ((subst = this.fSubstitution.get(variable)) == null) {
            this.fSubstitution.put(variable, term);
        } else if (!subst.equals(term)) {
            this.fail(subst, term);
        }
    }

    private void addSubstitution(Map<Variable, Term> substitution) {
        for (Map.Entry<Variable, Term> entry : substitution.entrySet()) {
            this.addSubstitution(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void match(BuiltinList builtinList, Term pattern) {
        assert (!(pattern instanceof Variable));
        if (!(pattern instanceof BuiltinList)) {
            this.fail(builtinList, pattern);
        }
        throw new UnsupportedOperationException("list matching is only supported when one of the lists is a variable.");
    }

    @Override
    public void match(BuiltinMap builtinMap, Term pattern) {
        assert (!(pattern instanceof Variable));
        if (!(pattern instanceof BuiltinMap)) {
            this.fail(builtinMap, pattern);
        }
        throw new UnsupportedOperationException("map matching is only supported when one of the maps is a variable.");
    }

    @Override
    public void match(BuiltinSet builtinSet, Term pattern) {
        assert (!(pattern instanceof Variable));
        if (!(pattern instanceof BuiltinSet)) {
            this.fail(builtinSet, pattern);
        }
        throw new UnsupportedOperationException("set matching is only supported when one of the sets is a variable.");
    }

    @Override
    public void match(BuiltinMgu builtinMgu, Term pattern) {
        assert (!(pattern instanceof Variable));
        if (!(pattern instanceof BuiltinMgu)) {
            this.fail(builtinMgu, pattern);
        }
        throw new UnsupportedOperationException("Mgu matching is only supported when one of the Mgu's is a variable.");
    }

    @Override
    public void match(Cell cell, Term pattern) {
        assert (!(pattern instanceof Variable));
        if (!(pattern instanceof Cell)) {
            this.fail(cell, pattern);
        }
        Cell otherCell = (Cell)pattern;
        if (!cell.getLabel().equals(otherCell.getLabel())) {
            this.fail(cell, otherCell);
        }
        this.match((Term)cell.getContent(), (Term)otherCell.getContent());
    }

    @Override
    public void match(CellCollection cellCollection, Term pattern) {
        assert (!(pattern instanceof Variable));
        if (!(pattern instanceof CellCollection)) {
            this.fail(cellCollection, pattern);
        }
        CellCollection otherCellCollection = (CellCollection)pattern;
        assert (!cellCollection.hasFrame()) : "the subject term should be ground";
        HashSet<String> unifiableCellLabels = new HashSet<String>(cellCollection.labelSet());
        unifiableCellLabels.retainAll(otherCellCollection.labelSet());
        Context context = this.termContext.definition().context();
        if (!cellCollection.hasStar() || !otherCellCollection.hasStar()) {
            for (String label : unifiableCellLabels) {
                assert (cellCollection.get(label).size() == 1 && otherCellCollection.get(label).size() == 1);
                this.match(cellCollection.get(label).iterator().next(), (Term)otherCellCollection.get(label).iterator().next());
            }
            ArrayListMultimap<String, Cell> cellMap = ArrayListMultimap.create();
            ArrayListMultimap<String, Cell> otherCellMap = ArrayListMultimap.create();
            this.computeDisjointCellMaps(unifiableCellLabels, cellCollection, cellMap, otherCellCollection, otherCellMap);
            if (!cellCollection.hasStar() && !this.addCellCollectionConstraint(cellMap, null, otherCellMap, otherCellCollection.hasFrame() ? otherCellCollection.frame() : null)) {
                this.fail(cellCollection, otherCellCollection);
            } else if (!otherCellCollection.hasStar() && !this.addCellCollectionConstraint(otherCellMap, otherCellCollection.hasFrame() ? otherCellCollection.frame() : null, cellMap, null)) {
                this.fail(cellCollection, otherCellCollection);
            }
        } else {
            assert (!this.isStarNested) : "nested cells with multiplicity='*' not supported";
            ArrayListMultimap<String, Cell> cellMap = ArrayListMultimap.create();
            ArrayListMultimap<String, Cell> otherCellMap = ArrayListMultimap.create();
            this.computeDisjointCellMaps(unifiableCellLabels, cellCollection, cellMap, otherCellCollection, otherCellMap);
            if (!otherCellMap.isEmpty()) {
                this.fail(cellCollection, otherCellCollection);
            }
            Iterator iter = unifiableCellLabels.iterator();
            while (iter.hasNext()) {
                String cellLabel = (String)iter.next();
                if (context.getConfigurationStructureMap().get(cellLabel).isStarOrPlus()) continue;
                assert (cellCollection.get(cellLabel).size() == 1 && otherCellCollection.get(cellLabel).size() == 1);
                this.match(cellCollection.get(cellLabel).iterator().next(), (Term)otherCellCollection.get(cellLabel).iterator().next());
                iter.remove();
            }
            if (unifiableCellLabels.isEmpty()) {
                this.fail(cellCollection, otherCellCollection);
            } else assert (unifiableCellLabels.size() == 1);
            if (cellCollection.size() < otherCellCollection.size() || cellCollection.size() > otherCellCollection.size() && !otherCellCollection.hasFrame()) {
                this.fail(cellCollection, otherCellCollection);
            }
            String label = (String)unifiableCellLabels.iterator().next();
            Cell[] cells = cellCollection.get(label).toArray(new Cell[1]);
            Cell[] otherCells = otherCellCollection.get(label).toArray(new Cell[1]);
            Variable otherFrame = otherCellCollection.hasFrame() ? otherCellCollection.frame() : null;
            Map<Variable, Term> mainSubstitution = this.fSubstitution;
            this.isStarNested = true;
            ArrayList<Map<Variable, Term>> substitutions = new ArrayList<Map<Variable, Term>>();
            SelectionGenerator generator = new SelectionGenerator(otherCells.length, cells.length);
            do {
                this.fSubstitution = new HashMap<Variable, Term>();
                try {
                    for (int i = 0; i < otherCells.length; ++i) {
                        this.match(cells[generator.selection.get(i)], (Term)otherCells[i]);
                    }
                }
                catch (UnificationFailure e) {
                    continue;
                }
                ArrayListMultimap<String, Cell> cm = ArrayListMultimap.create();
                for (int i = 0; i < cells.length; ++i) {
                    if (generator.selected.contains(i)) continue;
                    cm.put(cells[i].getLabel(), cells[i]);
                }
                cm.putAll(cellMap);
                if (otherFrame != null) {
                    this.addSubstitution(otherFrame, new CellCollection(cm, context));
                } else if (!cm.isEmpty()) {
                    this.fail(cellCollection, otherCellCollection);
                }
                substitutions.add(this.fSubstitution);
            } while (generator.generate());
            this.fSubstitution = mainSubstitution;
            this.isStarNested = false;
            if (substitutions.isEmpty()) {
                this.fail(cellCollection, otherCellCollection);
            }
            if (substitutions.size() == 1) {
                this.addSubstitution((Map)substitutions.iterator().next());
            } else {
                this.multiSubstitutions.add(substitutions);
            }
        }
    }

    private void computeDisjointCellMaps(Set<String> unifiableCellLabels, CellCollection cellCollection, Multimap<String, Cell> cellMap, CellCollection otherCellCollection, Multimap<String, Cell> otherCellMap) {
        cellMap.clear();
        for (String label : cellCollection.labelSet()) {
            if (unifiableCellLabels.contains(label)) continue;
            cellMap.putAll(label, cellCollection.get(label));
        }
        otherCellMap.clear();
        for (String label : otherCellCollection.labelSet()) {
            if (unifiableCellLabels.contains(label)) continue;
            otherCellMap.putAll(label, otherCellCollection.get(label));
        }
    }

    private boolean addCellCollectionConstraint(Multimap<String, Cell> cellMap, Variable frame, Multimap<String, Cell> otherCellMap, Variable otherFrame) {
        for (String cellLabel : cellMap.keySet()) {
            assert (!otherCellMap.containsKey(cellLabel));
            assert (cellMap.get(cellLabel).size() == 1);
        }
        assert (frame == null || otherFrame == null);
        Context context = this.termContext.definition().context();
        if (frame != null) {
            if (!cellMap.isEmpty()) {
                return false;
            }
            this.addSubstitution(frame, new CellCollection(otherCellMap, context));
        } else {
            if (!otherCellMap.isEmpty()) {
                return false;
            }
            if (otherFrame == null) {
                if (!cellMap.isEmpty()) {
                    return false;
                }
            } else {
                this.addSubstitution(otherFrame, new CellCollection(cellMap, context));
            }
        }
        return true;
    }

    @Override
    public void match(KLabelConstant kLabelConstant, Term pattern) {
        assert (!(pattern instanceof Variable));
        if (!kLabelConstant.equals(pattern)) {
            this.fail(kLabelConstant, pattern);
        }
    }

    @Override
    public void match(KLabelFreezer kLabelFreezer, Term pattern) {
        assert (!(pattern instanceof Variable));
        if (!(pattern instanceof KLabelFreezer)) {
            this.fail(kLabelFreezer, pattern);
        }
        KLabelFreezer otherKLabelFreezer = (KLabelFreezer)pattern;
        this.match(kLabelFreezer.term(), otherKLabelFreezer.term());
    }

    @Override
    public void match(KLabelInjection kLabelInjection, Term pattern) {
        Kind otherInjectionKind;
        assert (!(pattern instanceof Variable));
        if (!(pattern instanceof KLabelInjection)) {
            this.fail(kLabelInjection, pattern);
        }
        KLabelInjection otherKLabelInjection = (KLabelInjection)pattern;
        Kind injectionKind = kLabelInjection.term().kind();
        if (!(injectionKind == (otherInjectionKind = otherKLabelInjection.term().kind()) || injectionKind.isComputational() && otherInjectionKind.isComputational() || injectionKind.isStructural() && otherInjectionKind.isStructural())) {
            this.fail(kLabelInjection, otherKLabelInjection);
        }
        this.match(kLabelInjection.term(), otherKLabelInjection.term());
    }

    @Override
    public void match(Hole hole, Term pattern) {
        assert (!(pattern instanceof Variable));
        if (!hole.equals(pattern)) {
            this.fail(hole, pattern);
        }
    }

    @Override
    public void match(KItem kItem, Term pattern) {
        KLabelConstant kLabelConstant;
        assert (!(pattern instanceof Variable));
        if (!(pattern instanceof KItem)) {
            this.fail(kItem, pattern);
        }
        KItem patternKItem = (KItem)pattern;
        Term kLabel = kItem.kLabel();
        Term kList = kItem.kList();
        this.match(kLabel, patternKItem.kLabel());
        if (kLabel instanceof KLabelConstant && (kLabelConstant = (KLabelConstant)kLabel).isBinder()) {
            assert (kList instanceof KList);
            Multimap<Integer, Integer> binderMap = kLabelConstant.getBinderMap();
            ArrayList<Term> terms = new ArrayList<Term>(((KList)kList).getContents());
            for (Integer boundVarPosition : binderMap.keySet()) {
                Term boundVars = (Term)terms.get(boundVarPosition);
                Set<Variable> variables = boundVars.variableSet();
                Map<Variable, Variable> freshSubstitution = Variable.getFreshSubstitution(variables);
                JavaSymbolicObject freshBoundVars = boundVars.substituteWithBinders(freshSubstitution, this.termContext);
                terms.set(boundVarPosition, (Term)freshBoundVars);
                for (Integer bindingExpPosition : binderMap.get(boundVarPosition)) {
                    Term bindingExp = (Term)terms.get(bindingExpPosition - 1);
                    JavaSymbolicObject freshbindingExp = bindingExp.substituteWithBinders(freshSubstitution, this.termContext);
                    terms.set(bindingExpPosition - 1, (Term)freshbindingExp);
                }
            }
            kList = new KList(ImmutableList.copyOf(terms));
        }
        this.match(kList, patternKItem.kList());
    }

    @Override
    public void match(Token token, Term pattern) {
        assert (!(pattern instanceof Variable));
        if (!token.equals(pattern)) {
            this.fail(token, pattern);
        }
    }

    @Override
    public void match(KList kList, Term pattern) {
        assert (!(pattern instanceof Variable));
        if (!(pattern instanceof KList)) {
            this.fail(kList, pattern);
        }
        KList otherKList = (KList)pattern;
        this.matchKCollection(kList, otherKList);
    }

    @Override
    public void match(KSequence kSequence, Term pattern) {
        assert (!(pattern instanceof Variable));
        if (!(pattern instanceof KSequence)) {
            this.fail(kSequence, pattern);
        }
        KSequence otherKSequence = (KSequence)pattern;
        this.matchKCollection(kSequence, otherKSequence);
    }

    private void matchKCollection(KCollection kCollection, KCollection pattern) {
        assert (kCollection.getClass().equals(pattern.getClass()));
        assert (!kCollection.hasFrame()) : "the subject term should be ground";
        int length = pattern.size();
        if (kCollection.size() >= length) {
            if (pattern.hasFrame()) {
                this.addSubstitution(pattern.frame(), kCollection.fragment(length));
            } else if (kCollection.size() > length) {
                this.fail(kCollection, pattern);
            }
            for (int index = 0; index < length; ++index) {
                this.match(kCollection.get(index), pattern.get(index));
            }
        } else {
            this.fail(kCollection, pattern);
        }
    }

    @Override
    public void match(MetaVariable metaVariable, Term pattern) {
        assert (!(pattern instanceof Variable));
        if (!metaVariable.equals(pattern)) {
            this.fail(metaVariable, pattern);
        }
    }

    @Override
    public void match(Variable variable, Term pattern) {
        assert (false) : "the subject term should be ground; but found variable " + variable;
    }

    @Override
    public String getName() {
        return this.getClass().toString();
    }

    private class SelectionGenerator {
        private final int size;
        private final int coSize;
        public List<Integer> selection;
        public Set<Integer> selected;
        private int index;

        public SelectionGenerator(int size, int coSize) {
            assert (size <= coSize);
            this.size = size;
            this.coSize = coSize;
            this.selection = new ArrayList<Integer>();
            this.selected = new HashSet<Integer>();
            for (int i = 0; i < size; ++i) {
                this.selection.add(i);
                this.selected.add(i);
            }
        }

        private void pop() {
            this.index = this.selection.remove(this.selection.size() - 1);
            this.selected.remove(this.index);
            ++this.index;
        }

        private void push() {
            this.selection.add(this.index);
            this.selected.add(this.index);
            this.index = 0;
        }

        public boolean generate() {
            if (this.selection.isEmpty()) {
                return false;
            }
            this.pop();
            while (this.selection.size() != this.size) {
                if (this.index == this.coSize) {
                    if (this.selection.isEmpty()) break;
                    this.pop();
                    continue;
                }
                if (!this.selected.contains(this.index)) {
                    this.push();
                    continue;
                }
                ++this.index;
            }
            return !this.selection.isEmpty();
        }
    }
}

