/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.symbolic;

import java.util.HashSet;
import java.util.Set;
import org.kframework.backend.java.kil.JavaSymbolicObject;
import org.kframework.backend.java.symbolic.KastStructureCheckerPlugin;
import org.kframework.backend.java.symbolic.LocalVisitor;
import org.kframework.backend.java.symbolic.PrePostVisitor;

public class PluggableKastStructureChecker
extends PrePostVisitor {
    private final Set<KastStructureCheckerPlugin> plugins = new HashSet<KastStructureCheckerPlugin>();
    private boolean isSuccess = true;

    public PluggableKastStructureChecker() {
        this.getPreVisitor().addVisitor(new StopWhenFail());
    }

    public void register(KastStructureCheckerPlugin plugin) {
        assert (!this.plugins.contains(plugin));
        this.plugins.add(plugin);
        plugin.registerTo(this);
        if (plugin.getPreVisitor() != null) {
            this.getPreVisitor().addVisitor(plugin.getPreVisitor());
        }
        if (plugin.getPostVisitor() != null) {
            this.getPostVisitor().addVisitor(plugin.getPostVisitor());
        }
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public void reset() {
        this.isSuccess = true;
        for (KastStructureCheckerPlugin plugin : this.plugins) {
            plugin.reset();
        }
    }

    public void flagFailure(KastStructureCheckerPlugin plugin) {
        assert (this.plugins.contains(plugin)) : "This method shall be called from a registered plugin only.";
        this.isSuccess = false;
    }

    private class StopWhenFail
    extends LocalVisitor {
        private StopWhenFail() {
        }

        @Override
        protected void visit(JavaSymbolicObject object) {
            if (!PluggableKastStructureChecker.this.isSuccess) {
                this.proceed = false;
            }
        }
    }
}

