/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.symbolic;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.kframework.backend.java.builtins.IntToken;
import org.kframework.backend.java.kil.ConstrainedTerm;
import org.kframework.backend.java.kil.Definition;
import org.kframework.backend.java.kil.JavaSymbolicObject;
import org.kframework.backend.java.kil.Rule;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.TermContext;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.symbolic.SymbolicConstraint;

public class StepRewriter {
    private final Definition definition;
    private final Collection<Rule> rules;
    private final Stopwatch stopwatch = new Stopwatch();
    private Collection<ConstrainedTerm> constrainedTermResults = new ArrayList<ConstrainedTerm>();
    private Collection<Term> termResults = new ArrayList<Term>();

    public StepRewriter(Collection<Rule> rules, Definition definition) {
        this.rules = new ArrayList<Rule>(rules);
        this.definition = definition;
    }

    public Collection<Term> getAllSuccessors(Term term) {
        for (Rule rule : this.rules) {
            this.rewriteByRule(term, rule);
        }
        return this.termResults;
    }

    public Collection<ConstrainedTerm> getAllNarrowingSuccessors(ConstrainedTerm constrainedTerm) {
        for (Rule rule : this.rules) {
            this.narrowByRule(constrainedTerm, rule);
        }
        return this.constrainedTermResults;
    }

    public Term getOneSuccessor(Term term) {
        for (Rule rule : this.rules) {
            this.rewriteByRule(term, rule);
            if (this.termResults.isEmpty()) continue;
            return this.termResults.iterator().next();
        }
        return null;
    }

    public ConstrainedTerm getOneNarrowingSuccessor(ConstrainedTerm constrainedTerm) {
        for (Rule rule : this.rules) {
            this.narrowByRule(constrainedTerm, rule);
            if (this.constrainedTermResults.isEmpty()) continue;
            return this.constrainedTermResults.iterator().next();
        }
        return null;
    }

    private void narrowByRule(ConstrainedTerm constrainedTerm, Rule rule) {
        this.stopwatch.reset();
        this.stopwatch.start();
        this.constrainedTermResults = new ArrayList<ConstrainedTerm>();
        SymbolicConstraint leftHandSideConstraint = new SymbolicConstraint(constrainedTerm.termContext());
        leftHandSideConstraint.addAll(rule.requires());
        for (Variable variable : rule.freshVariables()) {
            leftHandSideConstraint.add(variable, IntToken.fresh());
        }
        ConstrainedTerm leftHandSide = new ConstrainedTerm(rule.leftHandSide(), rule.lookups().getSymbolicConstraint(constrainedTerm.termContext()), leftHandSideConstraint, constrainedTerm.termContext());
        for (SymbolicConstraint constraint : constrainedTerm.unify(leftHandSide)) {
            constraint.addAll(rule.ensures());
            Map<Variable, Variable> freshSubstitution = constraint.rename(rule.variableSet());
            JavaSymbolicObject result = rule.rightHandSide();
            result = ((Term)result).substituteWithBinders(freshSubstitution, constrainedTerm.termContext());
            result = ((Term)result).substituteWithBinders(constraint.substitution(), constrainedTerm.termContext());
            result = ((Term)result).evaluate(constrainedTerm.termContext());
            constraint.eliminateAnonymousVariables();
            this.constrainedTermResults.add(new ConstrainedTerm((Term)result, constraint, constrainedTerm.termContext()));
        }
        this.stopwatch.stop();
    }

    private void rewriteByRule(Term term, Rule rule) {
        this.stopwatch.reset();
        this.stopwatch.start();
        this.termResults = new ArrayList<Term>();
        TermContext context = TermContext.of(this.definition);
        ConstrainedTerm constrainedTerm = new ConstrainedTerm(term, context);
        SymbolicConstraint leftHandSideConstraint = new SymbolicConstraint(context);
        leftHandSideConstraint.addAll(rule.requires());
        for (Variable variable : rule.freshVariables()) {
            leftHandSideConstraint.add(variable, IntToken.fresh());
        }
        ConstrainedTerm leftHandSide = new ConstrainedTerm(rule.leftHandSide(), rule.lookups().getSymbolicConstraint(context), leftHandSideConstraint, context);
        for (SymbolicConstraint constraint : constrainedTerm.unify(leftHandSide)) {
            if (!constraint.isMatching(leftHandSide)) continue;
            constraint.orientSubstitution(leftHandSide.variableSet());
            Term result = rule.rightHandSide();
            result = result.substituteAndEvaluate(constraint.substitution(), context);
            this.termResults.add(result);
        }
        this.stopwatch.stop();
    }
}

