/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.symbolic;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.Set;
import org.kframework.backend.java.kil.JavaSymbolicObject;
import org.kframework.backend.java.kil.KCollection;
import org.kframework.backend.java.kil.KCollectionFragment;
import org.kframework.backend.java.kil.KList;
import org.kframework.backend.java.kil.KSequence;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.TermContext;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.symbolic.LocalTransformer;
import org.kframework.backend.java.symbolic.PrePostTransformer;
import org.kframework.kil.ASTNode;

public class SubstitutionTransformer
extends PrePostTransformer {
    private final Map<Variable, ? extends Term> substitution;

    public SubstitutionTransformer(Map<Variable, ? extends Term> substitution, TermContext context) {
        super(context);
        this.substitution = substitution;
        this.preTransformer.addTransformer(new LocalVariableChecker());
        this.postTransformer.addTransformer(new LocalSubstitutionTransformer());
        this.postTransformer.addTransformer(new VariableUpdaterTransformer());
    }

    private class VariableUpdaterTransformer
    extends LocalTransformer {
        private VariableUpdaterTransformer() {
        }

        @Override
        protected ASTNode transform(JavaSymbolicObject object) {
            object.updateVariableSet();
            return object;
        }
    }

    private class LocalSubstitutionTransformer
    extends LocalTransformer {
        private LocalSubstitutionTransformer() {
        }

        @Override
        public Term transform(Variable variable) {
            Term term = (Term)SubstitutionTransformer.this.substitution.get(variable);
            if (term != null) {
                if (term instanceof KCollectionFragment) {
                    KCollection kCollection;
                    KCollectionFragment fragment = (KCollectionFragment)term;
                    ImmutableList.Builder builder = new ImmutableList.Builder();
                    builder.addAll((Iterable)fragment);
                    if (fragment.getKCollection() instanceof KSequence) {
                        kCollection = fragment.hasFrame() ? new KSequence((ImmutableList<Term>)builder.build(), fragment.frame()) : new KSequence((ImmutableList<Term>)builder.build());
                    } else {
                        assert (fragment.getKCollection() instanceof KList);
                        kCollection = fragment.hasFrame() ? new KList((ImmutableList<Term>)builder.build(), fragment.frame()) : new KList((ImmutableList<Term>)builder.build());
                    }
                    return kCollection;
                }
                return term;
            }
            return variable;
        }
    }

    private class LocalVariableChecker
    extends LocalTransformer {
        private LocalVariableChecker() {
        }

        @Override
        public ASTNode transform(JavaSymbolicObject object) {
            Set<Variable> variables = object.variableSet();
            for (Variable variable : SubstitutionTransformer.this.substitution.keySet()) {
                if (!variables.contains(variable)) continue;
                return object;
            }
            return new PrePostTransformer.DoneTransforming(object);
        }
    }
}

