/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.symbolic;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Solver;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Status;
import com.microsoft.z3.Symbol;
import com.microsoft.z3.Z3Exception;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.kframework.backend.java.builtins.BoolToken;
import org.kframework.backend.java.kil.Bottom;
import org.kframework.backend.java.kil.CellCollection;
import org.kframework.backend.java.kil.ConcreteCollectionVariable;
import org.kframework.backend.java.kil.ConstrainedTerm;
import org.kframework.backend.java.kil.DataStructureLookup;
import org.kframework.backend.java.kil.Definition;
import org.kframework.backend.java.kil.Hole;
import org.kframework.backend.java.kil.JavaSymbolicObject;
import org.kframework.backend.java.kil.KCollection;
import org.kframework.backend.java.kil.KItem;
import org.kframework.backend.java.kil.KLabel;
import org.kframework.backend.java.kil.KLabelConstant;
import org.kframework.backend.java.kil.KList;
import org.kframework.backend.java.kil.Kind;
import org.kframework.backend.java.kil.Sorted;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.TermContext;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.kil.Z3Term;
import org.kframework.backend.java.symbolic.BinderSubstitutionTransformer;
import org.kframework.backend.java.symbolic.KILtoZ3;
import org.kframework.backend.java.symbolic.LocalVisitor;
import org.kframework.backend.java.symbolic.PrePostVisitor;
import org.kframework.backend.java.symbolic.SymbolicUnifier;
import org.kframework.backend.java.symbolic.TermSubstitutionTransformer;
import org.kframework.backend.java.symbolic.Transformer;
import org.kframework.backend.java.symbolic.Visitor;
import org.kframework.backend.java.util.GappaPrinter;
import org.kframework.backend.java.util.GappaServer;
import org.kframework.backend.java.util.Z3Wrapper;
import org.kframework.kil.ASTNode;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.krun.K;

public class SymbolicConstraint
extends JavaSymbolicObject {
    private static final boolean DEBUG = true;
    public static final String SEPARATOR = " /\\ ";
    private static final Joiner joiner = Joiner.on(" /\\ ");
    private static final Joiner.MapJoiner substitutionJoiner = joiner.withKeyValueSeparator(" =? ");
    private final LinkedList<Equality> equalities = new LinkedList();
    private final ArrayList<Equality> equalityBuffer = new ArrayList();
    private boolean simplifyingEqualities = false;
    private boolean isNormal;
    private final Map<Variable, Term> substitution = new HashMap<Variable, Term>();
    private TruthValue truthValue;
    private Equality falsifyingEquality;
    private final TermContext context;
    private final Definition definition;
    private final SymbolicUnifier unifier;
    private boolean recursiveNormalize = false;

    public void orientSubstitution(Set<Variable> variables) {
        HashMap<Variable, Variable> newSubstitution = new HashMap<Variable, Variable>();
        if (this.substitution.keySet().containsAll(variables)) {
            return;
        }
        HashMap preimages = new HashMap();
        for (Map.Entry<Variable, Term> entry : this.substitution.entrySet()) {
            if (!(entry.getValue() instanceof Variable)) continue;
            Variable rhs = (Variable)entry.getValue();
            if (preimages.get(rhs) == null) {
                preimages.put(rhs, new HashSet());
            }
            ((Set)preimages.get(rhs)).add(entry.getKey());
        }
        HashSet<Variable> substitutionToRemove = new HashSet<Variable>();
        for (Map.Entry<Variable, Term> entry : this.substitution.entrySet()) {
            Variable variable = entry.getKey();
            Term rhs = entry.getValue();
            if (!variables.contains(rhs) || newSubstitution.containsKey(rhs)) continue;
            if (variables.contains(variable)) {
                HashSet preimagesOfRHS = new HashSet((Collection)preimages.get(rhs));
                preimagesOfRHS.removeAll(variables);
                if (preimagesOfRHS.isEmpty()) {
                    throw new RuntimeException("Orientation failed");
                }
                Variable newRHS = (Variable)preimagesOfRHS.iterator().next();
                newSubstitution.put(variable, newRHS);
                newSubstitution.put((Variable)rhs, newRHS);
                substitutionToRemove.add(variable);
                substitutionToRemove.add(newRHS);
                continue;
            }
            newSubstitution.put((Variable)rhs, variable);
            substitutionToRemove.add(variable);
        }
        HashMap result = new HashMap();
        for (Variable variable : substitutionToRemove) {
            this.substitution.remove(variable);
        }
        for (Map.Entry entry : newSubstitution.entrySet()) {
            this.substitution.remove(entry.getValue());
            result.put(entry.getKey(), ((Term)entry.getValue()).substituteWithBinders(newSubstitution, this.context));
        }
        for (Map.Entry entry : this.substitution.entrySet()) {
            result.put(entry.getKey(), ((Term)entry.getValue()).substituteWithBinders(newSubstitution, this.context));
        }
        this.substitution.clear();
        for (Map.Entry entry : result.entrySet()) {
            this.checkTruthValBeforePutIntoConstraint((Term)entry.getKey(), (Term)entry.getValue(), true);
        }
        this.isNormal = false;
    }

    public Equality falsifyingEquality() {
        return this.falsifyingEquality;
    }

    public SymbolicConstraint(SymbolicConstraint constraint, TermContext context) {
        this(context);
        this.substitution.putAll(constraint.substitution);
        this.addAll(constraint);
    }

    public SymbolicConstraint(TermContext context) {
        this.context = context;
        this.definition = context.definition();
        this.unifier = new SymbolicUnifier(this, context);
        this.truthValue = TruthValue.TRUE;
        this.isNormal = true;
    }

    public TermContext termContext() {
        return this.context;
    }

    public TruthValue add(Term leftHandSide, Term rightHandSide) {
        assert (this.checkKindMisMatch(leftHandSide, rightHandSide)) : "kind mismatch between " + leftHandSide + " (instanceof " + leftHandSide.getClass() + ")" + " and " + rightHandSide + " (instanceof " + rightHandSide.getClass() + ")";
        if (this.simplifyingEqualities) {
            Equality equality = new Equality(leftHandSide, rightHandSide);
            if (equality.isFalse()) {
                this.falsify(equality);
            } else if (equality.isUnknown()) {
                this.equalityBuffer.add(equality);
                this.isNormal = false;
            }
        } else {
            this.simplify();
            leftHandSide = leftHandSide.substituteAndEvaluate(this.substitution, this.context);
            rightHandSide = rightHandSide.substituteAndEvaluate(this.substitution, this.context);
            this.checkTruthValBeforePutIntoConstraint(leftHandSide, rightHandSide, false);
        }
        return this.truthValue;
    }

    private boolean checkKindMisMatch(Term leftHandSide, Term rightHandSide) {
        return !(leftHandSide.kind() != rightHandSide.kind() && (leftHandSide.kind() != Kind.KITEM && leftHandSide.kind() != Kind.K && leftHandSide.kind() != Kind.KLIST || rightHandSide.kind() != Kind.KITEM && rightHandSide.kind() != Kind.K && rightHandSide.kind() != Kind.KLIST) && (leftHandSide.kind() != Kind.CELL && leftHandSide.kind() != Kind.CELL_COLLECTION || rightHandSide.kind() != Kind.CELL && rightHandSide.kind() != Kind.CELL_COLLECTION));
    }

    private void checkTruthValBeforePutIntoConstraint(Term leftHandSide, Term rightHandSide, boolean putInSubst) {
        if (this.truthValue == TruthValue.FALSE) {
            return;
        }
        Equality equality = new Equality(leftHandSide, rightHandSide);
        if (equality.isUnknown()) {
            if (putInSubst) {
                Term origVal = this.substitution.put((Variable)leftHandSide, rightHandSide);
                if (origVal == null) {
                    this.isNormal = false;
                }
            } else {
                this.equalities.add(equality);
                this.isNormal = false;
            }
            this.truthValue = TruthValue.UNKNOWN;
        } else if (equality.isFalse()) {
            if (putInSubst) {
                this.substitution.put((Variable)leftHandSide, rightHandSide);
            } else {
                this.equalities.add(equality);
            }
            this.falsify(equality);
        }
    }

    public TruthValue addAll(Collection<Term> condition) {
        for (Term term : condition) {
            this.add(term, BoolToken.TRUE);
        }
        return this.truthValue;
    }

    public TruthValue addAll(SymbolicConstraint constraint) {
        for (Map.Entry<Variable, Term> entry : constraint.substitution.entrySet()) {
            this.add(entry.getValue(), entry.getKey());
        }
        for (Equality equality : constraint.equalities) {
            this.add(equality.leftHandSide, equality.rightHandSide);
        }
        return this.truthValue;
    }

    public boolean checkUnsat() {
        if (!K.smt.equals("z3")) {
            return false;
        }
        this.normalize();
        Boolean result = false;
        try {
            Context context = Z3Wrapper.newContext();
            KILtoZ3 transformer = new KILtoZ3(Collections.emptySet(), context);
            Solver solver = context.MkSolver();
            for (Equality equality : this.equalities) {
                solver.Assert(context.MkEq(((Z3Term)equality.leftHandSide.accept(transformer)).expression(), ((Z3Term)equality.rightHandSide.accept(transformer)).expression()));
            }
            result = solver.Check() == Status.UNSATISFIABLE;
            context.Dispose();
        }
        catch (Z3Exception e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<Equality> equalities() {
        this.normalize();
        return Collections.unmodifiableList(this.equalities);
    }

    public Map<Variable, Term> substitution() {
        this.normalize();
        return Collections.unmodifiableMap(this.substitution);
    }

    public void eliminateAnonymousVariables() {
        Iterator<Variable> iterator = this.substitution.keySet().iterator();
        while (iterator.hasNext()) {
            Variable variable = iterator.next();
            if (!variable.isAnonymous()) continue;
            iterator.remove();
        }
        if (this.equalities.isEmpty() && this.substitution.isEmpty()) {
            this.truthValue = TruthValue.TRUE;
        }
    }

    public TruthValue getTruthValue() {
        this.normalize();
        return this.truthValue;
    }

    public boolean implies(SymbolicConstraint constraint) {
        LinkedList<Implication> implications = new LinkedList<Implication>();
        implications.add(new Implication(this, constraint));
        while (!implications.isEmpty()) {
            Implication implication = (Implication)implications.remove();
            SymbolicConstraint left = implication.left;
            SymbolicConstraint right = implication.right;
            if (left.isFalse()) continue;
            System.out.println("Attempting to prove: \n\t" + left + "\n  implies \n\t" + right);
            right = left.simplifyConstraint(right);
            if (right.isTrue() || right.equalities().isEmpty()) {
                System.out.println("Implication proved by simplification");
                continue;
            }
            IfThenElseFinder ifThenElseFinder = new IfThenElseFinder(this.context);
            right.accept(ifThenElseFinder);
            if (!ifThenElseFinder.result.isEmpty()) {
                KItem ite = ifThenElseFinder.result.get(0);
                Term condition = ((KList)ite.kList()).get(0);
                System.out.println("Split on " + condition);
                SymbolicConstraint left1 = new SymbolicConstraint(left, this.context);
                left1.add(condition, BoolToken.TRUE);
                implications.add(new Implication(left1, new SymbolicConstraint(right, this.context)));
                SymbolicConstraint left2 = new SymbolicConstraint(left, this.context);
                left2.add(condition, BoolToken.FALSE);
                implications.add(new Implication(left2, new SymbolicConstraint(right, this.context)));
                continue;
            }
            if (!SymbolicConstraint.impliesSMT(left, right)) {
                System.out.println("Failure!");
                return false;
            }
            System.out.println("Proved!");
        }
        return true;
    }

    private static boolean impliesSMT(SymbolicConstraint left, SymbolicConstraint right) {
        boolean result = false;
        if (K.smt.equals("gappa")) {
            GappaPrinter.GappaPrintResult premises = GappaPrinter.toGappa(left);
            String gterm1 = premises.result;
            GappaPrinter.GappaPrintResult conclusion = GappaPrinter.toGappa(right);
            if (conclusion.exception != null) {
                System.err.print(conclusion.exception.getMessage());
                System.err.println(" Cannot prove the full implication!");
                return false;
            }
            String gterm2 = conclusion.result;
            String input = "";
            HashSet<String> variables = new HashSet<String>();
            variables.addAll(premises.variables);
            variables.addAll(conclusion.variables);
            for (String variable : variables) {
                GappaServer.addVariable(variable);
            }
            if (!gterm1.equals("")) {
                input = input + "(" + gterm1 + ") -> ";
            }
            input = input + "(" + gterm2 + ")";
            System.out.println("Verifying " + input);
            if (GappaServer.proveTrue(input)) {
                result = true;
            }
        } else if (K.smt.equals("z3")) {
            HashSet<Variable> rightHandSideVariables = new HashSet<Variable>(right.variableSet());
            rightHandSideVariables.removeAll(left.variableSet());
            try {
                Context context = Z3Wrapper.newContext();
                KILtoZ3 transformer = new KILtoZ3(rightHandSideVariables, context);
                Solver solver = context.MkSolver();
                for (Equality equality : left.equalities) {
                    solver.Assert(context.MkEq(((Z3Term)equality.leftHandSide.accept(transformer)).expression(), ((Z3Term)equality.rightHandSide.accept(transformer)).expression()));
                }
                BoolExpr[] inequalities = new BoolExpr[right.equalities.size()];
                int i = 0;
                for (Equality equality : right.equalities) {
                    inequalities[i++] = context.MkNot(context.MkEq(((Z3Term)equality.leftHandSide.accept(transformer)).expression(), ((Z3Term)equality.rightHandSide.accept(transformer)).expression()));
                }
                Sort[] variableSorts = new Sort[rightHandSideVariables.size()];
                Symbol[] variableNames = new Symbol[rightHandSideVariables.size()];
                i = 0;
                for (Variable variable : rightHandSideVariables) {
                    if (variable.sort().equals("Bool")) {
                        variableSorts[i] = context.MkBoolSort();
                    } else if (variable.sort().equals("Int")) {
                        variableSorts[i] = context.MkIntSort();
                    } else if (variable.sort().equals("Int32")) {
                        variableSorts[i] = context.MkBitVecSort(32);
                    } else {
                        throw new RuntimeException();
                    }
                    variableNames[i] = context.MkSymbol(variable.name());
                    ++i;
                }
                Expr[] boundVariables = new Expr[rightHandSideVariables.size()];
                i = 0;
                for (Variable variable : rightHandSideVariables) {
                    boundVariables[i++] = KILtoZ3.valueOf(variable, context).expression();
                }
                if (boundVariables.length > 0) {
                    solver.Assert(context.MkForall(boundVariables, context.MkOr(inequalities), 1, null, null, null, null));
                } else {
                    solver.Assert(context.MkOr(inequalities));
                }
                result = solver.Check() == Status.UNSATISFIABLE;
                context.Dispose();
            }
            catch (Z3Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private SymbolicConstraint simplifyConstraint(SymbolicConstraint constraint) {
        constraint.normalize();
        LinkedList<Equality> equalities = new LinkedList<Equality>(constraint.equalities());
        ListIterator listIterator = equalities.listIterator();
        block0: while (listIterator.hasNext()) {
            Equality e2 = (Equality)listIterator.next();
            for (Equality e1 : this.equalities()) {
                if (!e2.equals(e1)) continue;
                listIterator.remove();
                continue block0;
            }
        }
        HashMap<Term, Term> substitution = new HashMap<Term, Term>();
        for (Equality e1 : this.equalities()) {
            if (e1.rightHandSide.isGround()) {
                substitution.put(e1.leftHandSide, e1.rightHandSide);
            }
            if (!e1.leftHandSide.isGround()) continue;
            substitution.put(e1.rightHandSide, e1.leftHandSide);
        }
        constraint = (SymbolicConstraint)this.substituteTerms(constraint, substitution);
        constraint.renormalize();
        constraint.simplify();
        return constraint;
    }

    private JavaSymbolicObject substituteTerms(JavaSymbolicObject constraint, Map<Term, Term> substitution) {
        return (JavaSymbolicObject)constraint.accept(new TermSubstitutionTransformer(substitution, this.context));
    }

    public boolean isFalse() {
        this.normalize();
        return this.truthValue == TruthValue.FALSE;
    }

    public boolean isTrue() {
        this.normalize();
        return this.truthValue == TruthValue.TRUE;
    }

    public boolean isSubstitution() {
        this.normalize();
        return this.equalities.isEmpty() && this.unifier.multiConstraints.isEmpty();
    }

    public boolean isUnknown() {
        this.normalize();
        return this.truthValue == TruthValue.UNKNOWN;
    }

    private void falsify(Equality equality) {
        this.truthValue = TruthValue.FALSE;
        this.falsifyingEquality = equality;
    }

    public Collection<SymbolicConstraint> getMultiConstraints() {
        if (!this.unifier.multiConstraints.isEmpty()) {
            assert (this.unifier.multiConstraints.size() <= 2);
            ArrayList<SymbolicConstraint> multiConstraints = new ArrayList<SymbolicConstraint>();
            Iterator<Collection<SymbolicConstraint>> iterator = this.unifier.multiConstraints.iterator();
            if (this.unifier.multiConstraints.size() == 1) {
                for (SymbolicConstraint constraint : iterator.next()) {
                    constraint.addAll(this);
                    constraint.simplify();
                    multiConstraints.add(constraint);
                }
            } else {
                Collection<SymbolicConstraint> constraints = iterator.next();
                Collection<SymbolicConstraint> otherConstraints = iterator.next();
                for (SymbolicConstraint cnstr1 : constraints) {
                    for (SymbolicConstraint cnstr2 : otherConstraints) {
                        SymbolicConstraint constraint = new SymbolicConstraint(this, this.context);
                        constraint.addAll(cnstr1);
                        constraint.addAll(cnstr2);
                        constraint.simplify();
                        multiConstraints.add(constraint);
                    }
                }
            }
            return multiConstraints;
        }
        return Collections.singletonList(this);
    }

    public TruthValue simplify() {
        boolean change;
        if (this.truthValue == TruthValue.FALSE) {
            return this.truthValue;
        }
        block0: do {
            change = false;
            this.normalize();
            this.simplifyingEqualities = true;
            Iterator iterator = this.equalities.iterator();
            while (iterator.hasNext()) {
                Equality equality = (Equality)iterator.next();
                if (equality.leftHandSide.isSymbolic() || equality.rightHandSide.isSymbolic()) continue;
                iterator.remove();
                if (!this.unifier.unify(equality)) {
                    this.falsify(new Equality(this.unifier.unificationFailureLeftHandSide(), this.unifier.unificationFailureRightHandSide()));
                    this.simplifyingEqualities = false;
                    break block0;
                }
                change = true;
            }
            this.simplifyingEqualities = false;
        } while (change);
        return this.truthValue;
    }

    private void normalize() {
        assert (!this.simplifyingEqualities) : "Do not modify the equalities when they are being simplified";
        if (this.isNormal) {
            return;
        }
        assert (!this.recursiveNormalize) : "recursive normalization shall not happen";
        this.recursiveNormalize = true;
        this.renormalize();
        if (this.equalities.isEmpty() && this.substitution.isEmpty()) {
            this.truthValue = TruthValue.TRUE;
        }
        this.recursiveNormalize = false;
    }

    private void renormalize() {
        this.isNormal = true;
        this.equalities.addAll(this.equalityBuffer);
        this.equalityBuffer.clear();
        HashSet<Equality> equalitiesToRemove = new HashSet<Equality>();
        for (Equality equality : this.equalities) {
            Equality previousEquality;
            Term term;
            Variable variable;
            equality.substitute(this.substitution);
            if (equality.isTrue()) {
                equalitiesToRemove.add(equality);
                continue;
            }
            if (equality.isFalse()) {
                this.falsify(equality);
                return;
            }
            if (equality.leftHandSide instanceof Variable && equality.rightHandSide instanceof Variable && ((Variable)equality.rightHandSide).isAnonymous()) {
                variable = (Variable)equality.rightHandSide;
                term = equality.leftHandSide;
            } else if (equality.leftHandSide instanceof Variable) {
                variable = (Variable)equality.leftHandSide;
                term = equality.rightHandSide;
            } else {
                if (!(equality.rightHandSide instanceof Variable)) continue;
                variable = (Variable)equality.rightHandSide;
                term = equality.leftHandSide;
            }
            if (term.variableSet().contains(variable)) continue;
            Map<Variable, Term> tempSubst = Collections.singletonMap(variable, term);
            this.composeSubstitution(tempSubst, this.context, false);
            if (this.truthValue == TruthValue.FALSE) {
                return;
            }
            Iterator previousIterator = this.equalities.iterator();
            while (previousIterator.hasNext() && (previousEquality = (Equality)previousIterator.next()) != equality) {
                if (equalitiesToRemove.contains(previousEquality)) continue;
                previousEquality.substituteAndEvaluate(tempSubst);
                if (previousEquality.isTrue()) {
                    equalitiesToRemove.add(previousEquality);
                    continue;
                }
                if (!previousEquality.isFalse()) continue;
                this.falsify(previousEquality);
                return;
            }
            equalitiesToRemove.add(equality);
        }
        this.equalities.removeAll(equalitiesToRemove);
    }

    private void composeSubstitution(Map<Variable, Term> substMap, TermContext context, boolean mayInvalidateNormality) {
        Map.Entry[] entries;
        for (Map.Entry subst : entries = this.substitution.entrySet().toArray(new Map.Entry[this.substitution.size()])) {
            JavaSymbolicObject term = ((Term)subst.getValue()).substitute(substMap, context);
            if (term == subst.getValue()) continue;
            this.checkTruthValBeforePutIntoConstraint((Term)subst.getKey(), (Term)term, true);
        }
        HashSet<Variable> variables = new HashSet<Variable>(this.substitution.keySet());
        variables.retainAll(substMap.keySet());
        assert (variables.isEmpty()) : "There shall be no common variables in the two substitution maps to be composed.";
        this.substitution.putAll(substMap);
        if (mayInvalidateNormality) {
            this.isNormal = false;
        }
    }

    public Map<Variable, Variable> rename(Set<Variable> variableSet) {
        Map<Variable, Variable> freshSubstitution = Variable.getFreshSubstitution(variableSet);
        for (Variable variable : variableSet) {
            if (this.substitution.get(variable) == null) continue;
            this.substitution.put(freshSubstitution.get(variable), this.substitution.remove(variable));
        }
        for (Map.Entry entry : this.substitution.entrySet()) {
            entry.setValue(((Term)entry.getValue()).substituteWithBinders(freshSubstitution, this.context));
        }
        for (Equality equality : this.equalities) {
            equality.substitute(freshSubstitution);
        }
        return freshSubstitution;
    }

    @Override
    public SymbolicConstraint substituteWithBinders(Map<Variable, ? extends Term> substitution, TermContext context) {
        if (substitution.isEmpty()) {
            return this;
        }
        return (SymbolicConstraint)this.accept(new BinderSubstitutionTransformer(substitution, context));
    }

    @Override
    public SymbolicConstraint substituteWithBinders(Variable variable, Term term, TermContext context) {
        return this.substituteWithBinders(Collections.singletonMap(variable, term), context);
    }

    public boolean isMatching(ConstrainedTerm pattern) {
        this.orientSubstitution(pattern.variableSet());
        if (!this.isSubstitution() || !this.substitution.keySet().equals(pattern.variableSet())) {
            return false;
        }
        for (Map.Entry<Variable, Term> entry : this.substitution.entrySet()) {
            String sortOfSubst;
            String sortOfPatVar = entry.getKey().sort();
            Term subst = entry.getValue();
            if (subst instanceof DataStructureLookup) {
                return false;
            }
            String string = sortOfSubst = subst instanceof Sorted ? ((Sorted)((Object)subst)).sort() : subst.kind().toString();
            if (!this.definition.context().isSubsortedEq(sortOfPatVar, sortOfSubst)) {
                return false;
            }
            if (!(entry.getKey() instanceof ConcreteCollectionVariable) || entry.getValue() instanceof ConcreteCollectionVariable && ((ConcreteCollectionVariable)entry.getKey()).concreteCollectionSize() == ((ConcreteCollectionVariable)entry.getValue()).concreteCollectionSize() || entry.getValue() instanceof org.kframework.backend.java.kil.Collection && !((org.kframework.backend.java.kil.Collection)entry.getValue()).hasFrame() && ((ConcreteCollectionVariable)entry.getKey()).concreteCollectionSize() == ((org.kframework.backend.java.kil.Collection)entry.getValue()).size()) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SymbolicConstraint)) {
            return false;
        }
        SymbolicConstraint constraint = (SymbolicConstraint)object;
        return this.equalities.equals(constraint.equalities) && this.substitution.equals(constraint.substitution);
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 47 + this.equalities.hashCode();
        hash = hash * 47 + this.substitution.hashCode();
        return hash;
    }

    public String toString() {
        if (this.truthValue == TruthValue.TRUE) {
            return "true";
        }
        if (this.truthValue == TruthValue.FALSE) {
            return "false";
        }
        StringBuilder builder = new StringBuilder();
        if ((builder = joiner.appendTo(builder, (Iterable<?>)this.equalities)).length() != 0 && !this.substitution.isEmpty()) {
            builder.append(SEPARATOR);
        }
        builder = substitutionJoiner.appendTo(builder, this.substitution);
        return builder.toString();
    }

    @Override
    public ASTNode accept(Transformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ASTNode shallowCopy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTNode accept(org.kframework.kil.visitors.Transformer transformer) throws TransformerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(org.kframework.kil.visitors.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    private class IfThenElseFinder
    extends PrePostVisitor {
        final List<KItem> result = new ArrayList<KItem>();
        private String IF_THEN_ELSE_LABEL = "'#if_#then_#else_#fi";

        public IfThenElseFinder(TermContext context) {
            this.preVisitor.addVisitor(new LocalVisitor(){

                @Override
                protected void visit(JavaSymbolicObject object) {
                    this.proceed = IfThenElseFinder.this.result.isEmpty();
                }
            });
            this.postVisitor.addVisitor(new LocalVisitor(){

                @Override
                public void visit(KItem kItem) {
                    if (!IfThenElseFinder.this.result.isEmpty()) {
                        return;
                    }
                    if (kItem.kLabel() instanceof KLabelConstant && ((KLabelConstant)kItem.kLabel()).label().equals(IfThenElseFinder.this.IF_THEN_ELSE_LABEL)) {
                        IfThenElseFinder.this.result.add(kItem);
                    }
                }
            });
        }
    }

    public class Equality {
        public static final String SEPARATOR = " =? ";
        private Term leftHandSide;
        private Term rightHandSide;

        private Equality(Term leftHandSide, Term rightHandSide) {
            if (leftHandSide instanceof Bottom) {
                rightHandSide = leftHandSide;
            }
            if (rightHandSide instanceof Bottom) {
                leftHandSide = rightHandSide;
            }
            assert (SymbolicConstraint.this.checkKindMisMatch(leftHandSide, rightHandSide)) : "kind mismatch between " + leftHandSide + " (instanceof " + leftHandSide.getClass() + ")" + " and " + rightHandSide + " (instanceof " + rightHandSide.getClass() + ")";
            if (leftHandSide.kind() == Kind.K || leftHandSide.kind() == Kind.KLIST) {
                leftHandSide = KCollection.downKind(leftHandSide);
            }
            if (leftHandSide.kind() == Kind.CELL_COLLECTION) {
                leftHandSide = CellCollection.downKind(leftHandSide);
            }
            if (rightHandSide.kind() == Kind.K || rightHandSide.kind() == Kind.KLIST) {
                rightHandSide = KCollection.downKind(rightHandSide);
            }
            if (rightHandSide.kind() == Kind.CELL_COLLECTION) {
                rightHandSide = CellCollection.downKind(rightHandSide);
            }
            this.leftHandSide = leftHandSide;
            this.rightHandSide = rightHandSide;
        }

        public Term leftHandSide() {
            return this.leftHandSide;
        }

        public Term rightHandSide() {
            return this.rightHandSide;
        }

        public boolean isFalse() {
            if (this.leftHandSide instanceof Bottom || this.rightHandSide instanceof Bottom) {
                return true;
            }
            if (this.leftHandSide.isGround() && this.rightHandSide.isGround()) {
                return !this.leftHandSide.equals(this.rightHandSide);
            }
            if (!(this.leftHandSide instanceof Sorted) || !(this.rightHandSide instanceof Sorted)) {
                return false;
            }
            if (this.leftHandSide == Hole.HOLE && this.rightHandSide instanceof Sorted && !SymbolicConstraint.this.definition.context().isSubsortedEq(((Sorted)((Object)this.rightHandSide)).sort(), "KItem")) {
                return true;
            }
            if (this.rightHandSide == Hole.HOLE && this.leftHandSide instanceof Sorted && !SymbolicConstraint.this.definition.context().isSubsortedEq(((Sorted)((Object)this.leftHandSide)).sort(), "KItem")) {
                return true;
            }
            if (this.leftHandSide instanceof ConcreteCollectionVariable && !((ConcreteCollectionVariable)this.leftHandSide).matchConcreteSize(this.rightHandSide)) {
                return true;
            }
            if (this.rightHandSide instanceof ConcreteCollectionVariable && !((ConcreteCollectionVariable)this.rightHandSide).matchConcreteSize(this.leftHandSide)) {
                return true;
            }
            if (!K.do_testgen) {
                if (this.leftHandSide instanceof KItem && ((KItem)this.leftHandSide).kLabel() instanceof KLabel && ((KLabel)((KItem)this.leftHandSide).kLabel()).isConstructor()) {
                    return !SymbolicConstraint.this.definition.context().isSubsortedEq(((Sorted)((Object)this.rightHandSide)).sort(), ((KItem)this.leftHandSide).sort());
                }
                if (this.rightHandSide instanceof KItem && ((KItem)this.rightHandSide).kLabel() instanceof KLabel && ((KLabel)((KItem)this.rightHandSide).kLabel()).isConstructor()) {
                    return !SymbolicConstraint.this.definition.context().isSubsortedEq(((Sorted)((Object)this.leftHandSide)).sort(), ((KItem)this.rightHandSide).sort());
                }
                if (this.leftHandSide instanceof KCollection && ((KCollection)this.leftHandSide).size() > 1) {
                    return !SymbolicConstraint.this.definition.context().isSubsortedEq(((Sorted)((Object)this.rightHandSide)).sort(), this.leftHandSide.kind().toString());
                }
                if (this.rightHandSide instanceof KCollection && ((KCollection)this.rightHandSide).size() > 1) {
                    return !SymbolicConstraint.this.definition.context().isSubsortedEq(((Sorted)((Object)this.leftHandSide)).sort(), this.rightHandSide.kind().toString());
                }
                return null == SymbolicConstraint.this.definition.context().getGLBSort(ImmutableSet.of(((Sorted)((Object)this.leftHandSide)).sort(), ((Sorted)((Object)this.rightHandSide)).sort()));
            }
            if (this.leftHandSide instanceof KItem && ((KItem)this.leftHandSide).kLabel() instanceof KLabel && ((KLabel)((KItem)this.leftHandSide).kLabel()).isConstructor()) {
                for (String pms : ((KItem)this.leftHandSide).possibleMinimalSorts()) {
                    if (!SymbolicConstraint.this.definition.context().isSubsortedEq(((Sorted)((Object)this.rightHandSide)).sort(), pms)) continue;
                    return false;
                }
                return true;
            }
            if (this.rightHandSide instanceof KItem && ((KItem)this.rightHandSide).kLabel() instanceof KLabel && ((KLabel)((KItem)this.rightHandSide).kLabel()).isConstructor()) {
                for (String pms : ((KItem)this.rightHandSide).possibleMinimalSorts()) {
                    if (!SymbolicConstraint.this.definition.context().isSubsortedEq(((Sorted)((Object)this.leftHandSide)).sort(), pms)) continue;
                    return false;
                }
                return true;
            }
            return SymbolicConstraint.this.definition.context().getCommonSubsorts(ImmutableSet.of(((Sorted)((Object)this.leftHandSide)).sort(), ((Sorted)((Object)this.rightHandSide)).sort())).isEmpty();
        }

        public boolean isTrue() {
            if (this.leftHandSide instanceof Bottom || this.rightHandSide instanceof Bottom) {
                return false;
            }
            return this.leftHandSide.equals(this.rightHandSide);
        }

        public boolean isUnknown() {
            return !this.isTrue() && !this.isFalse();
        }

        private void substitute(Map<Variable, ? extends Term> substitution) {
            this.leftHandSide = this.leftHandSide.substituteWithBinders((Map)substitution, SymbolicConstraint.this.context);
            this.rightHandSide = this.rightHandSide.substituteWithBinders((Map)substitution, SymbolicConstraint.this.context);
        }

        public void substituteAndEvaluate(Map<Variable, ? extends Term> substitution) {
            this.leftHandSide = this.leftHandSide.substituteAndEvaluate(substitution, SymbolicConstraint.this.context);
            this.rightHandSide = this.rightHandSide.substituteAndEvaluate(substitution, SymbolicConstraint.this.context);
        }

        public String toString() {
            return this.leftHandSide + SEPARATOR + this.rightHandSide;
        }
    }

    public class Implication {
        SymbolicConstraint left;
        SymbolicConstraint right;

        public Implication(SymbolicConstraint left, SymbolicConstraint right) {
            this.left = left;
            this.right = right;
        }
    }

    public static enum TruthValue {
        TRUE,
        UNKNOWN,
        FALSE;

    }
}

