/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.symbolic;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.kframework.backend.java.builtins.IntToken;
import org.kframework.backend.java.indexing.Index;
import org.kframework.backend.java.indexing.IndexingPair;
import org.kframework.backend.java.indexing.IndexingTable;
import org.kframework.backend.java.indexing.RuleIndex;
import org.kframework.backend.java.kil.Cell;
import org.kframework.backend.java.kil.CellCollection;
import org.kframework.backend.java.kil.ConstrainedTerm;
import org.kframework.backend.java.kil.Definition;
import org.kframework.backend.java.kil.JavaSymbolicObject;
import org.kframework.backend.java.kil.Rule;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.TermContext;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.strategies.TransitionCompositeStrategy;
import org.kframework.backend.java.symbolic.CheckingLeftAssocConstructs;
import org.kframework.backend.java.symbolic.CheckingNestedStructureDepth;
import org.kframework.backend.java.symbolic.PluggableKastStructureChecker;
import org.kframework.backend.java.symbolic.SymbolicConstraint;
import org.kframework.backend.java.symbolic.VariableCollector;
import org.kframework.backend.java.util.TestCaseGenerationUtil;
import org.kframework.krun.K;
import org.kframework.krun.api.SearchType;
import org.kframework.krun.api.io.FileSystem;
import org.kframework.utils.general.GlobalSettings;
import org.kframework.utils.general.IndexingStatistics;

public class SymbolicRewriter {
    private final Definition definition;
    private final TransitionCompositeStrategy strategy = new TransitionCompositeStrategy(GlobalSettings.transition);
    private final Stopwatch stopwatch = new Stopwatch();
    private int step;
    private final Stopwatch ruleStopwatch = new Stopwatch();
    private final List<ConstrainedTerm> results = new ArrayList<ConstrainedTerm>();
    private final List<Rule> appliedRules = new ArrayList<Rule>();
    private boolean transition;
    private final PluggableKastStructureChecker phase1PluggableKastChecker;
    private final PluggableKastStructureChecker phase2PluggableKastChecker;
    private RuleIndex ruleIndex;

    public SymbolicRewriter(Definition definition) {
        this.definition = definition;
        this.ruleIndex = definition.getIndex();
        if (K.do_testgen) {
            this.phase1PluggableKastChecker = new PluggableKastStructureChecker();
            this.phase1PluggableKastChecker.register(new CheckingNestedStructureDepth());
            this.phase1PluggableKastChecker.register(new CheckingLeftAssocConstructs(definition));
            this.phase2PluggableKastChecker = new PluggableKastStructureChecker();
            this.phase2PluggableKastChecker.register(new CheckingLeftAssocConstructs(definition));
        } else {
            this.phase1PluggableKastChecker = null;
            this.phase2PluggableKastChecker = null;
        }
    }

    public ConstrainedTerm rewrite(ConstrainedTerm constrainedTerm, int bound) {
        this.stopwatch.start();
        this.step = 0;
        while (this.step != bound) {
            this.computeRewriteStep(constrainedTerm, 1);
            ConstrainedTerm result = this.getTransition(0);
            if (result == null) break;
            constrainedTerm = result;
            ++this.step;
        }
        this.stopwatch.stop();
        System.err.println("[" + this.step + ", " + this.stopwatch + "]");
        return constrainedTerm;
    }

    public ConstrainedTerm rewrite(ConstrainedTerm constrainedTerm) {
        return this.rewrite(constrainedTerm, -1);
    }

    public ArrayList<ConstrainedTerm> rewriteAll(ConstrainedTerm constrainedTerm) {
        this.computeRewriteStep(constrainedTerm);
        return (ArrayList)this.results;
    }

    public Map<Index, List<Rule>> getSimulationMap() {
        return ((IndexingTable)this.ruleIndex).getSimulationRuleTable();
    }

    private List<Rule> getSimulationRules(Term term) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (IndexingPair pair : term.getIndexingPairs(this.definition)) {
            if (((IndexingTable)this.ruleIndex).getSimulationRuleTable().get(pair.first) == null) continue;
            rules.addAll((Collection<Rule>)((IndexingTable)this.ruleIndex).getSimulationRuleTable().get(pair.first));
        }
        return rules;
    }

    private List<Rule> getRules(Term term) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        if (K.get_indexing_stats) {
            IndexingStatistics.getRulesForTermStopWatch.reset();
            IndexingStatistics.getRulesForTermStopWatch.start();
        }
        rules.addAll(this.ruleIndex.getRules(term));
        if (K.get_indexing_stats) {
            IndexingStatistics.rulesSelectedAtEachStep.add(rules.size());
            long elapsed = IndexingStatistics.getRulesForTermStopWatch.stop().elapsed(TimeUnit.MICROSECONDS);
            IndexingStatistics.timesForRuleSelection.add(elapsed);
        }
        return rules;
    }

    private ConstrainedTerm getTransition(int n) {
        return n < this.results.size() ? this.results.get(n) : null;
    }

    public ConstrainedTerm computeSimulationStep(ConstrainedTerm constrainedTerm) {
        this.strategy.reset(this.getSimulationRules(constrainedTerm.term()));
        while (this.strategy.hasNext()) {
            this.transition = this.strategy.nextIsTransition();
            List rules = (List)this.strategy.next();
            for (Rule rule : rules) {
                this.ruleStopwatch.reset();
                this.ruleStopwatch.start();
                SymbolicConstraint leftHandSideConstraint = new SymbolicConstraint(constrainedTerm.termContext());
                leftHandSideConstraint.addAll(rule.requires());
                CellCollection newTemp = new CellCollection();
                newTemp.cellMap().put(((Cell)rule.leftHandSide()).getLabel(), (Cell)rule.leftHandSide());
                Cell<CellCollection> newRuleTerm = new Cell<CellCollection>("generatedTop", newTemp);
                ConstrainedTerm leftHandSideTerm = new ConstrainedTerm(newRuleTerm, rule.lookups().getSymbolicConstraint(constrainedTerm.termContext()), leftHandSideConstraint, constrainedTerm.termContext());
                SymbolicConstraint constraint = constrainedTerm.matchImplies(leftHandSideTerm);
                if (constraint == null) continue;
                constraint.addAll(rule.ensures());
                Map<Variable, Variable> freshSubstitution = constraint.rename(rule.variableSet());
                JavaSymbolicObject result = rule.rightHandSide();
                result = ((Term)result).substituteWithBinders(freshSubstitution, constrainedTerm.termContext());
                result = ((Term)result).substituteWithBinders(constraint.substitution(), constrainedTerm.termContext());
                constraint.eliminateAnonymousVariables();
                return new ConstrainedTerm((Term)result, constraint, constrainedTerm.termContext());
            }
        }
        return null;
    }

    private void computeRewriteStep(ConstrainedTerm constrainedTerm, int successorBound) {
        if (K.get_indexing_stats) {
            IndexingStatistics.rewriteStepStopWatch.reset();
            IndexingStatistics.rewriteStepStopWatch.start();
        }
        this.results.clear();
        this.appliedRules.clear();
        if (successorBound == 0) {
            return;
        }
        this.strategy.reset(this.getRules(constrainedTerm.term()));
        while (this.strategy.hasNext()) {
            if (K.get_indexing_stats) {
                IndexingStatistics.rewritingStopWatch.reset();
                IndexingStatistics.rewritingStopWatch.start();
            }
            this.transition = this.strategy.nextIsTransition();
            ArrayList<Rule> rules = new ArrayList<Rule>(this.strategy.next());
            for (Rule rule : rules) {
                this.ruleStopwatch.reset();
                this.ruleStopwatch.start();
                SymbolicConstraint leftHandSideConstraint = new SymbolicConstraint(constrainedTerm.termContext());
                leftHandSideConstraint.addAll(rule.requires());
                for (Variable variable : rule.freshVariables()) {
                    leftHandSideConstraint.add(variable, IntToken.fresh());
                }
                ConstrainedTerm leftHandSide = new ConstrainedTerm(rule.leftHandSide(), rule.lookups().getSymbolicConstraint(constrainedTerm.termContext()), leftHandSideConstraint, constrainedTerm.termContext());
                for (SymbolicConstraint constraint1 : constrainedTerm.unify(leftHandSide)) {
                    constraint1.orientSubstitution(rule.leftHandSide().variableSet());
                    constraint1.addAll(rule.ensures());
                    JavaSymbolicObject result = rule.rightHandSide();
                    if (rule.hasUnboundedVariables()) {
                        Map<Variable, Variable> freshSubstitution = constraint1.rename(rule.variableSet());
                        result = result.substituteWithBinders(freshSubstitution, constrainedTerm.termContext());
                    }
                    result = result.substituteAndEvaluate(constraint1.substitution(), constrainedTerm.termContext());
                    constraint1.eliminateAnonymousVariables();
                    ConstrainedTerm newCnstrTerm = new ConstrainedTerm((Term)result, constraint1, constrainedTerm.termContext());
                    this.results.add(newCnstrTerm);
                    this.appliedRules.add(rule);
                    if (K.get_indexing_stats) {
                        IndexingStatistics.rewritingStopWatch.stop();
                        IndexingStatistics.timesForRewriting.add(IndexingStatistics.rewritingStopWatch.elapsed(TimeUnit.MICROSECONDS));
                    }
                    if (this.results.size() != successorBound) continue;
                    if (K.get_indexing_stats) {
                        IndexingStatistics.rewriteStepStopWatch.stop();
                        long elapsed = IndexingStatistics.rewriteStepStopWatch.elapsed(TimeUnit.MICROSECONDS);
                        IndexingStatistics.timesForRewriteSteps.add(elapsed);
                    }
                    return;
                }
            }
            if (this.results.size() <= 0) continue;
            if (K.get_indexing_stats) {
                IndexingStatistics.rewriteStepStopWatch.stop();
                long elapsed = IndexingStatistics.rewriteStepStopWatch.elapsed(TimeUnit.MICROSECONDS);
                IndexingStatistics.timesForRewriteSteps.add(elapsed);
            }
            return;
        }
    }

    private void computeRewriteStep(ConstrainedTerm constrainedTerm) {
        this.computeRewriteStep(constrainedTerm, -1);
    }

    private ConstrainedTerm applyRule(ConstrainedTerm constrainedTerm, List<Rule> rules) {
        for (Rule rule : rules) {
            this.ruleStopwatch.reset();
            this.ruleStopwatch.start();
            SymbolicConstraint leftHandSideConstraint = new SymbolicConstraint(constrainedTerm.termContext());
            leftHandSideConstraint.addAll(rule.requires());
            ConstrainedTerm leftHandSideTerm = new ConstrainedTerm(rule.leftHandSide(), rule.lookups().getSymbolicConstraint(constrainedTerm.termContext()), leftHandSideConstraint, constrainedTerm.termContext());
            SymbolicConstraint constraint = constrainedTerm.matchImplies(leftHandSideTerm);
            if (constraint == null) continue;
            constraint.addAll(rule.ensures());
            Map<Variable, Variable> freshSubstitution = constraint.rename(rule.variableSet());
            JavaSymbolicObject result = rule.rightHandSide();
            result = ((Term)result).substituteWithBinders(freshSubstitution, constrainedTerm.termContext());
            result = ((Term)result).substituteWithBinders(constraint.substitution(), constrainedTerm.termContext());
            result = ((Term)result).evaluate(constrainedTerm.termContext());
            constraint.eliminateAnonymousVariables();
            return new ConstrainedTerm((Term)result, constraint, constrainedTerm.termContext());
        }
        return null;
    }

    private Map<Variable, Term> getSubstitutionMap(ConstrainedTerm term, Rule pattern) {
        SymbolicConstraint termConstraint = new SymbolicConstraint(term.termContext());
        termConstraint.addAll(pattern.requires());
        for (Variable var : pattern.freshVariables()) {
            termConstraint.add(var, IntToken.fresh());
        }
        ConstrainedTerm lhs = new ConstrainedTerm(pattern.leftHandSide(), pattern.lookups().getSymbolicConstraint(term.termContext()), termConstraint, term.termContext());
        VariableCollector visitor = new VariableCollector();
        lhs.accept(visitor);
        List<SymbolicConstraint> constraints = term.unify(lhs);
        if (constraints.isEmpty()) {
            return null;
        }
        HashMap<Variable, Term> map = new HashMap<Variable, Term>();
        for (SymbolicConstraint constraint : constraints) {
            if (!constraint.isSubstitution()) {
                return null;
            }
            constraint.orientSubstitution(visitor.getVariableSet());
            for (Variable variable : visitor.getVariableSet()) {
                Term value = constraint.substitution().get(variable);
                if (value == null) {
                    return null;
                }
                map.put(variable, new Cell<Term>("generatedTop", value));
            }
        }
        return map;
    }

    public List<Map<Variable, Term>> search(ConstrainedTerm initialTerm, ConstrainedTerm targetTerm, List<Rule> rules, Rule pattern, int bound, int depth, SearchType searchType) {
        Map<Variable, Term> map;
        this.stopwatch.start();
        ArrayList<Map<Variable, Term>> searchResults = new ArrayList<Map<Variable, Term>>();
        HashSet<ConstrainedTerm> visited = new HashSet<ConstrainedTerm>();
        if (depth == 0) {
            Map<Variable, Term> map2 = this.getSubstitutionMap(initialTerm, pattern);
            if (map2 != null) {
                searchResults.add(map2);
            }
            this.stopwatch.stop();
            System.err.println("[" + visited.size() + "states, " + this.step + "steps, " + this.stopwatch + "]");
            return searchResults;
        }
        LinkedHashMap<ConstrainedTerm, Integer> queue = new LinkedHashMap<ConstrainedTerm, Integer>();
        LinkedHashMap<ConstrainedTerm, Integer> nextQueue = new LinkedHashMap<ConstrainedTerm, Integer>();
        visited.add(initialTerm);
        queue.put(initialTerm, 0);
        if (searchType == SearchType.ONE) {
            depth = 1;
        }
        if (searchType == SearchType.STAR && (map = this.getSubstitutionMap(initialTerm, pattern)) != null) {
            searchResults.add(map);
        }
        this.step = 0;
        block0: while (!queue.isEmpty()) {
            block1: for (Map.Entry entry : queue.entrySet()) {
                Map<Variable, Term> map3;
                ConstrainedTerm term = (ConstrainedTerm)entry.getKey();
                Integer currentDepth = (Integer)entry.getValue();
                this.computeRewriteStep(term);
                if (this.results.isEmpty() && searchType == SearchType.FINAL && (map3 = this.getSubstitutionMap(term, pattern)) != null) {
                    searchResults.add(map3);
                    if (searchResults.size() == bound) break block0;
                }
                for (ConstrainedTerm result : this.results) {
                    Map<Variable, Term> map4;
                    if (!this.transition) {
                        nextQueue.put(result, currentDepth);
                        continue block1;
                    }
                    if (currentDepth + 1 != depth && visited.add(result)) {
                        nextQueue.put(result, currentDepth + 1);
                    }
                    if (searchType == SearchType.FINAL && currentDepth + 1 != depth || (map4 = this.getSubstitutionMap(result, pattern)) == null) continue;
                    searchResults.add(map4);
                    if (searchResults.size() != bound) continue;
                    break block0;
                }
            }
            LinkedHashMap<ConstrainedTerm, Integer> temp = queue;
            queue = nextQueue;
            nextQueue = temp;
            nextQueue.clear();
            ++this.step;
        }
        this.stopwatch.stop();
        System.err.println("[" + visited.size() + "states, " + this.step + "steps, " + this.stopwatch + "]");
        return searchResults;
    }

    public List<ConstrainedTerm> generate(ConstrainedTerm initialTerm, ConstrainedTerm targetTerm, List<Rule> rules, int bound, int depth) {
        this.stopwatch.start();
        ArrayList<ConstrainedTerm> testgenResults = new ArrayList<ConstrainedTerm>();
        HashSet<ConstrainedTerm> visited = new HashSet<ConstrainedTerm>();
        List<ConstrainedTerm> queue = new ArrayList<ConstrainedTerm>();
        ArrayList<ConstrainedTerm> nextQueue = new ArrayList<ConstrainedTerm>();
        ArrayList<Rule> nextQueueOfRules = new ArrayList<Rule>();
        visited.add(initialTerm);
        queue.add(initialTerm);
        this.step = 0;
        block0: while (!queue.isEmpty() && this.step != depth) {
            System.out.printf("testgen #step = %s, size = %s\n", this.step, queue.size());
            HashMap<String, Integer> ruleDistStats = new HashMap<String, Integer>();
            nextQueueOfRules.clear();
            for (ConstrainedTerm term : queue) {
                this.computeRewriteStep(term);
                this.performKastStructureCheck(this.phase1PluggableKastChecker, initialTerm);
                this.eliminateTermsWithNumOfFreeVarsGT(10);
                this.eliminateShadowedRewriteSteps();
                TestCaseGenerationUtil.updateRuleDistStats(ruleDistStats, this.appliedRules);
                if (this.results.isEmpty()) {
                    testgenResults.add(term);
                    if (testgenResults.size() == bound) break block0;
                }
                int i = 0;
                while (this.getTransition(i) != null) {
                    if (visited.add(this.getTransition(i))) {
                        nextQueue.add(this.getTransition(i));
                        nextQueueOfRules.add(this.appliedRules.get(i));
                    }
                    ++i;
                }
            }
            System.out.println("rule distribution stats: " + ruleDistStats);
            ArrayList<ConstrainedTerm> temp = queue;
            queue = TestCaseGenerationUtil.getStatesByRR(nextQueue, nextQueueOfRules, 10);
            nextQueue = temp;
            nextQueue.clear();
            ++this.step;
        }
        while (!queue.isEmpty() && testgenResults.size() != bound) {
            ConstrainedTerm cnstrTerm = (ConstrainedTerm)queue.remove(0);
            ConstrainedTerm grndTerm = this.getFirstReachableGroundTerm(cnstrTerm, 100);
            if (grndTerm == null) continue;
            testgenResults.add(grndTerm);
        }
        this.stopwatch.stop();
        System.err.println("[" + visited.size() + "states, " + this.step + "steps, " + this.stopwatch + "]");
        return testgenResults;
    }

    private void eliminateTermsWithNumOfFreeVarsGT(int maxNumOfFreeVars) {
        ArrayList<ConstrainedTerm> tmpResults = new ArrayList<ConstrainedTerm>(this.results);
        ArrayList<Rule> tmpAppliedRules = new ArrayList<Rule>(this.appliedRules);
        this.results.clear();
        this.appliedRules.clear();
        for (int i = 0; i < tmpResults.size(); ++i) {
            if (TestCaseGenerationUtil.getNumOfFreeVars((ConstrainedTerm)tmpResults.get(i), this.definition.context()) > maxNumOfFreeVars) continue;
            this.results.add((ConstrainedTerm)tmpResults.get(i));
            this.appliedRules.add((Rule)tmpAppliedRules.get(i));
        }
    }

    private void eliminateShadowedRewriteSteps() {
        assert (K.do_testgen);
        HashSet<String> shadowedLabels = new HashSet<String>();
        for (Rule rule : this.appliedRules) {
            String label = rule.getAttribute("testgen-precede");
            if (label == null) continue;
            shadowedLabels.add(label);
        }
        ArrayList<ConstrainedTerm> tmpResults = new ArrayList<ConstrainedTerm>(this.results);
        ArrayList<Rule> tmpAppliedRules = new ArrayList<Rule>(this.appliedRules);
        this.results.clear();
        this.appliedRules.clear();
        for (int i = 0; i < tmpResults.size(); ++i) {
            if (shadowedLabels.contains(((Rule)tmpAppliedRules.get(i)).label())) continue;
            this.results.add((ConstrainedTerm)tmpResults.get(i));
            this.appliedRules.add((Rule)tmpAppliedRules.get(i));
        }
    }

    private void performKastStructureCheck(PluggableKastStructureChecker checker, ConstrainedTerm initTerm) {
        ArrayList<ConstrainedTerm> tmpResults = new ArrayList<ConstrainedTerm>(this.results);
        ArrayList<Rule> tmpAppliedRules = new ArrayList<Rule>(this.appliedRules);
        this.results.clear();
        this.appliedRules.clear();
        for (int i = 0; i < tmpResults.size(); ++i) {
            JavaSymbolicObject pgm = initTerm.term().substituteWithBinders(((ConstrainedTerm)tmpResults.get(i)).constraint().substitution(), initTerm.termContext());
            checker.reset();
            pgm.accept(checker);
            if (!checker.isSuccess()) continue;
            this.results.add((ConstrainedTerm)tmpResults.get(i));
            this.appliedRules.add((Rule)tmpAppliedRules.get(i));
        }
    }

    private ConstrainedTerm getFirstReachableGroundTerm(ConstrainedTerm initTerm, int depth) {
        HashSet<ConstrainedTerm> visited = new HashSet<ConstrainedTerm>();
        List<ConstrainedTerm> queue = new ArrayList<ConstrainedTerm>();
        ArrayList<ConstrainedTerm> nextQueue = new ArrayList<ConstrainedTerm>();
        visited.add(initTerm);
        queue.add(initTerm);
        for (int step = 0; !queue.isEmpty() && step != depth; ++step) {
            for (ConstrainedTerm term : queue) {
                this.computeRewriteStep(term);
                this.performKastStructureCheck(this.phase2PluggableKastChecker, initTerm);
                this.eliminateShadowedRewriteSteps();
                if (this.results.isEmpty()) {
                    return term;
                }
                int i = 0;
                while (this.getTransition(i) != null) {
                    if (visited.add(this.getTransition(i))) {
                        nextQueue.add(this.getTransition(i));
                    }
                    ++i;
                }
            }
            ArrayList<ConstrainedTerm> temp = queue;
            queue = TestCaseGenerationUtil.getMostConcreteStates(nextQueue, 3, this.definition.context());
            nextQueue = temp;
            nextQueue.clear();
        }
        while (!queue.isEmpty()) {
            ConstrainedTerm cnstrTerm = (ConstrainedTerm)queue.remove(0);
            this.computeRewriteStep(cnstrTerm, 1);
            if (!this.results.isEmpty()) continue;
            return cnstrTerm;
        }
        return null;
    }

    public List<ConstrainedTerm> prove(List<Rule> rules, FileSystem fs) {
        this.stopwatch.start();
        ArrayList<ConstrainedTerm> proofResults = new ArrayList<ConstrainedTerm>();
        for (Rule rule : rules) {
            Map<Variable, Variable> freshSubstitution = Variable.getFreshSubstitution(rule.variableSet());
            TermContext context = TermContext.of(this.definition, fs);
            SymbolicConstraint sideConstraint = new SymbolicConstraint(context);
            sideConstraint.addAll(rule.requires());
            ConstrainedTerm initialTerm = new ConstrainedTerm((Term)rule.leftHandSide().substituteWithBinders(freshSubstitution, context), (SymbolicConstraint)rule.lookups().getSymbolicConstraint(context).substituteWithBinders(freshSubstitution, context), (SymbolicConstraint)sideConstraint.substituteWithBinders(freshSubstitution, context), context);
            ConstrainedTerm targetTerm = new ConstrainedTerm((Term)rule.rightHandSide().substituteWithBinders(freshSubstitution, context), context);
            proofResults.addAll(this.proveRule(initialTerm, targetTerm, rules));
        }
        this.stopwatch.stop();
        System.err.println("[" + this.stopwatch + "]");
        return proofResults;
    }

    public List<ConstrainedTerm> proveRule(ConstrainedTerm initialTerm, ConstrainedTerm targetTerm, List<Rule> rules) {
        ArrayList<ConstrainedTerm> proofResults = new ArrayList<ConstrainedTerm>();
        HashSet<ConstrainedTerm> visited = new HashSet<ConstrainedTerm>();
        ArrayList<ConstrainedTerm> queue = new ArrayList<ConstrainedTerm>();
        ArrayList<ConstrainedTerm> nextQueue = new ArrayList<ConstrainedTerm>();
        visited.add(initialTerm);
        queue.add(initialTerm);
        boolean guarded = false;
        while (!queue.isEmpty()) {
            for (ConstrainedTerm term : queue) {
                ConstrainedTerm result;
                if (term.implies(targetTerm)) continue;
                if (guarded && (result = this.applyRule(term, rules)) != null) {
                    if (!visited.add(result)) continue;
                    nextQueue.add(result);
                    continue;
                }
                this.computeRewriteStep(term);
                if (this.results.isEmpty()) {
                    proofResults.add(term);
                } else {
                    HashSet<Variable> ruleVariables = new HashSet<Variable>(initialTerm.variableSet());
                    ruleVariables.addAll(targetTerm.variableSet());
                    Map<Variable, Variable> freshSubstitution = Variable.getFreshSubstitution(ruleVariables);
                }
                int i = 0;
                while (this.getTransition(i) != null) {
                    if (visited.add(this.getTransition(i))) {
                        nextQueue.add(this.getTransition(i));
                    }
                    ++i;
                }
            }
            ArrayList<ConstrainedTerm> temp = queue;
            queue = nextQueue;
            nextQueue = temp;
            nextQueue.clear();
            guarded = true;
        }
        return proofResults;
    }
}

