/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.symbolic;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kframework.backend.java.builtins.BoolToken;
import org.kframework.backend.java.builtins.Int32Token;
import org.kframework.backend.java.builtins.IntToken;
import org.kframework.backend.java.builtins.StringToken;
import org.kframework.backend.java.builtins.UninterpretedToken;
import org.kframework.backend.java.kil.Bottom;
import org.kframework.backend.java.kil.BuiltinList;
import org.kframework.backend.java.kil.BuiltinMap;
import org.kframework.backend.java.kil.BuiltinMgu;
import org.kframework.backend.java.kil.BuiltinSet;
import org.kframework.backend.java.kil.Cell;
import org.kframework.backend.java.kil.CellCollection;
import org.kframework.backend.java.kil.ConcreteCollectionVariable;
import org.kframework.backend.java.kil.Hole;
import org.kframework.backend.java.kil.JavaSymbolicObject;
import org.kframework.backend.java.kil.KCollection;
import org.kframework.backend.java.kil.KItem;
import org.kframework.backend.java.kil.KLabelConstant;
import org.kframework.backend.java.kil.KLabelFreezer;
import org.kframework.backend.java.kil.KLabelInjection;
import org.kframework.backend.java.kil.KList;
import org.kframework.backend.java.kil.KSequence;
import org.kframework.backend.java.kil.Kind;
import org.kframework.backend.java.kil.MapUpdate;
import org.kframework.backend.java.kil.MetaVariable;
import org.kframework.backend.java.kil.SetUpdate;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.TermContext;
import org.kframework.backend.java.kil.Token;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.symbolic.AbstractUnifier;
import org.kframework.backend.java.symbolic.SymbolicConstraint;
import org.kframework.backend.java.symbolic.UnificationFailure;
import org.kframework.kil.loader.Context;

public class SymbolicUnifier
extends AbstractUnifier {
    private SymbolicConstraint fConstraint;
    private boolean isStarNested;
    public final Collection<Collection<SymbolicConstraint>> multiConstraints;
    private final TermContext termContext;

    public SymbolicUnifier(SymbolicConstraint constraint, TermContext context) {
        this.fConstraint = constraint;
        this.termContext = context;
        this.multiConstraints = new ArrayList<Collection<SymbolicConstraint>>();
    }

    public boolean unify(SymbolicConstraint.Equality equality) {
        try {
            this.isStarNested = false;
            this.multiConstraints.clear();
            this.unify(equality.leftHandSide(), equality.rightHandSide());
            return true;
        }
        catch (UnificationFailure e) {
            return false;
        }
    }

    @Override
    public void unify(Term term, Term otherTerm) {
        if (term instanceof Bottom || otherTerm instanceof Bottom) {
            this.fail(term, otherTerm);
        }
        if (term.kind().isComputational()) {
            assert (otherTerm.kind().isComputational());
            term = KCollection.upKind(term, otherTerm.kind());
            otherTerm = KCollection.upKind(otherTerm, term.kind());
        }
        if (term.kind() == Kind.CELL || term.kind() == Kind.CELL_COLLECTION) {
            Context context = this.termContext.definition().context();
            term = CellCollection.upKind(term, otherTerm.kind(), context);
            otherTerm = CellCollection.upKind(otherTerm, term.kind(), context);
        }
        assert (term.kind() == otherTerm.kind()) : "kind mismatch between " + term + " (" + (Object)((Object)term.kind()) + ")" + " and " + otherTerm + " (" + (Object)((Object)otherTerm.kind()) + ")";
        if (term.isSymbolic() || otherTerm.isSymbolic()) {
            if (term instanceof ConcreteCollectionVariable && !((ConcreteCollectionVariable)term).matchConcreteSize(otherTerm)) {
                this.fail(term, otherTerm);
            } else if (otherTerm instanceof ConcreteCollectionVariable && !((ConcreteCollectionVariable)otherTerm).matchConcreteSize(term)) {
                this.fail(term, otherTerm);
            }
            this.fConstraint.add(term, otherTerm);
        } else if (!term.equals(otherTerm)) {
            term.accept(this, otherTerm);
        }
    }

    @Override
    public void unify(BuiltinList builtinList, Term term) {
        assert (!(term instanceof Variable));
        if (!(term instanceof BuiltinList)) {
            this.fail(builtinList, term);
        }
        throw new UnsupportedOperationException("list matching is only supported when one of the lists is a variable.");
    }

    @Override
    public void unify(BuiltinMap builtinMap, Term term) {
        assert (!(term instanceof Variable));
        if (!(term instanceof BuiltinMap)) {
            this.fail(builtinMap, term);
        }
        throw new UnsupportedOperationException("map matching is only supported when one of the maps is a variable.");
    }

    @Override
    public void unify(MapUpdate mapUpdate, Term term) {
        assert (!(term instanceof Variable));
        if (!(term instanceof MapUpdate)) {
            this.fail(mapUpdate, term);
        }
        throw new UnsupportedOperationException("Currently, mapUpdate can only be matched with a variable.");
    }

    @Override
    public void unify(BuiltinSet builtinSet, Term term) {
        assert (!(term instanceof Variable));
        if (!(term instanceof BuiltinSet)) {
            this.fail(builtinSet, term);
        }
        throw new UnsupportedOperationException("set matching is only supported when one of the sets is a variable.");
    }

    @Override
    public void unify(SetUpdate setUpdate, Term term) {
        assert (!(term instanceof Variable));
        if (!(term instanceof SetUpdate)) {
            this.fail(setUpdate, term);
        }
        throw new UnsupportedOperationException("Currently, setUpdate can only be matched with a variable.");
    }

    @Override
    public void unify(BuiltinMgu builtinMgu, Term term) {
        assert (!(term instanceof Variable));
        if (!(term instanceof BuiltinMgu)) {
            this.fail(builtinMgu, term);
        }
        throw new UnsupportedOperationException("Mgu matching is only supported when one of the Mgu's is a variable.");
    }

    @Override
    public void unify(Cell cell, Term term) {
        assert (!(term instanceof Variable));
        if (!(term instanceof Cell)) {
            this.fail(cell, term);
        }
        Cell otherCell = (Cell)term;
        if (!cell.getLabel().equals(otherCell.getLabel())) {
            this.fail(cell, otherCell);
        }
        this.unify((Term)cell.getContent(), (Term)otherCell.getContent());
    }

    @Override
    public void unify(CellCollection cellCollection, Term term) {
        assert (!(term instanceof Variable));
        if (!(term instanceof CellCollection)) {
            this.fail(cellCollection, term);
        }
        CellCollection otherCellCollection = (CellCollection)term;
        if (cellCollection.hasStar() && !otherCellCollection.hasStar()) {
            this.unify(otherCellCollection, (Term)cellCollection);
            return;
        }
        HashSet<String> unifiableCellLabels = new HashSet<String>(cellCollection.labelSet());
        unifiableCellLabels.retainAll(otherCellCollection.labelSet());
        Context context = this.termContext.definition().context();
        if (!cellCollection.hasStar()) {
            for (String label : unifiableCellLabels) {
                assert (cellCollection.get(label).size() == 1 && otherCellCollection.get(label).size() == 1);
                this.unify(cellCollection.get(label).iterator().next(), (Term)otherCellCollection.get(label).iterator().next());
            }
            ArrayListMultimap<String, Cell> cellMap = ArrayListMultimap.create();
            ArrayListMultimap<String, Cell> otherCellMap = ArrayListMultimap.create();
            this.computeDisjointCellMaps(unifiableCellLabels, cellCollection, cellMap, otherCellCollection, otherCellMap);
            if (!this.addCellCollectionConstraint(cellMap, cellCollection.hasFrame() ? cellCollection.frame() : null, otherCellMap, otherCellCollection.hasFrame() ? otherCellCollection.frame() : null)) {
                this.fail(cellCollection, otherCellCollection);
            }
        } else {
            assert (!this.isStarNested) : "nested cells with multiplicity='*' not supported";
            assert (!cellCollection.hasFrame() || !otherCellCollection.hasFrame()) : "Two cell collections both having starred cells in their explicit contents and frames: unable to handle this case at present since it greatly complicates the AC-unification";
            if (cellCollection.hasFrame()) {
                CellCollection tmp = cellCollection;
                cellCollection = otherCellCollection;
                otherCellCollection = tmp;
            }
            ArrayListMultimap<String, Cell> cellMap = ArrayListMultimap.create();
            ArrayListMultimap<String, Cell> otherCellMap = ArrayListMultimap.create();
            this.computeDisjointCellMaps(unifiableCellLabels, cellCollection, cellMap, otherCellCollection, otherCellMap);
            if (!otherCellMap.isEmpty()) {
                this.fail(cellCollection, otherCellCollection);
            }
            Iterator iter = unifiableCellLabels.iterator();
            while (iter.hasNext()) {
                String cellLabel = (String)iter.next();
                if (context.getConfigurationStructureMap().get(cellLabel).isStarOrPlus()) continue;
                assert (cellCollection.get(cellLabel).size() == 1 && otherCellCollection.get(cellLabel).size() == 1);
                this.unify(cellCollection.get(cellLabel).iterator().next(), (Term)otherCellCollection.get(cellLabel).iterator().next());
                iter.remove();
            }
            if (unifiableCellLabels.isEmpty()) {
                this.fail(cellCollection, otherCellCollection);
            } else assert (unifiableCellLabels.size() == 1);
            if (cellCollection.size() < otherCellCollection.size() || cellCollection.size() > otherCellCollection.size() && !otherCellCollection.hasFrame()) {
                this.fail(cellCollection, otherCellCollection);
            }
            String label = (String)unifiableCellLabels.iterator().next();
            Cell[] cells = cellCollection.get(label).toArray(new Cell[1]);
            Cell[] otherCells = otherCellCollection.get(label).toArray(new Cell[1]);
            Variable otherFrame = otherCellCollection.hasFrame() ? otherCellCollection.frame() : null;
            SymbolicConstraint mainConstraint = this.fConstraint;
            this.isStarNested = true;
            ArrayList<SymbolicConstraint> constraints = new ArrayList<SymbolicConstraint>();
            SelectionGenerator generator = new SelectionGenerator(otherCells.length, cells.length);
            do {
                this.fConstraint = new SymbolicConstraint(this.termContext);
                try {
                    for (int i = 0; i < otherCells.length; ++i) {
                        this.unify(cells[generator.selection.get(i)], (Term)otherCells[i]);
                    }
                }
                catch (UnificationFailure e) {
                    continue;
                }
                ArrayListMultimap<String, Cell> cm = ArrayListMultimap.create();
                for (int i = 0; i < cells.length; ++i) {
                    if (generator.selected.contains(i)) continue;
                    cm.put(cells[i].getLabel(), cells[i]);
                }
                cm.putAll(cellMap);
                if (otherFrame != null) {
                    this.fConstraint.add(new CellCollection(cm, context), otherFrame);
                } else if (!cm.isEmpty()) {
                    this.fail(cellCollection, otherCellCollection);
                }
                constraints.add(this.fConstraint);
            } while (generator.generate());
            this.fConstraint = mainConstraint;
            this.isStarNested = false;
            if (constraints.isEmpty()) {
                this.fail(cellCollection, otherCellCollection);
            }
            if (constraints.size() == 1) {
                this.fConstraint.addAll((SymbolicConstraint)constraints.iterator().next());
            } else {
                this.multiConstraints.add(constraints);
            }
        }
    }

    private void computeDisjointCellMaps(Set<String> unifiableCellLabels, CellCollection cellCollection, Multimap<String, Cell> cellMap, CellCollection otherCellCollection, Multimap<String, Cell> otherCellMap) {
        cellMap.clear();
        for (String label : cellCollection.labelSet()) {
            if (unifiableCellLabels.contains(label)) continue;
            cellMap.putAll(label, cellCollection.get(label));
        }
        otherCellMap.clear();
        for (String label : otherCellCollection.labelSet()) {
            if (unifiableCellLabels.contains(label)) continue;
            otherCellMap.putAll(label, otherCellCollection.get(label));
        }
    }

    private boolean addCellCollectionConstraint(Multimap<String, Cell> cellMap, Variable frame, Multimap<String, Cell> otherCellMap, Variable otherFrame) {
        for (String cellLabel : cellMap.keySet()) {
            assert (!otherCellMap.containsKey(cellLabel));
            assert (cellMap.get(cellLabel).size() == 1);
        }
        Context context = this.termContext.definition().context();
        if (frame != null) {
            if (otherFrame != null) {
                if (cellMap.isEmpty() && otherCellMap.isEmpty()) {
                    this.fConstraint.add(frame, otherFrame);
                } else if (cellMap.isEmpty()) {
                    this.fConstraint.add(frame, new CellCollection(otherCellMap, otherFrame, context));
                } else if (otherCellMap.isEmpty()) {
                    this.fConstraint.add(new CellCollection(cellMap, frame, context), otherFrame);
                } else {
                    Variable variable = Variable.getFreshVariable(Kind.CELL_COLLECTION.toString());
                    this.fConstraint.add(frame, new CellCollection(otherCellMap, variable, context));
                    this.fConstraint.add(new CellCollection(cellMap, variable, context), otherFrame);
                }
            } else {
                if (!cellMap.isEmpty()) {
                    return false;
                }
                this.fConstraint.add(frame, new CellCollection(otherCellMap, context));
            }
        } else if (otherFrame != null) {
            if (!otherCellMap.isEmpty()) {
                return false;
            }
            this.fConstraint.add(new CellCollection(cellMap, context), otherFrame);
        } else if (!cellMap.isEmpty() || !otherCellMap.isEmpty()) {
            return false;
        }
        return true;
    }

    @Override
    public void unify(KLabelConstant kLabelConstant, Term term) {
        assert (!(term instanceof Variable));
        if (!kLabelConstant.equals(term)) {
            this.fail(kLabelConstant, term);
        }
    }

    @Override
    public void unify(KLabelFreezer kLabelFreezer, Term term) {
        assert (!(term instanceof Variable));
        if (!(term instanceof KLabelFreezer)) {
            this.fail(kLabelFreezer, term);
        }
        KLabelFreezer otherKLabelFreezer = (KLabelFreezer)term;
        this.unify(kLabelFreezer.term(), otherKLabelFreezer.term());
    }

    @Override
    public void unify(KLabelInjection kLabelInjection, Term term) {
        Kind otherInjectionKind;
        assert (!(term instanceof Variable));
        if (!(term instanceof KLabelInjection)) {
            this.fail(kLabelInjection, term);
        }
        KLabelInjection otherKLabelInjection = (KLabelInjection)term;
        Kind injectionKind = kLabelInjection.term().kind();
        if (!(injectionKind == (otherInjectionKind = otherKLabelInjection.term().kind()) || injectionKind.isComputational() && otherInjectionKind.isComputational() || injectionKind.isStructural() && otherInjectionKind.isStructural())) {
            this.fail(kLabelInjection, otherKLabelInjection);
        }
        this.unify(kLabelInjection.term(), otherKLabelInjection.term());
    }

    @Override
    public void unify(Hole hole, Term term) {
        assert (!(term instanceof Variable));
        if (!hole.equals(term)) {
            this.fail(hole, term);
        }
    }

    @Override
    public void unify(KItem kItem, Term term) {
        KLabelConstant kLabelConstant;
        assert (!(term instanceof Variable));
        if (!(term instanceof KItem)) {
            this.fail(kItem, term);
        }
        KItem patternKItem = (KItem)term;
        Term kLabel = kItem.kLabel();
        Term kList = kItem.kList();
        this.unify(kLabel, patternKItem.kLabel());
        if (kLabel instanceof KLabelConstant && (kLabelConstant = (KLabelConstant)kLabel).isBinder()) {
            assert (kList instanceof KList);
            Multimap<Integer, Integer> binderMap = kLabelConstant.getBinderMap();
            ArrayList<Term> terms = new ArrayList<Term>(((KList)kList).getContents());
            for (Integer boundVarPosition : binderMap.keySet()) {
                Term boundVars = (Term)terms.get(boundVarPosition);
                Set<Variable> variables = boundVars.variableSet();
                Map<Variable, Variable> freshSubstitution = Variable.getFreshSubstitution(variables);
                JavaSymbolicObject freshBoundVars = boundVars.substituteWithBinders(freshSubstitution, this.termContext);
                terms.set(boundVarPosition, (Term)freshBoundVars);
                for (Integer bindingExpPosition : binderMap.get(boundVarPosition)) {
                    Term bindingExp = (Term)terms.get(bindingExpPosition - 1);
                    JavaSymbolicObject freshbindingExp = bindingExp.substituteWithBinders(freshSubstitution, this.termContext);
                    terms.set(bindingExpPosition - 1, (Term)freshbindingExp);
                }
            }
            kList = new KList(ImmutableList.copyOf(terms));
        }
        this.unify(kList, patternKItem.kList());
    }

    @Override
    public void unify(Token token, Term term) {
        assert (!(term instanceof Variable));
        if (!token.equals(term)) {
            this.fail(token, term);
        }
    }

    @Override
    public void unify(UninterpretedToken uninterpretedToken, Term term) {
        assert (!(term instanceof Variable));
        if (!uninterpretedToken.equals(term)) {
            this.fail(uninterpretedToken, term);
        }
    }

    @Override
    public void unify(BoolToken boolToken, Term term) {
        assert (!(term instanceof Variable));
        if (!boolToken.equals(term)) {
            this.fail(boolToken, term);
        }
    }

    @Override
    public void unify(IntToken intToken, Term term) {
        assert (!(term instanceof Variable));
        if (!intToken.equals(term)) {
            this.fail(intToken, term);
        }
    }

    @Override
    public void unify(Int32Token intToken, Term term) {
        assert (!(term instanceof Variable));
        if (!intToken.equals(term)) {
            this.fail(intToken, term);
        }
    }

    @Override
    public void unify(StringToken stringToken, Term term) {
        assert (!(term instanceof Variable));
        if (!stringToken.equals(term)) {
            this.fail(stringToken, term);
        }
    }

    @Override
    public void unify(KList kList, Term term) {
        assert (!(term instanceof Variable));
        if (!(term instanceof KList)) {
            this.fail(kList, term);
        }
        KList otherKList = (KList)term;
        this.matchKCollection(kList, otherKList);
    }

    @Override
    public void unify(KSequence kSequence, Term term) {
        assert (!(term instanceof Variable));
        if (!(term instanceof KSequence)) {
            this.fail(kSequence, term);
        }
        KSequence otherKSequence = (KSequence)term;
        this.matchKCollection(kSequence, otherKSequence);
    }

    private void matchKCollection(KCollection kCollection, KCollection otherKCollection) {
        assert (kCollection.getClass().equals(otherKCollection.getClass()));
        int length = Math.min(kCollection.size(), otherKCollection.size());
        for (int index = 0; index < length; ++index) {
            this.unify(kCollection.get(index), otherKCollection.get(index));
        }
        if (kCollection.size() < otherKCollection.size()) {
            if (!kCollection.hasFrame()) {
                this.fail(kCollection, otherKCollection);
            }
            this.fConstraint.add(kCollection.frame(), otherKCollection.fragment(length));
        } else if (otherKCollection.size() < kCollection.size()) {
            if (!otherKCollection.hasFrame()) {
                this.fail(kCollection, otherKCollection);
            }
            this.fConstraint.add(kCollection.fragment(length), otherKCollection.frame());
        } else if (kCollection.hasFrame() && otherKCollection.hasFrame()) {
            this.fConstraint.add(kCollection.frame(), otherKCollection.frame());
        } else if (kCollection.hasFrame()) {
            this.fConstraint.add(kCollection.frame(), otherKCollection.fragment(length));
        } else if (otherKCollection.hasFrame()) {
            this.fConstraint.add(kCollection.fragment(length), otherKCollection.frame());
        }
    }

    @Override
    public void unify(MetaVariable metaVariable, Term term) {
        if (!metaVariable.equals(term)) {
            this.fail(metaVariable, term);
        }
    }

    @Override
    public void unify(Variable variable, Term term) {
        this.unify((Term)variable, term);
    }

    @Override
    public String getName() {
        return this.getClass().toString();
    }

    private class SelectionGenerator {
        private final int size;
        private final int coSize;
        public List<Integer> selection;
        public Set<Integer> selected;
        private int index;

        public SelectionGenerator(int size, int coSize) {
            assert (size <= coSize);
            this.size = size;
            this.coSize = coSize;
            this.selection = new ArrayList<Integer>();
            this.selected = new HashSet<Integer>();
            for (int i = 0; i < size; ++i) {
                this.selection.add(i);
                this.selected.add(i);
            }
        }

        private void pop() {
            this.index = this.selection.remove(this.selection.size() - 1);
            this.selected.remove(this.index);
            ++this.index;
        }

        private void push() {
            this.selection.add(this.index);
            this.selected.add(this.index);
            this.index = 0;
        }

        public boolean generate() {
            if (this.selection.isEmpty()) {
                return false;
            }
            this.pop();
            while (this.selection.size() != this.size) {
                if (this.index == this.coSize) {
                    if (this.selection.isEmpty()) break;
                    this.pop();
                    continue;
                }
                if (!this.selected.contains(this.index)) {
                    this.push();
                    continue;
                }
                ++this.index;
            }
            return !this.selection.isEmpty();
        }
    }
}

