/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.symbolic;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import org.kframework.backend.java.kil.KCollectionFragment;
import org.kframework.backend.java.kil.KSequence;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.TermContext;
import org.kframework.backend.java.symbolic.LocalTransformer;
import org.kframework.backend.java.symbolic.PrePostTransformer;
import org.kframework.kil.ASTNode;

public class TermSubstitutionTransformer
extends PrePostTransformer {
    private final Map<? extends Term, ? extends Term> substitution;

    public TermSubstitutionTransformer(Map<? extends Term, ? extends Term> substitution, TermContext context) {
        super(context);
        this.substitution = substitution;
        this.preTransformer.addTransformer(new LocalSubstitutionTransformer());
    }

    private class LocalSubstitutionTransformer
    extends LocalTransformer {
        private LocalSubstitutionTransformer() {
        }

        @Override
        public ASTNode transform(Term variable) {
            Term term = (Term)TermSubstitutionTransformer.this.substitution.get(variable);
            if (term != null) {
                if (term instanceof KCollectionFragment) {
                    KCollectionFragment fragment = (KCollectionFragment)term;
                    ImmutableList.Builder builder = new ImmutableList.Builder();
                    builder.addAll((Iterable)fragment);
                    KSequence kSequence = fragment.hasFrame() ? new KSequence((ImmutableList<Term>)builder.build(), fragment.frame()) : new KSequence((ImmutableList<Term>)builder.build());
                    return new PrePostTransformer.DoneTransforming(kSequence);
                }
                return new PrePostTransformer.DoneTransforming(term);
            }
            return variable;
        }
    }
}

