/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.symbolic;

import com.google.common.base.Joiner;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kframework.backend.java.kil.JavaSymbolicObject;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.TermContext;
import org.kframework.backend.java.symbolic.SymbolicConstraint;
import org.kframework.backend.java.symbolic.Transformer;
import org.kframework.backend.java.symbolic.Visitor;
import org.kframework.kil.ASTNode;

public class UninterpretedConstraint
extends JavaSymbolicObject {
    public static final String SEPARATOR = " /\\ ";
    private static final Joiner joiner = Joiner.on(" /\\ ");
    private final List<Equality> equalities = new ArrayList<Equality>();

    public void add(Term leftHandSide, Term rightHandSide) {
        this.equalities.add(new Equality(leftHandSide, rightHandSide));
    }

    public void addAll(UninterpretedConstraint constraint) {
        for (Equality eq : constraint.equalities) {
            this.equalities.add(eq);
        }
    }

    public Collection<Equality> equalities() {
        return Collections.unmodifiableList(this.equalities);
    }

    public SymbolicConstraint getSymbolicConstraint(TermContext context) {
        SymbolicConstraint symbolicConstraint = new SymbolicConstraint(context);
        for (Equality equality : this.equalities) {
            symbolicConstraint.add(equality.leftHandSide, equality.rightHandSide);
        }
        return symbolicConstraint;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UninterpretedConstraint)) {
            return false;
        }
        UninterpretedConstraint constraint = (UninterpretedConstraint)object;
        return this.equalities.equals(constraint.equalities);
    }

    public int hashCode() {
        return this.equalities.hashCode();
    }

    public String toString() {
        return joiner.join(this.equalities);
    }

    @Override
    public ASTNode accept(Transformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public UninterpretedConstraint deepCopy() {
        UninterpretedConstraint result = new UninterpretedConstraint();
        result.equalities.addAll(this.equalities);
        return result;
    }

    public class Equality
    implements Serializable {
        public static final String SEPARATOR = " = ";
        private final Term leftHandSide;
        private final Term rightHandSide;

        private Equality(Term leftHandSide, Term rightHandSide) {
            this.leftHandSide = leftHandSide;
            this.rightHandSide = rightHandSide;
        }

        public Term leftHandSide() {
            return this.leftHandSide;
        }

        public Term rightHandSide() {
            return this.rightHandSide;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Equality)) {
                return false;
            }
            Equality equality = (Equality)object;
            return this.leftHandSide.equals(equality.leftHandSide) && this.rightHandSide.equals(equality.rightHandSide);
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 47 + this.leftHandSide.hashCode();
            hash = hash * 47 + this.rightHandSide.hashCode();
            return hash;
        }

        public String toString() {
            return this.leftHandSide + SEPARATOR + this.rightHandSide;
        }
    }
}

