/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.symbolic;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.kframework.backend.java.kil.JavaSymbolicObject;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.symbolic.LocalVisitor;
import org.kframework.backend.java.symbolic.PrePostVisitor;

public class VariableCollector
extends PrePostVisitor {
    private Set<Variable> variableSet = new HashSet<Variable>();
    private final Stack<Set<Variable>> variableSetStack = new Stack();

    public VariableCollector() {
        this.getPreVisitor().addVisitor(new PreVariableVisitor());
        this.getPostVisitor().addVisitor(new LocalVariableVisitor());
        this.getPostVisitor().addVisitor(new PostVariableVisitor());
    }

    public Set<Variable> getVariableSet() {
        return this.variableSet;
    }

    private class LocalVariableVisitor
    extends LocalVisitor {
        private LocalVariableVisitor() {
        }

        @Override
        public void visit(Variable variable) {
            VariableCollector.this.variableSet.add(variable);
        }
    }

    private class PostVariableVisitor
    extends LocalVisitor {
        private PostVariableVisitor() {
        }

        @Override
        public void visit(JavaSymbolicObject term) {
            term.setVariableSet(VariableCollector.this.variableSet);
            VariableCollector.this.variableSet = (Set)VariableCollector.this.variableSetStack.pop();
            VariableCollector.this.variableSet.addAll(term.getVariableSet());
        }
    }

    private class PreVariableVisitor
    extends LocalVisitor {
        private PreVariableVisitor() {
        }

        @Override
        public void visit(JavaSymbolicObject term) {
            Set<Variable> termVariableSet = term.getVariableSet();
            if (termVariableSet != null) {
                this.proceed = false;
                VariableCollector.this.variableSet.addAll(termVariableSet);
            } else {
                VariableCollector.this.variableSetStack.push(VariableCollector.this.variableSet);
                VariableCollector.this.variableSet = new HashSet();
            }
        }
    }
}

