/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kframework.backend.java.builtins.BoolToken;
import org.kframework.backend.java.builtins.UninterpretedToken;
import org.kframework.backend.java.kil.KItem;
import org.kframework.backend.java.kil.KLabelConstant;
import org.kframework.backend.java.kil.KList;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.Variable;
import org.kframework.backend.java.symbolic.BottomUpVisitor;
import org.kframework.backend.java.symbolic.SymbolicConstraint;

public class GappaPrinter
extends BottomUpVisitor {
    public static String intervalOp = "'_<=Float_<=Float_";
    private static String unaryMinusOp = "'--Float_";
    private static String absOp = "'absFloat";
    public static Map<String, String> comparisonOps = new HashMap<String, String>();
    public static Map<String, String> reverseComparisonOps;
    public static Map<String, String> binaryOps;
    public static Map<String, String> doubleBinaryOps;
    public static Map<String, String> unaryOps;
    private final boolean acceptVariables;
    private Exception exception = null;
    private Set<String> variables = new HashSet<String>();
    StringBuilder result;

    public static GappaPrinter toGappa(Term term) {
        return GappaPrinter.toGappa(term, true);
    }

    public static GappaPrinter toGappaGround(Term term) {
        return GappaPrinter.toGappa(term, false);
    }

    public static GappaPrinter toGappa(Term term, boolean acceptVariables) {
        GappaPrinter printer = new GappaPrinter(acceptVariables);
        term.accept(printer);
        return printer;
    }

    public static GappaPrintResult toGappa(SymbolicConstraint constraint) {
        Set<String> variables = null;
        String result = "";
        boolean first = true;
        Exception error = null;
        for (SymbolicConstraint.Equality equality : constraint.equalities()) {
            KLabelConstant klabelCt;
            String label;
            String newlabel;
            Term klabel;
            Term equalityLHS = equality.leftHandSide();
            Term equalityRHS = equality.rightHandSide();
            if (equalityLHS instanceof BoolToken) {
                Term term = equalityLHS;
                equalityLHS = equalityRHS;
                equalityRHS = term;
            }
            if (equalityRHS.equals(BoolToken.FALSE) && equalityLHS instanceof KItem && (klabel = ((KItem)equalityLHS).kLabel()) instanceof KLabelConstant && ((KItem)equalityLHS).kList() instanceof KList && (newlabel = reverseComparisonOps.get(label = (klabelCt = (KLabelConstant)klabel).label())) != null) {
                klabelCt = KLabelConstant.of(newlabel, klabelCt.termContext());
                equalityLHS = new KItem(klabelCt, (KList)((KItem)equalityLHS).kList(), constraint.termContext());
                equalityRHS = BoolToken.TRUE;
            }
            GappaPrinter gappaLHSPrinter = GappaPrinter.toGappa(equalityLHS);
            if (gappaLHSPrinter.exception != null) {
                error = gappaLHSPrinter.exception;
                continue;
            }
            String gappaLHS = gappaLHSPrinter.getResult();
            if (gappaLHS.isEmpty()) {
                System.out.println("THis is empty: " + equalityLHS.toString());
            }
            variables = gappaLHSPrinter.variables;
            String eqString = "";
            if (!first) {
                eqString = eqString + " /\\ ";
            } else {
                first = false;
            }
            if (equalityRHS.equals(BoolToken.TRUE)) {
                eqString = eqString + "(" + gappaLHS + ")";
            } else if (equalityRHS.equals(BoolToken.FALSE)) {
                eqString = eqString + "not(" + gappaLHS + ")";
            } else {
                GappaPrinter gappaRHSPrinter = GappaPrinter.toGappa(equalityRHS);
                if (gappaRHSPrinter.exception != null) {
                    error = gappaRHSPrinter.exception;
                    continue;
                }
                String gappaRHS = gappaRHSPrinter.getResult();
                variables.addAll(gappaRHSPrinter.variables);
                eqString = eqString + "(" + gappaLHS + " = " + gappaRHS + ")";
            }
            result = result + eqString;
        }
        GappaPrintResult printResult = new GappaPrintResult(result, error, variables);
        return printResult;
    }

    public String getResult() {
        return this.result.toString();
    }

    public GappaPrinter(boolean acceptVariables) {
        this.acceptVariables = acceptVariables;
        this.result = new StringBuilder();
    }

    public void reset() {
        this.result = new StringBuilder();
    }

    @Override
    public void visit(UninterpretedToken uninterpretedToken) {
        this.result.append(uninterpretedToken.value());
    }

    @Override
    public void visit(KItem kItem) {
        if (!kItem.isGround() && !this.acceptVariables) {
            this.exception = new GappaPrinterException(kItem + " is not ground");
            return;
        }
        Term kLabel = kItem.kLabel();
        if (!(kLabel instanceof KLabelConstant)) {
            this.exception = new GappaPrinterException(kLabel + " is not constant");
            return;
        }
        KLabelConstant kLabelConstant = (KLabelConstant)kLabel;
        if (!(kItem.kList() instanceof KList)) {
            this.exception = new GappaPrinterException(kItem.kList() + " is not a concrete klist");
            return;
        }
        KList kList = (KList)kItem.kList();
        String label = kLabelConstant.label();
        String gappaOp = unaryOps.get(label);
        Term term = null;
        if (gappaOp != null) {
            term = kList.get(0);
        } else if ((label.equals("'_-Float_") || label.equals("'_-Float64_")) && (term = kList.get(0)) instanceof UninterpretedToken && ((UninterpretedToken)term).value().equals("0.0")) {
            term = kList.get(1);
            gappaOp = "-";
        }
        if (gappaOp != null) {
            this.result.append(gappaOp + "(");
            term.accept(this);
            this.result.append(")");
            return;
        }
        boolean comparison = false;
        boolean closeParens = false;
        gappaOp = comparisonOps.get(label);
        if (gappaOp != null) {
            comparison = true;
        } else {
            gappaOp = binaryOps.get(label);
        }
        if (doubleBinaryOps.containsKey(label)) {
            gappaOp = doubleBinaryOps.get(label);
            this.result.append("rnd(");
            closeParens = true;
        }
        if (gappaOp != null) {
            Term left = kList.get(0);
            Term right = kList.get(1);
            if (comparison && !(right instanceof UninterpretedToken) && left instanceof UninterpretedToken) {
                Term temp = left;
                left = right;
                right = temp;
                gappaOp = reverseComparisonOps.get(gappaOp);
            }
            if (comparison && !(right instanceof UninterpretedToken)) {
                this.result.append("(");
                this.openParens(left);
                left.accept(this);
                this.closeParens(left);
                this.result.append(" - ");
                this.openParens(right);
                right.accept(this);
                this.closeParens(right);
                this.result.append(")");
                right = UninterpretedToken.of("#Float", "0.0");
            } else {
                this.openParens(left);
                left.accept(this);
                this.closeParens(left);
            }
            this.result.append(gappaOp);
            this.openParens(right);
            right.accept(this);
            this.closeParens(right);
            if (closeParens) {
                this.result.append(")");
            }
            return;
        }
        if (label.equals(intervalOp)) {
            kList.get(1).accept(this);
            this.result.append(" in [");
            kList.get(0).accept(this);
            this.result.append(", ");
            kList.get(2).accept(this);
            this.result.append("]");
            return;
        }
        if (label.equals(unaryMinusOp)) {
            boolean parens;
            this.result.append("-");
            Term minused = kList.get(0);
            boolean bl = parens = !(minused instanceof UninterpretedToken);
            if (parens) {
                this.result.append("(");
            }
            minused.accept(this);
            if (parens) {
                this.result.append(")");
            }
            return;
        }
        if (label.equals(absOp)) {
            this.result.append("|");
            kList.get(0).accept(this);
            this.result.append("|");
            return;
        }
        this.exception = new GappaPrinterException("Operation " + label + " not supported (yet)");
    }

    private void closeParens(Term left) {
        if (left instanceof KItem) {
            this.result.append(")");
        }
    }

    private void openParens(Term left) {
        if (left instanceof KItem) {
            this.result.append("(");
        }
    }

    @Override
    public void visit(Variable variable) {
        if (!variable.sort().equals("Float")) {
            this.exception = new GappaPrinterException("Variable " + variable + " is not Float.");
            return;
        }
        String variableName = variable.name().toLowerCase().replaceAll("_", "o");
        this.variables.add(variableName);
        this.result.append(variableName);
    }

    public Exception getException() {
        return this.exception;
    }

    static {
        comparisonOps.put("'_>=Float_", ">=");
        comparisonOps.put("'_<=Float_", "<=");
        reverseComparisonOps = new HashMap<String, String>();
        reverseComparisonOps.put("'_>=Float_", "'_<=Float_");
        reverseComparisonOps.put("'_<=Float_", "'_>=Float_");
        reverseComparisonOps.put(">=", "<=");
        reverseComparisonOps.put("<=", ">=");
        binaryOps = new HashMap<String, String>();
        comparisonOps.put("'_>=Float_", ">=");
        comparisonOps.put("'_<=Float_", "<=");
        comparisonOps.put("'_>Float_", ">=");
        comparisonOps.put("'_<Float_", "<=");
        binaryOps.put("'_+Float_", "+");
        binaryOps.put("'_-Float_", "-");
        binaryOps.put("'_*Float_", "*");
        binaryOps.put("'_/Float_", "/");
        binaryOps.put("'_/Float_", "/");
        binaryOps.put("'_andBool_", "/\\");
        binaryOps.put("'_orBool_", "\\/");
        binaryOps.put("'_impliesBool_", " -> ");
        doubleBinaryOps = new HashMap<String, String>();
        doubleBinaryOps.put("'_+Float64_", "+");
        doubleBinaryOps.put("'_-Float64_", "-");
        doubleBinaryOps.put("'_*Float64_", "*");
        doubleBinaryOps.put("'_/Float64_", "/");
        doubleBinaryOps.put("'_/Float64_", "/");
        unaryOps = new HashMap<String, String>();
        unaryOps.put("'notBool_", "not");
    }

    public static class GappaPrintResult {
        public String result;
        public Exception exception;
        public Set<String> variables;

        GappaPrintResult(String result, Exception exception, Set<String> variables) {
            this.result = result;
            this.exception = exception;
            this.variables = variables;
        }
    }

    private class GappaPrinterException
    extends Exception {
        public GappaPrinterException(String s) {
            super(s);
        }
    }
}

