/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.kframework.utils.ExternalProcessServer;

public final class GappaServer {
    private static ExternalProcessServer gappaProcess = null;
    private static boolean initializedRnd = false;
    private static Set<String> initializedVariables = null;
    private static Set<String> uninitializedVariables = null;

    private static void init() throws IOException {
        if (gappaProcess == null) {
            initializedVariables = new HashSet<String>();
            uninitializedVariables = new HashSet<String>();
            initializedRnd = false;
            gappaProcess = new ExternalProcessServer("gappa");
            gappaProcess.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean prove(String input) {
        try {
            GappaServer.init();
            String preamble = "";
            if (!initializedRnd) {
                preamble = preamble + "@rnd = float<ieee_64, ne>;\n";
                initializedRnd = true;
            }
            for (String var : uninitializedVariables) {
                preamble = preamble + var + " = rnd(dummy" + var + ");\n";
            }
            initializedVariables.addAll(uninitializedVariables);
            uninitializedVariables.clear();
            gappaProcess.sendString(preamble + input);
            gappaProcess.flushOutput();
            byte[] bytes = gappaProcess.readBytes();
            String output = new String(bytes);
            boolean bl = "OK".equals(output);
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            gappaProcess.destroy();
            gappaProcess = null;
        }
    }

    public static boolean proveTrue(String input) {
        return GappaServer.prove("{ " + input + " }");
    }

    public static boolean proveFalse(String input) {
        return GappaServer.prove("{ not( " + input + ") }");
    }

    public static void addVariable(String variable) {
        try {
            GappaServer.init();
        }
        catch (IOException e) {
            gappaProcess = null;
        }
        if (!initializedVariables.contains(variable)) {
            uninitializedVariables.add(variable);
        }
    }
}

