/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.java.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kframework.backend.java.kil.Definition;
import org.kframework.backend.java.kil.KItem;
import org.kframework.backend.java.kil.KLabelConstant;
import org.kframework.backend.java.kil.KList;
import org.kframework.backend.java.kil.Term;
import org.kframework.backend.java.kil.TermContext;
import org.kframework.backend.java.kil.Variable;
import org.kframework.kil.Attribute;
import org.kframework.kil.Production;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.Sort;

public class GroupProductionsBySort {
    private final Definition definition;
    private final Map<String, List<Production>> prodsOfSort;
    private final Map<Production, KLabelConstant> klabelOfProd;

    public GroupProductionsBySort(Definition definition) {
        assert (definition != null);
        this.definition = definition;
        ImmutableMap.Builder sort2ProdsBuilder = ImmutableMap.builder();
        HashMap prodsBuilders = new HashMap();
        this.klabelOfProd = new HashMap<Production, KLabelConstant>();
        for (KLabelConstant kLabelConstant : definition.kLabels()) {
            for (Production prod : kLabelConstant.productions()) {
                if (prod.containsAttribute(Attribute.BRACKET.getKey())) continue;
                String sort = prod.getSort();
                if (!prodsBuilders.containsKey(sort)) {
                    ImmutableList.Builder b = ImmutableList.builder();
                    prodsBuilders.put(sort, b);
                }
                ((ImmutableList.Builder)prodsBuilders.get(sort)).add(prod);
                this.klabelOfProd.put(prod, kLabelConstant);
            }
        }
        for (Map.Entry entry : prodsBuilders.entrySet()) {
            sort2ProdsBuilder.put(entry.getKey(), ((ImmutableList.Builder)entry.getValue()).build());
        }
        this.prodsOfSort = sort2ProdsBuilder.build();
    }

    public List<KItem> getProductionsAsTerms(String sort, TermContext context) {
        ArrayList<KItem> freshTerms = new ArrayList<KItem>();
        List<Production> prods = this.prodsOfSort.get(sort);
        if (prods != null) {
            for (Production prod : prods) {
                ImmutableList.Builder listBuilder = ImmutableList.builder();
                for (ProductionItem prodItem : prod.getItems()) {
                    if (!(prodItem instanceof Sort)) continue;
                    listBuilder.add(Variable.getFreshVariable(((Sort)prodItem).getName()));
                }
                KItem kitem = new KItem(this.klabelOfProd.get(prod), new KList((ImmutableList<Term>)listBuilder.build()), context);
                freshTerms.add(kitem);
            }
        }
        return freshTerms;
    }
}

