/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.kore;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import org.kframework.backend.BasicBackend;
import org.kframework.backend.kore.KilTransformer;
import org.kframework.compile.checks.CheckConfigurationCells;
import org.kframework.compile.checks.CheckRewrite;
import org.kframework.compile.checks.CheckVariables;
import org.kframework.compile.transformers.AddEmptyLists;
import org.kframework.compile.transformers.AddHeatingConditions;
import org.kframework.compile.transformers.AddK2SMTLib;
import org.kframework.compile.transformers.AddKCell;
import org.kframework.compile.transformers.AddPredicates;
import org.kframework.compile.transformers.AddSemanticEquality;
import org.kframework.compile.transformers.AddStreamCells;
import org.kframework.compile.transformers.AddSupercoolDefinition;
import org.kframework.compile.transformers.AddSuperheatRules;
import org.kframework.compile.transformers.AddSymbolicK;
import org.kframework.compile.transformers.AddTopCellConfig;
import org.kframework.compile.transformers.AddTopCellRules;
import org.kframework.compile.transformers.ContextsToHeating;
import org.kframework.compile.transformers.DesugarStreams;
import org.kframework.compile.transformers.FlattenSyntax;
import org.kframework.compile.transformers.FreezeUserFreezers;
import org.kframework.compile.transformers.FreshCondToFreshVar;
import org.kframework.compile.transformers.RemoveBrackets;
import org.kframework.compile.transformers.RemoveSyntacticCasts;
import org.kframework.compile.transformers.ResolveAnonymousVariables;
import org.kframework.compile.transformers.ResolveBinder;
import org.kframework.compile.transformers.ResolveBlockingInput;
import org.kframework.compile.transformers.ResolveBuiltins;
import org.kframework.compile.transformers.ResolveFreshVarMOS;
import org.kframework.compile.transformers.ResolveFunctions;
import org.kframework.compile.transformers.ResolveListOfK;
import org.kframework.compile.transformers.ResolveSyntaxPredicates;
import org.kframework.compile.transformers.StrictnessToContexts;
import org.kframework.compile.utils.CheckVisitorStep;
import org.kframework.compile.utils.CompilerStepDone;
import org.kframework.compile.utils.CompilerSteps;
import org.kframework.kil.Definition;
import org.kframework.kil.loader.Context;
import org.kframework.main.FirstStep;
import org.kframework.utils.Stopwatch;
import org.kframework.utils.general.GlobalSettings;

public class KoreBackend
extends BasicBackend {
    public KoreBackend(Stopwatch sw, Context context) {
        super(sw, context);
    }

    @Override
    public void run(Definition toKore) throws IOException {
        int i;
        try {
            toKore = this.getCompilationSteps().compile(toKore, this.getDefaultStep());
        }
        catch (CompilerStepDone e) {
            toKore = (Definition)e.getResult();
        }
        KilTransformer trans = new KilTransformer(this.context);
        HashMap<String, PrintWriter> fileTable = new HashMap<String, PrintWriter>();
        for (i = 0; i < toKore.getItems().size(); ++i) {
            if (fileTable.containsKey(toKore.getItems().get(i).getFilename())) continue;
            fileTable.put(toKore.getItems().get(i).getFilename(), new PrintWriter(toKore.getItems().get(i).getFilename().substring(0, toKore.getItems().get(i).getFilename().length() - 2) + ".kore"));
        }
        for (i = 0; i < toKore.getItems().size(); ++i) {
            ((PrintWriter)fileTable.get(toKore.getItems().get(i).getFilename())).println(trans.kilToKore(toKore.getItems().get(i)));
        }
        ArrayList toClosedFiles = new ArrayList(fileTable.values());
        for (int i2 = 0; i2 < toClosedFiles.size(); ++i2) {
            ((PrintWriter)toClosedFiles.get(i2)).close();
        }
    }

    @Override
    public String getDefaultStep() {
        return "LastStep";
    }

    @Override
    public CompilerSteps<Definition> getCompilationSteps() {
        CompilerSteps<Definition> steps = new CompilerSteps<Definition>(this.context);
        steps.add(new FirstStep(this, this.context));
        steps.add(new CheckVisitorStep(new CheckConfigurationCells(this.context), this.context));
        steps.add(new RemoveBrackets(this.context));
        steps.add(new AddEmptyLists(this.context));
        steps.add(new RemoveSyntacticCasts(this.context));
        steps.add(new CheckVisitorStep(new CheckVariables(this.context), this.context));
        steps.add(new CheckVisitorStep(new CheckRewrite(this.context), this.context));
        steps.add(new StrictnessToContexts(this.context));
        steps.add(new FreezeUserFreezers(this.context));
        steps.add(new ContextsToHeating(this.context));
        steps.add(new AddSupercoolDefinition(this.context));
        steps.add(new AddHeatingConditions(this.context));
        steps.add(new AddSuperheatRules(this.context));
        steps.add(new DesugarStreams(this.context, false));
        steps.add(new ResolveFunctions(this.context));
        steps.add(new AddKCell(this.context));
        steps.add(new AddStreamCells(this.context));
        steps.add(new AddSymbolicK(this.context));
        steps.add(new AddSemanticEquality(this.context));
        steps.add(new FreshCondToFreshVar(this.context));
        steps.add(new ResolveFreshVarMOS(this.context));
        steps.add(new AddTopCellConfig(this.context));
        if (GlobalSettings.addTopCell) {
            steps.add(new AddTopCellRules(this.context));
        }
        steps.add(new ResolveBinder(this.context));
        steps.add(new ResolveAnonymousVariables(this.context));
        steps.add(new ResolveBlockingInput(this.context, false));
        steps.add(new AddK2SMTLib(this.context));
        steps.add(new AddPredicates(this.context));
        steps.add(new ResolveSyntaxPredicates(this.context));
        steps.add(new ResolveBuiltins(this.context));
        steps.add(new ResolveListOfK(this.context));
        steps.add(new FlattenSyntax(this.context));
        return steps;
    }
}

