/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.kore;

import java.util.List;
import java.util.Map;
import org.kframework.backend.unparser.Indenter;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Ambiguity;
import org.kframework.kil.Attribute;
import org.kframework.kil.Attributes;
import org.kframework.kil.BackendTerm;
import org.kframework.kil.BagItem;
import org.kframework.kil.BoolBuiltin;
import org.kframework.kil.Bracket;
import org.kframework.kil.Cast;
import org.kframework.kil.Cell;
import org.kframework.kil.Collection;
import org.kframework.kil.Configuration;
import org.kframework.kil.DataStructureSort;
import org.kframework.kil.Definition;
import org.kframework.kil.DefinitionItem;
import org.kframework.kil.Freezer;
import org.kframework.kil.FreezerHole;
import org.kframework.kil.Hole;
import org.kframework.kil.Import;
import org.kframework.kil.IntBuiltin;
import org.kframework.kil.KApp;
import org.kframework.kil.KInjectedLabel;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.KSequence;
import org.kframework.kil.Lexical;
import org.kframework.kil.ListTerminator;
import org.kframework.kil.LiterateDefinitionComment;
import org.kframework.kil.LiterateModuleComment;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.ParseError;
import org.kframework.kil.PriorityBlock;
import org.kframework.kil.PriorityBlockExtended;
import org.kframework.kil.PriorityExtended;
import org.kframework.kil.PriorityExtendedAssoc;
import org.kframework.kil.Production;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.Require;
import org.kframework.kil.Restrictions;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Sentence;
import org.kframework.kil.Sort;
import org.kframework.kil.StringBuiltin;
import org.kframework.kil.StringSentence;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.TermComment;
import org.kframework.kil.TermCons;
import org.kframework.kil.Terminal;
import org.kframework.kil.Token;
import org.kframework.kil.UserList;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicVisitor;
import org.kframework.krun.ColorSetting;
import org.kframework.utils.ColorUtil;

class KoreFilter
extends BasicVisitor {
    protected Indenter indenter = new Indenter();
    private boolean inConfiguration = false;
    private int inTerm = 0;
    private ColorSetting color = ColorSetting.OFF;
    public static int TAB = 4;

    public KoreFilter(Context context) {
        this(false, ColorSetting.OFF, context);
    }

    public KoreFilter(boolean inConfiguration, ColorSetting color, Context context) {
        super(context);
        this.inConfiguration = inConfiguration;
        this.color = color;
        this.inTerm = 0;
        this.indenter.setWidth(500);
    }

    public String getResult() {
        String a = this.indenter.toString();
        this.clear();
        return a;
    }

    public void clear() {
        this.indenter = new Indenter();
        this.indenter.setWidth(500);
    }

    @Override
    public String getName() {
        return "KoreFilter";
    }

    @Override
    public void visit(Ambiguity node) {
        this.indenter.write("amb(");
        for (int i = 0; i < node.getContents().size(); ++i) {
            Term term = node.getContents().get(i);
            if (term == null) continue;
            term.accept(this);
            if (i == node.getContents().size() - 1) continue;
            this.indenter.write(",");
        }
        this.indenter.write(")");
    }

    @Override
    public void visit(Attribute node) {
        this.indenter.write(" " + node.getKey() + "(" + node.getValue() + ")");
    }

    @Override
    public void visit(Attributes node) {
        if (node.isEmpty()) {
            return;
        }
        this.indenter.write("[");
        for (int i = 0; i < node.getContents().size(); ++i) {
            Attribute term = node.getContents().get(i);
            term.accept(this);
            if (i == node.getContents().size() - 1) continue;
            this.indenter.write(", ");
        }
        this.indenter.write("]");
    }

    @Override
    public void visit(BackendTerm node) {
        this.indenter.write(node.getValue());
    }

    @Override
    public void visit(Collection node) {
        if (node.getContents().size() == 0) {
            this.indenter.write("." + node.getSort());
            return;
        }
        for (int i = 0; i < node.getContents().size(); ++i) {
            Term term = node.getContents().get(i);
            term.accept(this);
        }
    }

    @Override
    public void visit(BagItem node) {
        node.getItem().accept(this);
    }

    @Override
    public void visit(Token node) {
        this.indenter.write("#token(\"" + node.tokenSort() + "\", \"" + node.value() + "\")");
    }

    @Override
    public void visit(Bracket node) {
        this.indenter.write("(");
        node.getContent().accept(this);
        this.indenter.write(")");
    }

    @Override
    public void visit(Cast node) {
        this.indenter.write("(");
        node.getContent().accept(this);
        this.indenter.write(" :");
        if (node.isSyntactic()) {
            this.indenter.write(":");
        }
        this.indenter.write(node.getSort());
        this.indenter.write(")");
    }

    @Override
    public void visit(Cell cell) {
        String declaredColor;
        String attributes = "";
        for (Map.Entry<String, String> entry : cell.getCellAttributes().entrySet()) {
            if (entry.getKey() == "ellipses") continue;
            attributes = attributes + " " + entry.getKey() + "=\"" + entry.getValue() + "\"";
        }
        String colorCode = "";
        Cell declaredCell = this.context.cells.get(cell.getLabel());
        if (declaredCell != null && (declaredColor = declaredCell.getCellAttributes().get("color")) != null) {
            colorCode = ColorUtil.RgbToAnsi(ColorUtil.colors.get(declaredColor), this.color);
            this.indenter.write(colorCode);
        }
        this.indenter.write("<" + cell.getLabel() + attributes + ">");
        if (this.inConfiguration && this.inTerm == 0) {
            this.indenter.endLine();
            this.indenter.indent(TAB);
        } else if (cell.hasLeftEllipsis()) {
            this.indenter.write("... ");
        } else {
            this.indenter.write(" ");
        }
        if (!colorCode.equals("")) {
            this.indenter.write("\u001b[0m");
        }
        cell.getContents().accept(this);
        this.indenter.write(colorCode);
        if (this.inConfiguration && this.inTerm == 0) {
            this.indenter.endLine();
            this.indenter.unindent();
        } else if (cell.hasRightEllipsis()) {
            this.indenter.write(" ...");
        } else {
            this.indenter.write(" ");
        }
        this.indenter.write("</" + cell.getLabel() + ">");
        if (!colorCode.equals("")) {
            this.indenter.write("\u001b[0m");
        }
    }

    @Override
    public void visit(Configuration node) {
        this.indenter.write("  configuration ");
        node.getBody().accept(this);
        this.indenter.write(" ");
        this.indenter.endLine();
    }

    @Override
    public void visit(org.kframework.kil.Context node) {
        this.indenter.write("  context ");
        node.getBody().accept(this);
        this.indenter.write(" ");
        node.getAttributes().accept(this);
    }

    public void visit(DataStructureSort node) {
        this.indenter.write(node.name());
    }

    @Override
    public void visit(Definition node) {
        for (DefinitionItem di : node.getItems()) {
            di.accept(this);
        }
    }

    @Override
    public void visit(Freezer node) {
        this.indenter.write("#freezer");
        node.getTerm().accept(this);
        this.indenter.write("(.KList)");
    }

    @Override
    public void visit(FreezerHole hole) {
        this.indenter.write("HOLE(" + hole.getIndex() + ")");
    }

    @Override
    public void visit(Hole hole) {
        this.indenter.write("HOLE");
    }

    @Override
    public void visit(Import node) {
        this.indenter.write("  imports " + node.getName());
        this.indenter.endLine();
    }

    private void visitList(List<? extends ASTNode> nodes, String sep, String empty) {
        if (nodes.size() == 0) {
            this.indenter.write(empty);
        } else {
            for (int i = 0; i < nodes.size(); ++i) {
                nodes.get(i).accept(this);
                if (i == nodes.size() - 1) continue;
                this.indenter.write(sep);
            }
        }
    }

    @Override
    public void visit(KSequence node) {
        this.visitList(node.getContents(), " ~> ", ".K");
    }

    @Override
    public void visit(KList node) {
        this.visitList(node.getContents(), ", ", ".KList");
    }

    @Override
    public void visit(BoolBuiltin node) {
        this.indenter.write(node.value());
    }

    @Override
    public void visit(IntBuiltin node) {
        this.indenter.write(node.value());
    }

    @Override
    public void visit(StringBuiltin node) {
        this.indenter.write(node.value());
    }

    @Override
    public void visit(KApp node) {
        node.getLabel().accept(this);
        this.indenter.write("(");
        node.getChild().accept(this);
        this.indenter.write(")");
    }

    @Override
    public void visit(KLabelConstant node) {
        this.indenter.write(node.getLabel().replaceAll("\\(", "`(").replaceAll("\\)", "`)"));
    }

    @Override
    public void visit(KInjectedLabel kInjectedLabel) {
        Term term = kInjectedLabel.getTerm();
        if (MetaK.isKSort(term.getSort())) {
            this.indenter.write(KInjectedLabel.getInjectedSort(term.getSort()));
            this.indenter.write("2KLabel ");
        } else {
            this.indenter.write("# ");
        }
        term.accept(this);
    }

    @Override
    public void visit(Lexical node) {
        this.indenter.write("Lexical{" + node.getLexicalRule() + "}");
    }

    @Override
    public void visit(ListTerminator node) {
        this.indenter.write(node.toString());
    }

    @Override
    public void visit(LiterateModuleComment node) {
        this.indenter.write(node.toString());
    }

    @Override
    public void visit(LiterateDefinitionComment node) {
        this.indenter.write(node.toString());
    }

    @Override
    public void visit(Module mod) {
        this.indenter.write("module " + mod.getName() + "\n");
        for (ModuleItem i : mod.getItems()) {
            i.accept(this);
        }
        this.indenter.write("\nendmodule");
    }

    @Override
    public void visit(ParseError node) {
        this.indenter.write("Parse error: " + node.getMessage());
    }

    @Override
    public void visit(Production node) {
        for (ProductionItem i : node.getItems()) {
            i.accept(this);
            this.indenter.write(" ");
        }
    }

    @Override
    public void visit(PriorityBlock node) {
        if (node.getAssoc() != null && !node.getAssoc().equals("")) {
            this.indenter.write(node.getAssoc() + ": ");
        }
        for (int i = 0; i < node.getProductions().size(); ++i) {
            Production production = node.getProductions().get(i);
            production.accept(this);
            if (i == node.getProductions().size() - 1) continue;
            this.indenter.write("\n     | ");
        }
    }

    @Override
    public void visit(PriorityBlockExtended node) {
        for (int i = 0; i < node.getProductions().size(); ++i) {
            KLabelConstant production = node.getProductions().get(i);
            production.accept(this);
            if (i == node.getProductions().size() - 1) continue;
            this.indenter.write(" ");
        }
    }

    @Override
    public void visit(PriorityExtended node) {
        this.indenter.write("  syntax priorities");
        for (int i = 0; i < node.getPriorityBlocks().size(); ++i) {
            PriorityBlockExtended production = node.getPriorityBlocks().get(i);
            production.accept(this);
            if (i == node.getPriorityBlocks().size() - 1) continue;
            this.indenter.write("\n     > ");
        }
        this.indenter.endLine();
    }

    @Override
    public void visit(PriorityExtendedAssoc node) {
        this.indenter.write("  syntax " + node.getAssoc());
        for (int i = 0; i < node.getTags().size(); ++i) {
            KLabelConstant production = node.getTags().get(i);
            production.accept(this);
            if (i == node.getTags().size() - 1) continue;
            this.indenter.write(" ");
        }
        this.indenter.endLine();
    }

    @Override
    public void visit(Require node) {
        this.indenter.write(node.toString());
        this.indenter.endLine();
    }

    @Override
    public void visit(Restrictions node) {
        this.indenter.write("  syntax ");
        if (node.getSort() != null) {
            node.getSort().accept(this);
        } else {
            node.getTerminal().accept(this);
        }
        this.indenter.write(" -/- " + node.getPattern());
        this.indenter.endLine();
    }

    @Override
    public void visit(Rewrite rewrite) {
        rewrite.getLeft().accept(this);
        this.indenter.write(" => ");
        rewrite.getRight().accept(this);
        this.indenter.endLine();
    }

    @Override
    public void visit(Rule node) {
        this.indenter.write("  rule ");
        if (node.getLabel() != null && !node.getLabel().equals("")) {
            this.indenter.write("[" + node.getLabel() + "]: ");
        }
        node.getBody().accept(this);
        this.indenter.write(" ");
        if (node.getRequires() != null) {
            this.indenter.write("requires ");
            node.getRequires().accept(this);
            this.indenter.write(" ");
        }
        if (node.getEnsures() != null) {
            this.indenter.write("requires ");
            node.getEnsures().accept(this);
            this.indenter.write(" ");
        }
        node.getAttributes().accept(this);
        this.indenter.endLine();
    }

    @Override
    public void visit(Sentence node) {
        if (node.getLabel() != null && !node.getLabel().equals("")) {
            this.indenter.write("[" + node.getLabel() + "]: ");
        }
        node.getBody().accept(this);
        this.indenter.write(" ");
        if (node.getRequires() != null) {
            this.indenter.write("requires ");
            node.getRequires().accept(this);
            this.indenter.write(" ");
        }
        if (node.getEnsures() != null) {
            this.indenter.write("requires ");
            node.getEnsures().accept(this);
            this.indenter.write(" ");
        }
        node.getAttributes().accept(this);
        this.indenter.endLine();
    }

    @Override
    public void visit(Sort node) {
        this.indenter.write(node.toString());
    }

    @Override
    public void visit(StringSentence node) {
        this.indenter.write(node.toString());
    }

    @Override
    public void visit(Syntax node) {
        this.indenter.write("  syntax ");
        node.getSort().accept(this);
        this.indenter.write(" ::=");
        for (int i = 0; i < node.getPriorityBlocks().size(); ++i) {
            PriorityBlock production = node.getPriorityBlocks().get(i);
            production.accept(this);
            if (i == node.getPriorityBlocks().size() - 1) continue;
            this.indenter.write("\n     > ");
        }
        this.indenter.endLine();
    }

    @Override
    public void visit(TermComment node) {
        this.indenter.write(node.toString());
    }

    @Override
    public void visit(Terminal node) {
        this.indenter.write(node.toString());
    }

    @Override
    public void visit(UserList node) {
        this.indenter.write(node.toString());
    }

    @Override
    public void visit(Variable node) {
        this.indenter.write(node.getName() + ":" + node.getSort());
    }

    @Override
    public void visit(TermCons node) {
        new KApp(new KLabelConstant(node.getProduction().getKLabel()), new KList(node.getContents())).accept(this);
    }
}

