/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.latex;

import org.kframework.backend.latex.LatexFilter;
import org.kframework.kil.Attributes;
import org.kframework.kil.DefinitionItem;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.Rule;
import org.kframework.kil.loader.Context;
import org.kframework.utils.StringUtil;
import org.kframework.utils.general.GlobalSettings;

public class DocumentationFilter
extends LatexFilter {
    public DocumentationFilter(Context context) {
        super(context);
    }

    @Override
    public void visit(Module mod) {
        this.result.append("\\begin{module}{\\moduleName{" + StringUtil.latexify(mod.getName()) + "}}" + this.endl);
        this.result.append("\\section{" + mod.getName() + "}" + this.endl);
        this.result.append("\\label{sec:" + mod.getName() + "}" + this.endl);
        this.result.insert(this.result.indexOf("\\maketitle") + ".maketitle".length(), "\\hyperref[sec:" + mod.getName() + "]{" + mod.getName() + "}\\\\" + this.endl);
        if (this.isVisited(mod)) {
            return;
        }
        for (ModuleItem mi : mod.getItems()) {
            mi.accept(this);
        }
        this.visit((DefinitionItem)mod);
        this.result.append("\\end{module}" + this.endl);
    }

    @Override
    public void visit(Rule rule) {
        Attributes atts = rule.getAttributes();
        boolean process = false;
        for (String tag : GlobalSettings.doctags) {
            if (!atts.containsKey(tag)) continue;
            process = true;
            break;
        }
        if (process) {
            super.visit(rule);
        }
    }
}

