/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.latex;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.kframework.backend.BasicBackend;
import org.kframework.backend.latex.DocumentationFilter;
import org.kframework.backend.latex.LatexFilter;
import org.kframework.kil.Definition;
import org.kframework.kil.loader.Context;
import org.kframework.utils.Stopwatch;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.file.FileUtil;
import org.kframework.utils.file.KPaths;
import org.kframework.utils.general.GlobalSettings;

public class LatexBackend
extends BasicBackend {
    private File latexFile;
    private File latexStyleFile;
    private boolean makeDocument = false;

    public LatexBackend(Stopwatch sw, Context context) {
        super(sw, context);
    }

    public LatexBackend(Stopwatch sw, Context context, boolean doc) {
        super(sw, context);
        this.makeDocument = doc;
    }

    public void compile(Definition javaDef) throws IOException {
        String fileSep = System.getProperty("file.separator");
        String endl = System.getProperty("line.separator");
        LatexFilter lf = this.makeDocument ? new DocumentationFilter(this.context) : new LatexFilter(this.context);
        javaDef.accept(lf);
        String kLatexStyle = KPaths.getKBase(false) + fileSep + "include" + fileSep + "latex" + fileSep + "k.sty";
        this.latexStyleFile = new File(this.context.dotk.getAbsolutePath() + fileSep + "k.sty");
        FileUtils.writeStringToFile(this.latexStyleFile, FileUtil.getFileContent(kLatexStyle));
        String latexified = "\\nonstopmode" + endl + "\\PassOptionsToPackage{pdftex,usenames,dvipsnames,svgnames,x11names}{xcolor}" + endl + "\\PassOptionsToPackage{pdftex}{hyperref}" + endl + "\\documentclass{article}" + endl + "\\usepackage[" + GlobalSettings.style + "]{k}" + endl;
        String preamble = lf.getPreamble().toString();
        latexified = latexified + preamble + "\\begin{document}" + endl + lf.getResult() + "\\end{document}" + endl;
        File canonicalFile = GlobalSettings.mainFile.getCanonicalFile();
        String latexFilePath = this.makeDocument ? this.context.dotk.getAbsolutePath() + fileSep + FilenameUtils.removeExtension(canonicalFile.getName()) + "-doc.tex" : this.context.dotk.getAbsolutePath() + fileSep + FilenameUtils.removeExtension(canonicalFile.getName()) + ".tex";
        this.latexFile = new File(latexFilePath);
        FileUtils.writeStringToFile(this.latexFile, latexified);
        this.sw.printIntermediate("Latex Generation");
    }

    public void copyFiles() throws IOException {
        FileUtils.copyFile(this.latexFile, new File(GlobalSettings.outputDir + File.separator + this.latexFile.getName()));
        FileUtils.copyFile(this.latexStyleFile, new File(GlobalSettings.outputDir + File.separator + this.latexStyleFile.getName()));
    }

    @Override
    public void run(Definition javaDef) {
        try {
            this.compile(javaDef);
            this.copyFiles();
        }
        catch (IOException e) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, e.getMessage(), "", ""));
        }
    }

    public File getLatexFile() {
        return this.latexFile;
    }

    @Override
    public String getDefaultStep() {
        return "FirstStep";
    }

    @Override
    public boolean autoinclude() {
        return !this.makeDocument;
    }
}

