/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.latex;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.kframework.backend.BackendFilter;
import org.kframework.backend.latex.LatexPatternsVisitor;
import org.kframework.kil.Attribute;
import org.kframework.kil.Attributes;
import org.kframework.kil.Bracket;
import org.kframework.kil.Cell;
import org.kframework.kil.Collection;
import org.kframework.kil.Configuration;
import org.kframework.kil.Definition;
import org.kframework.kil.Hole;
import org.kframework.kil.KApp;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.KSequence;
import org.kframework.kil.KSort;
import org.kframework.kil.Lexical;
import org.kframework.kil.ListTerminator;
import org.kframework.kil.LiterateComment;
import org.kframework.kil.LiterateDefinitionComment;
import org.kframework.kil.LiterateModuleComment;
import org.kframework.kil.MapItem;
import org.kframework.kil.Module;
import org.kframework.kil.PriorityExtended;
import org.kframework.kil.PriorityExtendedAssoc;
import org.kframework.kil.Production;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Sort;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.TermComment;
import org.kframework.kil.TermCons;
import org.kframework.kil.Terminal;
import org.kframework.kil.Token;
import org.kframework.kil.UserList;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.utils.StringUtil;

public class LatexFilter
extends BackendFilter {
    protected String endl = System.getProperty("line.separator");
    private StringBuilder preamble = new StringBuilder();
    private boolean firstProduction = false;
    private boolean terminalBefore = false;
    private Map<String, String> colors = new HashMap<String, String>();
    private LatexPatternsVisitor patternsVisitor = new LatexPatternsVisitor(this.context);
    private boolean firstAttribute;
    private boolean hasTitle = false;
    private LinkedList<Boolean> wantParens = new LinkedList();

    public LatexFilter(Context context) {
        super(context);
        this.wantParens.push(Boolean.TRUE);
    }

    public LinkedList<Boolean> getWantParens() {
        return this.wantParens;
    }

    public void setResult(StringBuilder result) {
        this.result = result;
    }

    public StringBuilder getPreamble() {
        return this.preamble;
    }

    @Override
    public void visit(Definition def) {
        def.accept(this.patternsVisitor);
        this.result.append("\\begin{kdefinition}" + this.endl + "\\maketitle" + this.endl);
        super.visit(def);
        this.result.append("\\end{kdefinition}" + this.endl);
        if (!this.hasTitle) {
            this.preamble.append("\\title{" + def.getMainModule() + "}" + this.endl);
            this.hasTitle = true;
        }
    }

    @Override
    public void visit(PriorityExtended node) {
    }

    @Override
    public void visit(PriorityExtendedAssoc node) {
    }

    @Override
    public void visit(Module mod) {
        if (mod.isPredefined()) {
            return;
        }
        this.result.append("\\begin{module}{\\moduleName{" + StringUtil.latexify(mod.getName()) + "}}" + this.endl);
        super.visit(mod);
        this.result.append("\\end{module}" + this.endl);
    }

    @Override
    public void visit(Syntax syn) {
        this.result.append(this.endl + "\\begin{syntaxBlock}");
        this.firstProduction = true;
        super.visit(syn);
        this.result.append(this.endl + "\\end{syntaxBlock}" + this.endl);
    }

    @Override
    public void visit(Sort sort) {
        this.result.append("{\\nonTerminal{\\sort{" + StringUtil.latexify(sort.getName()) + "}}}");
        this.terminalBefore = false;
    }

    @Override
    public void visit(Production p) {
        if (this.firstProduction) {
            this.result.append("\\syntax{");
            this.firstProduction = false;
        } else {
            this.result.append("\\syntaxCont{");
        }
        if (!(p.getItems().get(0) instanceof UserList) && p.containsAttribute("cons") && this.patternsVisitor.getPatterns().containsKey(p.getAttribute("cons"))) {
            String pattern = this.patternsVisitor.getPatterns().get(p.getAttribute("cons"));
            int n = 1;
            LatexFilter termFilter = new LatexFilter(this.context);
            for (ProductionItem pi : p.getItems()) {
                if (pi instanceof Terminal) continue;
                termFilter.setResult(new StringBuilder());
                pi.accept(termFilter);
                pattern = pattern.replace("{#" + n++ + "}", "{" + termFilter.getResult() + "}");
            }
            this.result.append(pattern);
        } else {
            super.visit(p);
        }
        this.result.append("}{");
        p.getAttributes().accept(this);
        this.result.append("}");
    }

    @Override
    public void visit(Terminal pi) {
        String terminal = pi.getTerminal();
        if (terminal.isEmpty()) {
            return;
        }
        if (this.context.isSpecialTerminal(terminal)) {
            this.result.append(StringUtil.latexify(terminal));
        } else {
            if (this.terminalBefore) {
                this.result.append("{}");
            }
            this.result.append("\\terminal{" + StringUtil.latexify(terminal) + "}");
        }
        this.terminalBefore = true;
    }

    @Override
    public void visit(UserList ul) {
        this.result.append("List\\{");
        new Sort(ul.getSort()).accept(this);
        this.result.append(", \\mbox{``}" + StringUtil.latexify(ul.getSeparator()) + "\\mbox{''}\\}");
        this.terminalBefore = false;
    }

    @Override
    public void visit(Lexical t) {
        this.result.append("Token\\{");
        this.result.append(StringUtil.latexify(t.getLexicalRule()) + "\\}");
    }

    @Override
    public void visit(Configuration conf) {
        this.result.append("\\kconfig{");
        super.visit(conf);
        this.result.append("}" + this.endl);
    }

    @Override
    public void visit(Cell c) {
        this.wantParens.push(Boolean.FALSE);
        Cell.Ellipses ellipses = c.getEllipses();
        if (ellipses == Cell.Ellipses.LEFT) {
            this.result.append("\\ksuffix");
        } else if (ellipses == Cell.Ellipses.RIGHT) {
            this.result.append("\\kprefix");
        } else if (ellipses == Cell.Ellipses.BOTH) {
            this.result.append("\\kmiddle");
        } else {
            this.result.append("\\kall");
        }
        if (c.getCellAttributes().containsKey("color")) {
            this.colors.put(c.getLabel(), c.getCellAttributes().get("color"));
        }
        if (this.colors.containsKey(c.getLabel())) {
            this.result.append("[" + this.colors.get(c.getLabel()) + "]");
        }
        this.result.append("{" + StringUtil.latexify(c.getLabel() + StringUtil.emptyIfNull(c.getCellAttributes().get("multiplicity"))) + "}{");
        super.visit(c);
        this.result.append("}" + this.endl);
        this.wantParens.pop();
    }

    @Override
    public void visit(Collection col) {
        boolean parens = this.wantParens.peek();
        boolean hasBR = this.containsBR(col);
        if (col.isEmpty()) {
            this.printEmpty(col.getSort());
            return;
        }
        if (hasBR) {
            if (parens) {
                this.result.append("\\left(");
            }
            this.result.append("\\begin{array}{@{}c@{}}");
        }
        List<Term> contents = col.getContents();
        this.printList(contents, "\\mathrel{}");
        if (hasBR) {
            this.result.append("\\end{array}");
            if (parens) {
                this.result.append("\\right)");
            }
        }
    }

    private boolean containsBR(Collection col) {
        for (Term t : col.getContents()) {
            if (!(t instanceof TermComment)) continue;
            return true;
        }
        return false;
    }

    private void printList(List<Term> contents, String str) {
        boolean first = true;
        for (Term trm : contents) {
            if (first) {
                first = false;
            } else {
                this.result.append(str);
            }
            trm.accept(this);
        }
    }

    @Override
    public void visit(TermComment tc) {
        this.result.append("\\\\");
        super.visit(tc);
    }

    @Override
    public void visit(Variable var) {
        if (var.getName().equals("_")) {
            this.result.append("\\AnyVar");
        } else {
            this.result.append("\\variable");
        }
        if (var.getSort() != null) {
            this.result.append("[" + StringUtil.latexify(var.getSort()) + "]");
        }
        if (!var.getName().equals("_")) {
            this.result.append("{" + this.makeIndices(this.makeGreek(StringUtil.latexify(var.getName()))) + "}");
        }
    }

    private String makeIndices(String str) {
        return str;
    }

    private String makeGreek(String name) {
        return name.replace("Alpha", "{\\alpha}").replace("Beta", "{\\beta}").replace("Gamma", "{\\gamma}").replace("Delta", "{\\delta}").replace("VarEpsilon", "{\\varepsilon}").replace("Epsilon", "{\\epsilon}").replace("Zeta", "{\\zeta}").replace("Eta", "{\\eta}").replace("Theta", "{\\theta}").replace("Kappa", "{\\kappa}").replace("Lambda", "{\\lambda}").replace("Mu", "{\\mu}").replace("Nu", "{\\nu}").replace("Xi", "{\\xi}").replace("Pi", "{\\pi}").replace("VarRho", "{\\varrho}").replace("Rho", "{\\rho}").replace("VarSigma", "{\\varsigma}").replace("Sigma", "{\\sigma}").replace("GAMMA", "{\\Gamma}").replace("DELTA", "{\\Delta}").replace("THETA", "{\\Theta}").replace("LAMBDA", "{\\Lambda}").replace("XI", "{\\Xi}").replace("PI", "{\\Pi}").replace("SIGMA", "{\\Sigma}").replace("UPSILON", "{\\Upsilon}").replace("PHI", "{\\Phi}");
    }

    @Override
    public void visit(ListTerminator e) {
        this.printEmpty(e.getSort());
    }

    private void printEmpty(String sort) {
        this.result.append("\\dotCt{" + sort + "}");
    }

    @Override
    public void visit(Rule rule) {
        this.result.append("\\krule");
        if (!"".equals(rule.getLabel())) {
            this.result.append("[" + rule.getLabel() + "]");
        }
        this.result.append("{" + this.endl);
        rule.getBody().accept(this);
        this.result.append("}{");
        if (rule.getRequires() != null) {
            rule.getRequires().accept(this);
        }
        this.result.append("}{");
        if (rule.getEnsures() != null) {
            rule.getEnsures().accept(this);
        }
        this.result.append("}{");
        rule.getAttributes().accept(this);
        this.result.append("}");
        this.result.append("{");
        this.result.append("}");
        this.result.append(this.endl);
    }

    @Override
    public void visit(org.kframework.kil.Context cxt) {
        this.result.append("\\kcontext");
        this.result.append("{" + this.endl);
        cxt.getBody().accept(this);
        this.result.append("}{");
        if (cxt.getRequires() != null) {
            cxt.getRequires().accept(this);
        }
        this.result.append("}{");
        if (cxt.getEnsures() != null) {
            cxt.getEnsures().accept(this);
        }
        this.result.append("}{");
        cxt.getAttributes().accept(this);
        this.result.append("}" + this.endl);
    }

    @Override
    public void visit(Hole hole) {
        this.result.append("\\khole{}");
    }

    @Override
    public void visit(Rewrite rew) {
        this.wantParens.push(Boolean.TRUE);
        this.result.append("\\reduce{");
        rew.getLeft().accept(this);
        this.result.append("}{");
        rew.getRight().accept(this);
        this.result.append("}");
        this.wantParens.pop();
    }

    @Override
    public void visit(Bracket trm) {
        if (trm.getContent() instanceof Rewrite) {
            super.visit(trm);
        } else {
            String pattern = "\\left({#1}\\right)";
            LatexFilter termFilter = new LatexFilter(this.context);
            termFilter.getWantParens().push(Boolean.FALSE);
            trm.getContent().accept(termFilter);
            pattern = pattern.replace("{#1}", "{" + termFilter.getResult() + "}");
            this.result.append(pattern);
        }
    }

    @Override
    public void visit(TermCons trm) {
        String pattern = this.patternsVisitor.getPatterns().get(trm.getCons());
        if (pattern == null) {
            Production pr = (Production)this.context.conses.get(trm.getCons());
            pr.accept(this.patternsVisitor);
            pattern = this.patternsVisitor.getPatterns().get(trm.getCons());
        }
        int n = 1;
        LatexFilter termFilter = new LatexFilter(this.context);
        for (Term t : trm.getContents()) {
            termFilter.setResult(new StringBuilder());
            t.accept(termFilter);
            pattern = pattern.replace("{#" + n++ + "}", "{" + termFilter.getResult() + "}");
        }
        this.result.append(pattern);
    }

    @Override
    public void visit(KLabelConstant c) {
        this.result.append(StringUtil.latexify(c.getLabel()));
    }

    @Override
    public void visit(Token t) {
        this.result.append("\\constant[" + StringUtil.latexify(t.tokenSort()) + "]{" + StringUtil.latexify(t.value()) + "}");
    }

    @Override
    public void visit(MapItem mi) {
        mi.getKey().accept(this);
        this.result.append("\\mapsto");
        mi.getItem().accept(this);
    }

    @Override
    public void visit(KSequence k) {
        if (k.getContents().isEmpty()) {
            this.printEmpty(KSort.K.name());
        } else {
            this.printList(k.getContents(), "\\kra");
        }
    }

    @Override
    public void visit(KApp app) {
        if (app.getLabel() instanceof Token) {
            this.result.append("\\constant[" + StringUtil.latexify(((Token)app.getLabel()).tokenSort()) + "]{" + StringUtil.latexify(((Token)app.getLabel()).value()) + "}");
        } else {
            app.getLabel().accept(this);
            this.result.append("(");
            app.getChild().accept(this);
            this.result.append(")");
        }
    }

    @Override
    public void visit(KList list) {
        this.printList(list.getContents(), "\\kcomma");
    }

    @Override
    public void visit(LiterateDefinitionComment comment) {
        if (comment.getType() == LiterateComment.LiterateCommentType.LATEX) {
            this.result.append("\\begin{kblock}[text]" + this.endl);
            this.result.append(comment.getValue());
            this.result.append("\\end{kblock}" + this.endl);
        } else if (comment.getType() == LiterateComment.LiterateCommentType.PREAMBLE) {
            this.preamble.append(comment.getValue());
            if (comment.getValue().contains("\\title{")) {
                this.hasTitle = true;
            }
        }
    }

    @Override
    public void visit(LiterateModuleComment comment) {
        if (comment.getType() == LiterateComment.LiterateCommentType.LATEX) {
            this.result.append("\\begin{kblock}[text]" + this.endl);
            this.result.append(comment.getValue());
            this.result.append("\\end{kblock}" + this.endl);
        } else if (comment.getType() == LiterateComment.LiterateCommentType.PREAMBLE) {
            this.preamble.append(comment.getValue());
            if (comment.getValue().contains("\\title{")) {
                this.hasTitle = true;
            }
        }
    }

    @Override
    public void visit(Attribute entry) {
        if ("generated".equals(entry.getLocation())) {
            return;
        }
        if (this.context.isTagGenerated(entry.getKey())) {
            return;
        }
        if (this.context.isParsingTag(entry.getKey())) {
            return;
        }
        if (entry.getKey().equals("latex")) {
            return;
        }
        if (entry.getKey().equals("html")) {
            return;
        }
        if (this.firstAttribute) {
            this.firstAttribute = false;
        } else {
            this.result.append(", ");
        }
        this.result.append("\\kattribute{" + StringUtil.latexify(entry.getKey()) + "}");
        String value = entry.getValue();
        if (!value.isEmpty()) {
            this.result.append("(" + StringUtil.latexify(value) + ")");
        }
    }

    @Override
    public void visit(Attributes attributes) {
        this.firstAttribute = true;
        for (Attribute entry : attributes.getContents()) {
            entry.accept(this);
        }
    }
}

