/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.latex;

import java.util.HashMap;
import java.util.Map;
import org.kframework.kil.Configuration;
import org.kframework.kil.Context;
import org.kframework.kil.Production;
import org.kframework.kil.Rule;
import org.kframework.kil.Sort;
import org.kframework.kil.Terminal;
import org.kframework.kil.UserList;
import org.kframework.kil.visitors.BasicVisitor;
import org.kframework.utils.StringUtil;

public class LatexPatternsVisitor
extends BasicVisitor {
    private Map<String, String> patterns = new HashMap<String, String>();
    private String pattern = "";
    private int nonTerm;
    private boolean prevNonTerm;

    public LatexPatternsVisitor(org.kframework.kil.loader.Context context) {
        super(context);
    }

    public Map<String, String> getPatterns() {
        return this.patterns;
    }

    @Override
    public void visit(Production p) {
        if (!p.containsAttribute("cons")) {
            return;
        }
        if (p.containsAttribute("latex")) {
            this.pattern = p.getAttribute("latex");
        } else {
            this.pattern = "";
            this.nonTerm = 1;
            this.prevNonTerm = false;
            super.visit(p);
        }
        this.patterns.put(p.getAttribute("cons"), this.pattern);
    }

    @Override
    public void visit(Sort sort) {
        if (this.prevNonTerm) {
            this.pattern = this.pattern + "\\mathrel{}";
        }
        this.pattern = this.pattern + "{#" + this.nonTerm++ + "}";
        this.prevNonTerm = true;
    }

    @Override
    public void visit(UserList sort) {
        this.pattern = this.pattern + "{#" + this.nonTerm++ + "}";
        this.pattern = this.pattern + "\\mathpunct{\\terminalNoSpace{" + StringUtil.latexify(sort.getSeparator()) + "}}";
        this.pattern = this.pattern + "{#" + this.nonTerm++ + "}";
    }

    @Override
    public void visit(Terminal pi) {
        String terminal = pi.getTerminal();
        if (terminal.isEmpty()) {
            return;
        }
        if (this.context.isSpecialTerminal(terminal)) {
            this.pattern = this.pattern + StringUtil.latexify(terminal);
        } else {
            if (!this.prevNonTerm) {
                this.pattern = this.pattern + "{}";
            }
            this.pattern = this.pattern + "\\terminal{" + StringUtil.latexify(terminal) + "}";
        }
        this.prevNonTerm = false;
    }

    @Override
    public void visit(Rule node) {
    }

    @Override
    public void visit(Configuration node) {
    }

    @Override
    public void visit(Context node) {
    }
}

