/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.latex;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.kframework.backend.BasicBackend;
import org.kframework.backend.latex.LatexBackend;
import org.kframework.kil.Definition;
import org.kframework.kil.loader.Context;
import org.kframework.utils.Stopwatch;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class PdfBackend
extends BasicBackend {
    public PdfBackend(Stopwatch sw, Context context) {
        super(sw, context);
    }

    private File generatePdf(File latexFile) {
        try {
            String pdfLatex = "pdflatex";
            String argument = latexFile.getCanonicalPath();
            ProcessBuilder pb = new ProcessBuilder(pdfLatex, argument, "-interaction", "nonstopmode");
            pb.redirectErrorStream(true);
            pb.directory(latexFile.getParentFile());
            Process process = pb.start();
            IOUtils.toString(process.getInputStream());
            process.waitFor();
            if (process.exitValue() != 0) {
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "pdflatex returned a non-zero exit code.  The pdf might be generated, but with bugs. please inspect the latex logs in the .k directory.", "", ""));
            }
            this.sw.printIntermediate("Latex2PDF");
            return new File(FilenameUtils.removeExtension(latexFile.getCanonicalPath()) + ".pdf");
        }
        catch (IOException | InterruptedException e) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Cannot generate the pdf version of the definition. It seems that `pdflatex` is not installed or is not in your path. To generate the pdf version you can run `pdflatex` having as argument the latex version of the definition.", "", ""));
            return null;
        }
    }

    @Override
    public void run(Definition definition) throws IOException {
        LatexBackend latexBackend = new LatexBackend(this.sw, this.context);
        latexBackend.compile(definition);
        File latexFile = latexBackend.getLatexFile();
        File pdfFile = this.generatePdf(latexFile);
        FileUtils.copyFile(pdfFile, new File(GlobalSettings.outputDir + File.separator + FilenameUtils.removeExtension(new File(definition.getMainFile()).getName()) + ".pdf"));
    }

    @Override
    public String getDefaultStep() {
        return "FirstStep";
    }
}

