/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.maude;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.kframework.backend.BasicBackend;
import org.kframework.backend.maude.MaudeFilter;
import org.kframework.compile.sharing.FreshVariableNormalizer;
import org.kframework.kil.Definition;
import org.kframework.kil.Production;
import org.kframework.kil.UserList;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.utils.Stopwatch;
import org.kframework.utils.StringBuilderUtil;
import org.kframework.utils.file.FileUtil;

public class MaudeBackend
extends BasicBackend {
    public MaudeBackend(Stopwatch sw, Context context) {
        super(sw, context);
    }

    @Override
    public void run(Definition definition) throws IOException {
        try {
            definition = (Definition)definition.accept(new FreshVariableNormalizer(this.context));
        }
        catch (TransformerException e) {
            // empty catch block
        }
        MaudeFilter maudeFilter = new MaudeFilter(this.context);
        definition.accept(maudeFilter);
        String mainModule = definition.getMainModule();
        StringBuilder maudified = maudeFilter.getResult();
        StringBuilderUtil.replaceFirst(maudified, mainModule, mainModule + "-BASE");
        FileUtil.save(this.context.dotk.getAbsolutePath() + "/base.maude", maudified);
        this.sw.printIntermediate("Generating Maude file");
        StringBuilder consTable = this.getLabelTable(definition);
        FileUtil.save(this.context.dotk.getAbsolutePath() + "/consTable.txt", consTable);
    }

    private StringBuilder getLabelTable(Definition def) {
        StringBuilder b = new StringBuilder();
        for (Map.Entry e : this.context.conses.entrySet()) {
            String cons = (String)e.getKey();
            Production p = (Production)e.getValue();
            b.append(StringEscapeUtils.escapeJava(cons));
            b.append('\t');
            if (p.containsAttribute("prefer")) {
                b.append('*');
            } else {
                b.append(' ');
            }
            if (p.isListDecl()) {
                b.append('L');
                b.append(StringEscapeUtils.escapeJava(p.getKLabel()));
                b.append('\t');
                b.append(StringEscapeUtils.escapeJava(((UserList)p.getItems().get(0)).getSeparator()));
            } else if (p.containsAttribute("bracket")) {
                b.append('B');
            } else {
                b.append('P');
                b.append(StringEscapeUtils.escapeJava(p.getKLabel()));
            }
            b.append('\n');
        }
        return b;
    }

    @Override
    public String getDefaultStep() {
        return "LastStep";
    }
}

