/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.maude;

import java.util.Properties;
import org.kframework.backend.BackendFilter;
import org.kframework.backend.maude.MaudeFilter;
import org.kframework.kil.Configuration;
import org.kframework.kil.Context;
import org.kframework.kil.Production;
import org.kframework.kil.Rule;
import org.kframework.kil.Sort;
import org.kframework.kil.Variable;
import org.kframework.utils.StringUtil;

public class MaudeBuiltinsFilter
extends BackendFilter {
    private String left;
    private String right;
    private boolean first;
    private final Properties maudeHooksMap;
    private final Properties specialMaudeHooks;

    public MaudeBuiltinsFilter(Properties maudeHooksMap, Properties specialMaudeHooks, org.kframework.kil.loader.Context context) {
        super(context);
        this.maudeHooksMap = maudeHooksMap;
        this.specialMaudeHooks = specialMaudeHooks;
    }

    @Override
    public void visit(Configuration node) {
    }

    @Override
    public void visit(Context node) {
    }

    @Override
    public void visit(Rule node) {
    }

    @Override
    public void visit(Production node) {
        if (!node.containsAttribute("hook")) {
            return;
        }
        String hook = node.getAttribute("hook");
        if (!this.maudeHooksMap.containsKey(hook)) {
            return;
        }
        if (this.specialMaudeHooks.containsKey(hook)) {
            this.result.append(this.specialMaudeHooks.getProperty(hook));
            this.result.append("\n");
            return;
        }
        this.result.append(" eq ");
        this.left = StringUtil.escapeMaude(node.getKLabel());
        this.left = this.left + "(";
        this.right = this.getHookLabel((String)this.maudeHooksMap.get(hook));
        if (node.getArity() > 0) {
            this.right = this.right + "(";
            this.first = true;
            super.visit(node);
            this.right = this.right + ")";
        } else {
            this.left = this.left + ".KList";
        }
        this.left = this.left + ")";
        this.result.append(this.left);
        this.result.append(" = _`(_`)(");
        if (this.context.getDataStructureSorts().containsKey(node.getSort())) {
            this.result.append(this.context.dataStructureSortOf(node.getSort()).type() + "2KLabel_(");
        } else {
            this.result.append("#_(");
        }
        this.result.append(this.right);
        this.result.append("), .KList)");
        this.result.append(" .\n");
    }

    @Override
    public void visit(Sort node) {
        if (!this.first) {
            this.left = this.left + ",, ";
            this.right = this.right + ", ";
        } else {
            this.first = false;
        }
        Variable var = this.context.getDataStructureSorts().containsKey(node.getName()) || node.getName().equals("K") || node.getName().equals("KItem") ? Variable.getFreshVar(node.getName()) : Variable.getFreshVar("#" + node.getName());
        MaudeFilter filter = new MaudeFilter(this.context);
        filter.visit(var);
        this.left = this.left + filter.getResult();
        if (this.context.getDataStructureSorts().containsKey(node.getName())) {
            var.setSort(this.context.dataStructureSortOf(node.getName()).type());
        }
        this.right = this.right + var.toString();
    }

    private String getHookLabel(String hook) {
        return hook.split(":")[1];
    }
}

