/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.maude;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.kframework.backend.BackendFilter;
import org.kframework.compile.transformers.AddPredicates;
import org.kframework.compile.utils.ConfigurationStructure;
import org.kframework.compile.utils.ConfigurationStructureMap;
import org.kframework.compile.utils.MaudeHelper;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.Ambiguity;
import org.kframework.kil.Attribute;
import org.kframework.kil.Attributes;
import org.kframework.kil.BackendTerm;
import org.kframework.kil.Bag;
import org.kframework.kil.BagItem;
import org.kframework.kil.Bracket;
import org.kframework.kil.Cast;
import org.kframework.kil.Cell;
import org.kframework.kil.Collection;
import org.kframework.kil.CollectionBuiltin;
import org.kframework.kil.CollectionItem;
import org.kframework.kil.Configuration;
import org.kframework.kil.DataStructureBuiltin;
import org.kframework.kil.DataStructureSort;
import org.kframework.kil.Definition;
import org.kframework.kil.DefinitionItem;
import org.kframework.kil.Freezer;
import org.kframework.kil.FreezerHole;
import org.kframework.kil.FreezerLabel;
import org.kframework.kil.GenericToken;
import org.kframework.kil.Hole;
import org.kframework.kil.Import;
import org.kframework.kil.KApp;
import org.kframework.kil.KInjectedLabel;
import org.kframework.kil.KLabel;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.KSequence;
import org.kframework.kil.KSort;
import org.kframework.kil.ListBuiltin;
import org.kframework.kil.ListItem;
import org.kframework.kil.ListTerminator;
import org.kframework.kil.LiterateDefinitionComment;
import org.kframework.kil.LiterateModuleComment;
import org.kframework.kil.Map;
import org.kframework.kil.MapBuiltin;
import org.kframework.kil.MapItem;
import org.kframework.kil.MapUpdate;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.PriorityBlock;
import org.kframework.kil.PriorityExtended;
import org.kframework.kil.PriorityExtendedAssoc;
import org.kframework.kil.Production;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.Require;
import org.kframework.kil.Rewrite;
import org.kframework.kil.Rule;
import org.kframework.kil.Sentence;
import org.kframework.kil.Set;
import org.kframework.kil.SetItem;
import org.kframework.kil.Sort;
import org.kframework.kil.StringBuiltin;
import org.kframework.kil.StringSentence;
import org.kframework.kil.Syntax;
import org.kframework.kil.Term;
import org.kframework.kil.TermComment;
import org.kframework.kil.TermCons;
import org.kframework.kil.Terminal;
import org.kframework.kil.Token;
import org.kframework.kil.UserList;
import org.kframework.kil.Variable;
import org.kframework.kil.loader.Context;
import org.kframework.utils.StringUtil;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class MaudeFilter
extends BackendFilter {
    private boolean firstAttribute;
    ConfigurationStructureMap cfgStr;
    private java.util.Set<String> unusedTransitions;
    private java.util.Set<String> maudeBuiltinTokenSorts = ImmutableSet.of("#Float", "#LtlFormula");
    private static java.util.Map<KSort, String> maudeCollectionConstructors = new HashMap<KSort, String>();

    public MaudeFilter(Context context) {
        super(context);
        this.unusedTransitions = new HashSet<String>(GlobalSettings.transition.size());
        this.cfgStr = context.getConfigurationStructureMap();
    }

    @Override
    public void visit(Definition definition) {
        this.unusedTransitions.addAll(GlobalSettings.transition);
        if (this.unusedTransitions.size() == 1 && this.unusedTransitions.contains("transition")) {
            this.unusedTransitions.clear();
        }
        for (DefinitionItem di : definition.getItems()) {
            di.accept(this);
            this.result.append(" \n");
        }
        if (!this.unusedTransitions.isEmpty()) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.WARNING, KException.KExceptionGroup.COMPILER, "These specified transition tags were not used (mispelled?):\n\t\t" + this.unusedTransitions, "command line arguments", "--transition"));
        }
    }

    @Override
    public void visit(Import imp) {
        this.result.append("including ");
        String name = imp.getName();
        String iface = "-INTERFACE";
        if (name.startsWith("#") && name.endsWith("-INTERFACE")) {
            name = name.substring(0, name.length() - "-INTERFACE".length());
        }
        this.result.append(name);
        this.result.append(" .");
    }

    @Override
    public void visit(Module mod) {
        this.result.append("mod ");
        this.result.append(mod.getName());
        this.result.append(" is\n");
        this.result.append("op #token : #String #String -> KLabel .\n");
        for (ModuleItem moduleItem : mod.getItems()) {
            moduleItem.accept(this);
            this.result.append("\n");
        }
        for (String string : this.context.getTokenSorts()) {
            String tokenKItem = "_`(_`)(#token(\"" + string + "\", V:" + "#String" + "), .KList)";
            String sortKItem = "_`(_`)(#_(\"" + string + "\")" + ", .KList)";
            String valueKItem = "_`(_`)(#_(V:#String), .KList)";
            this.result.append("eq _`(_`)(" + AddPredicates.syntaxPredicate(string) + ", " + tokenKItem + ") = _`(_`)(#_(true), .KList) .\n");
            this.result.append("eq _`(_`)(#parseToken, _`,`,_(" + sortKItem + ", " + valueKItem + ")) = " + tokenKItem + " .\n");
            this.result.append("eq _`(_`)(#tokenToString, " + tokenKItem + ") = " + valueKItem + " .\n");
        }
        for (Map.Entry entry : this.context.getDataStructureSorts().entrySet()) {
            String lhs = "_`(_`)(" + AddPredicates.syntaxPredicate((String)entry.getKey()) + ", " + "_`(_`)(" + ((DataStructureSort)entry.getValue()).type() + "2KLabel_(V:" + ((DataStructureSort)entry.getValue()).type() + "), .KList))";
            this.result.append("eq " + lhs + "  = _`(_`)(#_(true), .KList) .\n");
        }
        this.result.append("\nendm");
    }

    @Override
    public void visit(PriorityExtended syn) {
    }

    @Override
    public void visit(Syntax syn) {
        for (PriorityBlock pb : syn.getPriorityBlocks()) {
            for (Production p : pb.getProductions()) {
                String msg;
                if (p.getItems().size() == 1 && p.getItems().get(0) instanceof Sort) {
                    ProductionItem item = p.getItems().get(0);
                    if (!(item instanceof Sort)) continue;
                    if (!MaudeHelper.declaredSorts.contains(p.getItems().get(0).toString()) && !MaudeHelper.basicSorts.contains(p.getItems().get(0).toString())) {
                        this.result.append("sort ");
                        this.result.append(p.getItems().get(0));
                        this.result.append(" .\n");
                        MaudeHelper.declaredSorts.add(p.getItems().get(0).toString());
                    }
                    this.result.append("subsort ");
                    this.result.append(p.getItems().get(0));
                    this.result.append(" < ");
                    this.result.append(syn.getSort());
                    this.result.append(" .\n");
                    continue;
                }
                if (p.getItems().size() == 1 && p.getItems().get(0) instanceof Terminal) {
                    String operation = p.toString();
                    if (operation.startsWith("\"")) {
                        operation = operation.substring(1, operation.length() - 2);
                    }
                    if (operation.equals("") && !p.containsAttribute("onlyLabel")) {
                        msg = "Cannot declare empty terminals in the definition.\n";
                        msg = msg + "            Use attribute 'onlyLabel' paired with 'klabel(...)' to limit the use to programs.";
                        GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, p.getFilename(), p.getLocation()));
                    }
                    if (MaudeHelper.constantSorts.contains(syn.getSort()) && syn.getSort().toString().equals("KLabel") && syn.getSort().toString().equals("CellLabel")) continue;
                    this.result.append("op ");
                    this.result.append(StringUtil.escapeMaude(operation));
                    this.result.append(" : -> ");
                    this.result.append(syn.getSort());
                    if (!this.isEmptyAttributes(p.getAttributes())) {
                        this.result.append(" [metadata \"");
                        p.getAttributes().accept(this);
                        this.result.append("\"]");
                    }
                    this.result.append(" .\n");
                    continue;
                }
                if (p.getItems().size() == 1 && p.getItems().get(0) instanceof UserList) {
                    UserList list = (UserList)p.getItems().get(0);
                    if (MaudeHelper.separators.contains(list.getSeparator())) continue;
                    this.result.append("op _");
                    this.result.append(StringUtil.escapeMaude(list.getSeparator()));
                    this.result.append("_ : K K -> K [prec 120 metadata \"");
                    p.getAttributes().accept(this);
                    this.result.append(" hybrid=()");
                    this.result.append("\"] .\n");
                    this.result.append("op .List`{\"");
                    this.result.append(list.getSeparator());
                    this.result.append("\"`} : -> K .\n");
                    MaudeHelper.separators.add(list.getSeparator());
                    continue;
                }
                String maudelabel = p.getLabel();
                if (maudelabel.equals("")) {
                    msg = "Empty production. Please use `prefixlabel` attribute.";
                    GlobalSettings.kem.register(new KException(KException.ExceptionType.WARNING, KException.KExceptionGroup.COMPILER, msg, p.getFilename(), p.getLocation()));
                    continue;
                }
                if (p.containsAttribute("bracket")) continue;
                this.result.append("op ");
                this.result.append(StringUtil.escapeMaude(maudelabel));
                this.result.append(" : ");
                p.accept(this);
                this.result.append(" -> ");
                this.result.append(syn.getSort());
                this.result.append(" [metadata \"");
                p.getAttributes().accept(this);
                this.result.append("\"]");
                this.result.append(" .\n");
            }
        }
    }

    @Override
    public void visit(PriorityExtendedAssoc priorityBlock) {
    }

    @Override
    public void visit(PriorityBlock priorityBlock) {
        this.result.append("production");
    }

    @Override
    public void visit(Production prod) {
        boolean first = true;
        for (ProductionItem pi : prod.getItems()) {
            if (!first) {
                this.result.append(" ");
            } else {
                first = false;
            }
            if (!(pi instanceof Sort)) continue;
            pi.accept(this);
        }
    }

    @Override
    public void visit(Sort sort) {
        this.result.append(sort.getName());
    }

    @Override
    public void visit(Terminal terminal) {
    }

    @Override
    public void visit(StringSentence stringSentence) {
        this.result.append("StringSentence should not be maudifiable");
    }

    @Override
    public void visit(UserList userList) {
    }

    @Override
    public void visit(KList listOfK) {
        this.visit((Collection)listOfK);
    }

    @Override
    public void visit(Attributes attributes) {
        this.firstAttribute = true;
        for (Attribute entry : attributes.getContents()) {
            if (entry.getKey().equals("klabel")) continue;
            entry.accept(this);
        }
    }

    private boolean isEmptyAttributes(Attributes attributes) {
        for (Attribute entry : attributes.getContents()) {
            if (entry.getKey().equals("klabel") || entry.getKey().equals("location") || entry.getKey().equals("filename") || this.isEmptyAttribute(entry)) continue;
            return false;
        }
        return true;
    }

    private boolean isEmptyAttribute(Attribute entry) {
        LinkedList<String> reject = new LinkedList<String>();
        reject.add("cons");
        reject.add("kgeneratedlabel");
        reject.add("latex");
        reject.add("prefixlabel");
        return reject.contains(entry.getKey());
    }

    @Override
    public void visit(Attribute attribute) {
        LinkedList<String> reject = new LinkedList<String>();
        reject.add("cons");
        reject.add("kgeneratedlabel");
        reject.add("latex");
        reject.add("prefixlabel");
        if (!reject.contains(attribute.getKey())) {
            if (!this.firstAttribute) {
                this.result.append(" ");
            } else {
                this.firstAttribute = false;
            }
            this.result.append(attribute.getKey());
            this.result.append("=(");
            this.result.append(attribute.getValue().replaceAll("[()]", ""));
            this.result.append(")");
        }
    }

    @Override
    public void visit(Configuration configuration) {
        if (this.cfgStr == null) {
            return;
        }
        for (ConfigurationStructure cellStr : this.cfgStr.values()) {
            String id = cellStr.id;
            if (id == "___CONTEXT_ABSTRACTION_TOP_CELL___") continue;
            String cellSort = MetaK.cellSort(id);
            String cellFragment = MetaK.cellFragment(id);
            String cellUnit = MetaK.cellUnit(id);
            if (!cellStr.id.equals("k")) {
                this.result.append("  sort " + cellSort + " .\n");
            }
            this.result.append("  sort " + cellFragment + " .\n");
            this.result.append("  subsort " + cellSort + " < " + cellFragment + " .\n");
            this.result.append("  op " + cellUnit + " : -> " + cellFragment + " .\n");
            if (cellStr.isStarOrPlus()) {
                this.result.append(" op __ : " + cellFragment + " " + cellFragment + " -> " + cellFragment + " " + "[assoc comm id: " + cellUnit + "] .\n");
            }
            this.result.append("  op " + cellFragment + "2KLabel_ : " + cellFragment + " -> KLabel .\n");
            this.result.append("  op " + cellSort + "2KLabel_ : " + cellFragment + " -> KLabel .\n");
            String placeHolders = "";
            String sorts = "";
            String fragSorts = "";
            String format = "";
            Cell cell = cellStr.cell;
            if (cellStr.sons.isEmpty()) {
                if (cellStr.id.equals("k")) continue;
                placeHolders = "_";
                format = "ni ";
                sorts = KSort.getKSort(cell.getContents().getSort()).mainSort().toString();
                this.declareCell(id, placeHolders, sorts, cellSort, format);
                continue;
            }
            List<Term> cfgCells = cell.getCellTerms();
            for (Term cCell : cfgCells) {
                if (cCell instanceof TermComment) continue;
                placeHolders = placeHolders + "_";
                format = format + "ni ";
                String cellName = ((Cell)cCell).getId();
                switch (((Cell)cCell).getMultiplicity()) {
                    case ONE: {
                        sorts = sorts + MetaK.cellSort(cellName);
                        break;
                    }
                    default: {
                        sorts = sorts + MetaK.cellFragment(cellName);
                    }
                }
                fragSorts = fragSorts + MetaK.cellFragment(cellName) + " ";
                sorts = sorts + " ";
            }
            this.declareCell(id, placeHolders, sorts, cellSort, format);
            this.declareCell(id + "-fragment", placeHolders, fragSorts, cellFragment, format);
        }
    }

    private void declareCell(String id, String placeHolders, String sorts, String resultSort, String format) {
        this.result.append("  op <" + id + ">" + placeHolders + "</" + id + ">" + " : " + sorts + " -> " + resultSort + "[format(b o++" + format + "--nib o)]" + "." + "\n");
    }

    @Override
    public void visit(Cell cell) {
        String id = cell.getId();
        this.result.append("<_>_</_>(" + id + ", ");
        if (cell.getContents() != null) {
            cell.getContents().accept(this);
        } else {
            this.result.append("null");
        }
        this.result.append(", " + id + ")");
    }

    @Override
    public void visit(Variable variable) {
        if (MetaK.isBuiltinSort(variable.getSort()) || this.context.getDataStructureSorts().containsKey(variable.getSort())) {
            this.result.append("_`(_`)(");
            if (this.context.getDataStructureSorts().containsKey(variable.getSort())) {
                String sort = this.context.dataStructureSortOf(variable.getSort()).type();
                sort = sort.equals("K") ? "KList" : sort;
                this.result.append(sort + "2KLabel_(");
            } else {
                this.result.append("#_(");
            }
        }
        if (variable.getName().equals("_")) {
            this.result.append("?");
        } else {
            this.result.append(variable.getName());
        }
        this.result.append(":");
        if (this.context.getDataStructureSorts().containsKey(variable.getSort())) {
            this.result.append(this.context.dataStructureSortOf(variable.getSort()).type());
        } else {
            this.result.append(variable.getSort());
        }
        if (MetaK.isBuiltinSort(variable.getSort()) || this.context.getDataStructureSorts().containsKey(variable.getSort())) {
            this.result.append(")");
            this.result.append(", ");
            this.result.append(".KList");
            this.result.append(") ");
        }
    }

    @Override
    public void visit(ListTerminator empty) {
        String sort = empty.getSort();
        if (MaudeHelper.basicSorts.contains(sort) || MetaK.isCellFragment(sort)) {
            this.result.append(".");
            this.result.append(sort);
        } else {
            Production prd = this.context.listConses.get(sort);
            UserList ul = (UserList)prd.getItems().get(0);
            this.result.append(".List`{\"");
            this.result.append(ul.getSeparator());
            this.result.append("\"`}");
        }
    }

    @Override
    public void visit(Rule rule) {
        boolean isTransition = false;
        for (Attribute a : rule.getAttributes().getContents()) {
            if (!GlobalSettings.transition.contains(a.getKey())) continue;
            isTransition = true;
            this.unusedTransitions.remove(a.getKey());
            break;
        }
        if (rule.getAttributes().containsKey("heat-choice")) {
            isTransition = true;
        }
        if (!(rule.getBody() instanceof Rewrite)) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.INTERNAL, "This rule should have a rewrite at top by now.", this.getName(), rule.getFilename(), rule.getLocation()));
        }
        Rewrite body = (Rewrite)rule.getBody();
        assert (rule.getEnsures() == null) : "Maude does not support conditions on the right hand side";
        Term condition = rule.getRequires();
        if (null != condition) {
            this.result.append("c");
        }
        if (isTransition) {
            this.result.append("rl ");
        } else {
            this.result.append("eq ");
        }
        body.getLeft().accept(this);
        if (isTransition) {
            this.result.append(" => ");
        } else {
            this.result.append(" = ");
        }
        body.getRight().accept(this);
        if (null != condition) {
            this.result.append(" if ");
            condition.accept(this);
            this.result.append(" = _`(_`)(# true, .KList)");
        }
        if (null != rule.getAttributes()) {
            this.result.append(" [");
            if (!isTransition && rule.getAttributes().containsKey("owise")) {
                this.result.append("owise ");
            }
            if (rule.getLabel() != null && !rule.getLabel().equals("")) {
                this.result.append("label " + rule.getLabel() + " metadata");
            } else {
                this.result.append("metadata");
            }
            this.result.append(" \"");
            rule.getAttributes().accept(this);
            this.result.append("\"] .\n");
        }
    }

    @Override
    public void visit(KApp kapp) {
        this.result.append("_`(_`)(");
        kapp.getLabel().accept(this);
        this.result.append(", ");
        kapp.getChild().accept(this);
        this.result.append(")");
    }

    @Override
    public void visit(KSequence ksequence) {
        this.visit((Collection)ksequence);
    }

    @Override
    public void visit(TermCons termCons) {
        Production pr = (Production)this.context.conses.get(termCons.getCons());
        String cons = StringUtil.escapeMaude(pr.getLabel());
        if (pr.containsAttribute("maudeop")) {
            cons = pr.getAttribute("maudeop").replaceAll("\"", "").replaceAll(" ", "`");
        }
        this.result.append(cons);
        if (termCons.getContents().size() > 0) {
            this.result.append("(");
        }
        boolean first = true;
        for (Term term : termCons.getContents()) {
            if (!first) {
                this.result.append(",");
            } else {
                first = false;
            }
            if (term != null) {
                term.accept(this);
                continue;
            }
            this.result.append("null");
        }
        if (termCons.getContents().size() > 0) {
            this.result.append(")");
        }
    }

    @Override
    public void visit(Sentence sentence) {
        sentence.getBody().accept(this);
        this.result.append(" ");
        if (sentence.getRequires() != null) {
            this.result.append("when ");
            sentence.getRequires().accept(this);
        }
        assert (sentence.getEnsures() == null) : "Maude does not support conditions on the right hand side";
        this.result.append(" : KSentence [");
        if (sentence instanceof Rule) {
            Rule rule = (Rule)sentence;
            if (rule.getLabel() != null && !rule.getLabel().equals("")) {
                this.result.append("label " + rule.getLabel() + " metadata");
            } else {
                this.result.append("metadata");
            }
        } else {
            this.result.append("metadata");
        }
        this.result.append(" \"");
        sentence.getAttributes().accept(this);
        this.result.append("\"] .");
    }

    @Override
    public void visit(Rewrite rewrite) {
        this.result.append("_=>_(");
        if (rewrite.getLeft() == null) {
            this.result.append("null");
        } else {
            rewrite.getLeft().accept(this);
        }
        this.result.append(",");
        if (rewrite.getRight() == null) {
            this.result.append("null");
        } else {
            rewrite.getRight().accept(this);
        }
        this.result.append(")");
    }

    @Override
    public void visit(KLabelConstant kLabelConstant) {
        this.result.append(StringUtil.escapeMaude(kLabelConstant.getLabel()));
    }

    @Override
    public void visit(GenericToken token) {
        if (this.maudeBuiltinTokenSorts.contains(token.tokenSort())) {
            this.result.append("#_(" + token.value() + ")");
        } else {
            this.result.append(token);
        }
    }

    @Override
    public void visit(StringBuiltin token) {
        this.result.append("#_(\"" + StringUtil.escape(token.stringValue()) + "\")");
    }

    @Override
    public void visit(Token token) {
        this.result.append("#_(" + token.value() + ")");
    }

    @Override
    public void visit(Collection collection) {
        if (collection.getContents().size() == 0) {
            new ListTerminator(collection.getSort(), null).accept(this);
        } else if (collection.getContents().size() == 1) {
            collection.getContents().get(0).accept(this);
        } else {
            String constructor = MaudeFilter.getMaudeConstructor(collection.getSort());
            this.result.append(constructor);
            this.result.append("(");
            boolean first = true;
            for (Term term : collection.getContents()) {
                if (!first) {
                    this.result.append(", ");
                } else {
                    first = false;
                }
                if (term == null) {
                    GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.INTERNAL, "NULL Term encountered when MaudeFilter ran on collection " + collection.getContents() + ".", collection.getFilename(), collection.getLocation()));
                }
                term.accept(this);
            }
            this.result.append(")");
        }
    }

    @Override
    public void visit(CollectionItem collectionItem) {
        throw new RuntimeException("don't know how to maudify CollectionItem");
    }

    @Override
    public void visit(BagItem bagItem) {
        this.result.append("BagItem(");
        bagItem.getItem().accept(this);
        this.result.append(")");
    }

    @Override
    public void visit(ListItem listItem) {
        this.result.append("ListItem(");
        listItem.getItem().accept(this);
        this.result.append(")");
    }

    @Override
    public void visit(SetItem setItem) {
        this.result.append("SetItem(");
        setItem.getItem().accept(this);
        this.result.append(")");
    }

    @Override
    public void visit(MapItem mapItem) {
        this.result.append("_|->_(");
        mapItem.getKey().accept(this);
        this.result.append(",");
        mapItem.getValue().accept(this);
        this.result.append(")");
    }

    @Override
    public void visit(DataStructureBuiltin dataStructure) {
        this.result.append("_`(_`)(" + dataStructure.sort().type() + "2KLabel_(");
        if (!dataStructure.isEmpty()) {
            this.result.append(DataStructureSort.LABELS.get(dataStructure.sort().type()).get((Object)DataStructureSort.Label.CONSTRUCTOR));
            this.result.append("(");
            this.result.append(DataStructureSort.LABELS.get(dataStructure.sort().type()).get((Object)DataStructureSort.Label.UNIT));
            if (dataStructure instanceof ListBuiltin) {
                this.visitListBuiltinElements((ListBuiltin)dataStructure);
            } else if (dataStructure instanceof CollectionBuiltin) {
                this.visitCollectionElements((CollectionBuiltin)dataStructure);
            } else {
                assert (dataStructure instanceof MapBuiltin);
                this.visitMapElements((MapBuiltin)dataStructure);
            }
            if (dataStructure.isLHSView() && dataStructure.hasViewBase() && !(dataStructure instanceof ListBuiltin)) {
                this.result.append(", ");
                Variable variable = new Variable(dataStructure.viewBase().getName(), dataStructure.sort().type());
                variable.accept(this);
            }
            this.result.append(")");
        } else {
            this.result.append(DataStructureSort.LABELS.get(dataStructure.sort().type()).get((Object)DataStructureSort.Label.UNIT));
        }
        this.result.append("), .KList)");
    }

    private void visitCollectionElements(CollectionBuiltin collection) {
        for (Term term : collection.elements()) {
            this.result.append(", ");
            this.result.append(DataStructureSort.LABELS.get(collection.sort().type()).get((Object)DataStructureSort.Label.ELEMENT));
            this.result.append("(");
            term.accept(this);
            this.result.append(")");
        }
    }

    public void visitListBuiltinElements(ListBuiltin listBuiltin) {
        for (Term term : listBuiltin.elementsLeft()) {
            this.result.append(", ");
            this.result.append(DataStructureSort.LABELS.get(listBuiltin.sort().type()).get((Object)DataStructureSort.Label.ELEMENT));
            this.result.append("(");
            term.accept(this);
            this.result.append(")");
        }
        for (Term term : listBuiltin.baseTerms()) {
            this.result.append(", ");
            if (term instanceof Variable) {
                Variable variable = new Variable(listBuiltin.viewBase().getName(), listBuiltin.sort().type());
                variable.accept(this);
                continue;
            }
            this.result.append(DataStructureSort.LABELS.get(listBuiltin.sort().type()).get((Object)DataStructureSort.Label.ELEMENT));
            this.result.append("(");
            term.accept(this);
            this.result.append(")");
        }
        for (Term term : listBuiltin.elementsRight()) {
            this.result.append(", ");
            this.result.append(DataStructureSort.LABELS.get(listBuiltin.sort().type()).get((Object)DataStructureSort.Label.ELEMENT));
            this.result.append("(");
            term.accept(this);
            this.result.append(")");
        }
    }

    private void visitMapElements(MapBuiltin map) {
        for (Map.Entry<Term, Term> entry : map.elements().entrySet()) {
            this.result.append(", ");
            this.result.append(DataStructureSort.LABELS.get(map.sort().type()).get((Object)DataStructureSort.Label.ELEMENT));
            this.result.append("(");
            entry.getKey().accept(this);
            this.result.append(", ");
            entry.getValue().accept(this);
            this.result.append(")");
        }
    }

    @Override
    public void visit(CollectionBuiltin collection) {
        this.visit((DataStructureBuiltin)collection);
    }

    @Override
    public void visit(MapBuiltin map) {
        this.visit((DataStructureBuiltin)map);
    }

    @Override
    public void visit(Hole hole) {
        this.result.append("HOLE");
    }

    @Override
    public void visit(FreezerHole hole) {
        this.result.append("HOLE");
    }

    @Override
    public void visit(KInjectedLabel kInjectedLabel) {
        String sort;
        Term term = kInjectedLabel.getTerm();
        String string = sort = term.getSort().equals("K") ? "KList" : term.getSort();
        if (MetaK.isKSort(sort)) {
            this.result.append(KInjectedLabel.getInjectedSort(sort));
            this.result.append("2KLabel_(");
        } else if (MetaK.isCellSort(sort)) {
            this.result.append(sort + "2KLabel_(");
        } else {
            this.result.append("#_(");
        }
        term.accept(this);
        this.result.append(")");
    }

    @Override
    public void visit(FreezerLabel freezerLabel) {
        Term term = freezerLabel.getTerm();
        this.result.append("#freezer_(");
        term.accept(this);
        this.result.append(")");
    }

    @Override
    public void visit(Freezer freezer) {
        freezer.getTerm().accept(this);
    }

    @Override
    public void visit(KLabel kLabel) {
        throw new RuntimeException("don't know how to maudify KLabel of type" + kLabel.getClass());
    }

    @Override
    public void visit(TermComment termComment) {
        this.result.append(" .Bag ");
    }

    @Override
    public void visit(org.kframework.kil.List list) {
        this.visit((Collection)list);
    }

    @Override
    public void visit(Map map) {
        this.visit((Collection)map);
    }

    @Override
    public void visit(Bag bag) {
        if (bag.getContents().isEmpty()) {
            new ListTerminator("Bag", null).accept(this);
            return;
        }
        for (Term item : bag.getContents()) {
            if (item instanceof TermComment) continue;
            this.result.append("(");
            item.accept(this);
            this.result.append(")");
            this.result.append(" ");
        }
    }

    @Override
    public void visit(Set set) {
        this.visit((Collection)set);
    }

    @Override
    public void visit(Ambiguity ambiguity) {
        this.result.append("amb(");
        boolean first = true;
        for (Term term : ambiguity.getContents()) {
            if (!first) {
                this.result.append(",");
            } else {
                first = false;
            }
            if (term != null) {
                term.accept(this);
                continue;
            }
            this.result.append("null");
        }
        this.result.append(")");
    }

    @Override
    public void visit(org.kframework.kil.Context context) {
        this.result.append("mb context ");
        this.visit((Sentence)context);
        this.result.append("\n");
    }

    @Override
    public void visit(LiterateDefinitionComment literateDefinitionComment) {
    }

    @Override
    public void visit(LiterateModuleComment literateModuleComment) {
    }

    @Override
    public void visit(Require require) {
    }

    @Override
    public void visit(BackendTerm term) {
        this.result.append(term.getValue());
    }

    @Override
    public void visit(Bracket term) {
        term.getContent().accept(this);
    }

    @Override
    public void visit(Cast term) {
        throw new RuntimeException("don't know how to maudify Cast at " + term.getFilename() + " " + term.getLocation());
    }

    @Override
    public void visit(MapUpdate term) {
        this.result.append("_`(_`)(Map2KLabel(");
        this.result.append("update(");
        this.result.append("remove(");
        this.result.append(term.map().getName() + ":Map , (.Map ");
        for (Map.Entry<Term, Term> t : term.removeEntries().entrySet()) {
            t.getKey().accept(this);
            this.result.append(" |-> ");
            t.getValue().accept(this);
            this.result.append(" ");
        }
        this.result.append(")), ");
        this.result.append("(.Map ");
        for (Map.Entry<Term, Term> t : term.updateEntries().entrySet()) {
            t.getKey().accept(this);
            this.result.append(" |-> ");
            t.getValue().accept(this);
            this.result.append(" ");
        }
        this.result.append("))");
        this.result.append(") , .KList)");
    }

    public static String getMaudeConstructor(String sort) {
        return maudeCollectionConstructors.get((Object)KSort.getKSort(sort));
    }

    static {
        maudeCollectionConstructors.put(KSort.Bag, "__");
        maudeCollectionConstructors.put(KSort.Map, "__");
        maudeCollectionConstructors.put(KSort.Set, "__");
        maudeCollectionConstructors.put(KSort.List, "__");
        maudeCollectionConstructors.put(KSort.K, "_~>_");
        maudeCollectionConstructors.put(KSort.KList, "_`,`,_");
    }
}

