/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.maude.krun;

import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedOrderedSparseMultigraph;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.io.graphml.EdgeMetadata;
import edu.uci.ics.jung.io.graphml.GraphMLReader2;
import edu.uci.ics.jung.io.graphml.GraphMetadata;
import edu.uci.ics.jung.io.graphml.HyperEdgeMetadata;
import edu.uci.ics.jung.io.graphml.NodeMetadata;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections15.Transformer;
import org.kframework.backend.maude.MaudeFilter;
import org.kframework.compile.utils.RuleCompilerSteps;
import org.kframework.kil.Ambiguity;
import org.kframework.kil.BackendTerm;
import org.kframework.kil.Bag;
import org.kframework.kil.BagItem;
import org.kframework.kil.BoolBuiltin;
import org.kframework.kil.Cell;
import org.kframework.kil.FreezerLabel;
import org.kframework.kil.GenericToken;
import org.kframework.kil.Hole;
import org.kframework.kil.IntBuiltin;
import org.kframework.kil.KApp;
import org.kframework.kil.KInjectedLabel;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.KList;
import org.kframework.kil.KSequence;
import org.kframework.kil.ListItem;
import org.kframework.kil.Map;
import org.kframework.kil.MapItem;
import org.kframework.kil.Module;
import org.kframework.kil.Production;
import org.kframework.kil.Rule;
import org.kframework.kil.Set;
import org.kframework.kil.SetItem;
import org.kframework.kil.StringBuiltin;
import org.kframework.kil.Term;
import org.kframework.kil.TermCons;
import org.kframework.kil.Token;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.krun.K;
import org.kframework.krun.KRunExecutionException;
import org.kframework.krun.SubstitutionFilter;
import org.kframework.krun.XmlUtil;
import org.kframework.krun.api.KRun;
import org.kframework.krun.api.KRunApiDebugger;
import org.kframework.krun.api.KRunDebugger;
import org.kframework.krun.api.KRunProofResult;
import org.kframework.krun.api.KRunResult;
import org.kframework.krun.api.KRunState;
import org.kframework.krun.api.SearchResult;
import org.kframework.krun.api.SearchResults;
import org.kframework.krun.api.SearchType;
import org.kframework.krun.api.TestGenResults;
import org.kframework.krun.api.Transition;
import org.kframework.krun.api.UnsupportedBackendOptionException;
import org.kframework.krun.runner.KRunner;
import org.kframework.utils.Error;
import org.kframework.utils.Stopwatch;
import org.kframework.utils.StringUtil;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.file.FileUtil;
import org.kframework.utils.general.GlobalSettings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MaudeKRun
implements KRun {
    protected Context context;
    private boolean ioServer = K.io;
    public static Pattern emptyPattern = Pattern.compile("\\.(Map|Bag|List|Set|K)");

    public MaudeKRun(Context context) {
        this.context = context;
    }

    @Override
    public void setBackendOption(String key, Object value) {
        if (key.equals("io")) {
            this.ioServer = (Boolean)value;
        }
    }

    private void executeKRun(StringBuilder maudeCmd) throws KRunExecutionException {
        String content;
        int returnValue;
        FileUtil.save(K.maude_in, maudeCmd);
        File outFile = FileUtil.createFile(K.maude_out);
        File errFile = FileUtil.createFile(K.maude_err);
        try {
            if (K.log_io) {
                KRunner.main(new String[]{"--maudeFile", K.compiled_def + K.fileSeparator + "main.maude", "--moduleName", K.main_module, "--commandFile", K.maude_in, "--outputFile", outFile.getCanonicalPath(), "--errorFile", errFile.getCanonicalPath(), "--createLogs"}, this.context);
            }
            returnValue = !this.ioServer ? KRunner.main(new String[]{"--maudeFile", K.compiled_def + K.fileSeparator + "main.maude", "--moduleName", K.main_module, "--commandFile", K.maude_in, "--outputFile", outFile.getCanonicalPath(), "--errorFile", errFile.getCanonicalPath(), "--noServer"}, this.context) : KRunner.main(new String[]{"--maudeFile", K.compiled_def + K.fileSeparator + "main.maude", "--moduleName", K.main_module, "--commandFile", K.maude_in, "--outputFile", outFile.getCanonicalPath(), "--errorFile", errFile.getCanonicalPath()}, this.context);
        }
        catch (Exception e) {
            throw new RuntimeException("Runner threw exception", e);
        }
        if (errFile.exists() && (content = FileUtil.getFileContent(K.maude_err)).length() > 0) {
            throw new KRunExecutionException(content);
        }
        if (returnValue != 0) {
            Error.report("Maude returned non-zero value: " + returnValue);
        }
    }

    @Override
    public KRunResult<KRunState> run(Term cfg) throws KRunExecutionException {
        MaudeFilter maudeFilter = new MaudeFilter(this.context);
        cfg.accept(maudeFilter);
        StringBuilder cmd = new StringBuilder();
        if (K.trace) {
            cmd.append("set trace on .").append(K.lineSeparator);
        }
        cmd.append("set show command off .").append(K.lineSeparator).append(this.setCounter()).append(K.maude_cmd).append(" ").append((CharSequence)maudeFilter.getResult()).append(" .");
        if (K.profile) {
            cmd.append("set profile on .").append(K.lineSeparator).append(K.lineSeparator).append("show profile .");
        }
        cmd.append(this.getCounter());
        this.executeKRun(cmd);
        Stopwatch.sw.printIntermediate("Execution");
        try {
            return this.parseRunResult();
        }
        catch (IOException e) {
            throw new KRunExecutionException("Parsing maude output exception", e);
        }
    }

    private String setCounter() {
        return "red setCounter(" + Integer.toString(K.counter) + ") ." + K.lineSeparator;
    }

    private String getCounter() {
        return K.lineSeparator + "red counter .";
    }

    @Override
    public KRunResult<KRunState> step(Term cfg, int steps) throws KRunExecutionException {
        String maude_cmd = K.maude_cmd;
        K.maude_cmd = steps == 0 ? "red" : "rew[" + Integer.toString(steps) + "]";
        KRunResult<KRunState> result = this.run(cfg);
        K.maude_cmd = maude_cmd;
        return result;
    }

    private String printStatistics(Element elem) {
        String result = "";
        if ("search".equals(K.maude_cmd)) {
            String totalStates = elem.getAttribute("total-states");
            String totalRewrites = elem.getAttribute("total-rewrites");
            String realTime = elem.getAttribute("real-time-ms");
            String cpuTime = elem.getAttribute("cpu-time-ms");
            String rewritesPerSecond = elem.getAttribute("rewrites-per-second");
            result = result + "states: " + totalStates + " rewrites: " + totalRewrites + " in " + cpuTime + "ms cpu (" + realTime + "ms real) (" + rewritesPerSecond + " rewrites/second)";
        } else if ("erewrite".equals(K.maude_cmd)) {
            String totalRewrites = elem.getAttribute("total-rewrites");
            String realTime = elem.getAttribute("real-time-ms");
            String cpuTime = elem.getAttribute("cpu-time-ms");
            String rewritesPerSecond = elem.getAttribute("rewrites-per-second");
            result = result + "rewrites: " + totalRewrites + " in " + cpuTime + "ms cpu (" + realTime + "ms real) (" + rewritesPerSecond + " rewrites/second)";
        }
        return result;
    }

    private KRunResult<KRunState> parseRunResult() throws IOException {
        Document doc = XmlUtil.readXMLFromFile(K.maude_output);
        NodeList list = doc.getElementsByTagName("result");
        Node nod = list.item(1);
        MaudeKRun.assertXML(nod != null && nod.getNodeType() == 1);
        Element elem = (Element)nod;
        ArrayList<Element> child = XmlUtil.getChildElements(elem);
        MaudeKRun.assertXML(child.size() == 1);
        KRunState state = this.parseElement((Element)child.get(0), this.context);
        KRunResult<KRunState> ret = new KRunResult<KRunState>(state);
        String statistics = this.printStatistics(elem);
        ret.setStatistics(statistics);
        ret.setRawOutput(FileUtil.getFileContent(K.maude_out));
        this.parseCounter(list.item(2));
        return ret;
    }

    private KRunState parseElement(Element el, Context context) {
        Term rawResult = MaudeKRun.parseXML(el, context);
        return new KRunState(rawResult, context);
    }

    private void parseCounter(Node counter) {
        MaudeKRun.assertXML(counter != null && counter.getNodeType() == 1);
        Element elem = (Element)counter;
        ArrayList<Element> child = XmlUtil.getChildElements(elem);
        MaudeKRun.assertXML(child.size() == 1);
        IntBuiltin intBuiltin = (IntBuiltin)MaudeKRun.parseXML((Element)child.get(0), this.context);
        K.counter = intBuiltin.bigIntegerValue().intValue() - 1;
    }

    private static void assertXML(boolean assertion) {
        if (!assertion) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Cannot parse result xml from maude. If you believe this to be in error, please file a bug and attach " + K.maude_output.replaceAll("/krun[0-9]*/", "/krun/")));
        }
    }

    private static void assertXMLTerm(boolean assertion) throws Exception {
        if (!assertion) {
            throw new Exception();
        }
    }

    public static Term parseXML(Element xml2, Context context) {
        String op = xml2.getAttribute("op");
        String sort = xml2.getAttribute("sort");
        sort = sort.replaceAll("`([{}\\[\\](),])", "$1");
        ArrayList<Element> list = XmlUtil.getChildElements(xml2);
        try {
            if ((sort.equals("BagItem") || sort.equals("[Bag]")) && op.equals("<_>_</_>")) {
                Cell cell = new Cell();
                MaudeKRun.assertXMLTerm(list.size() == 3 && ((Element)list.get(0)).getAttribute("sort").equals("CellLabel") && ((Element)list.get(2)).getAttribute("sort").equals("CellLabel") && ((Element)list.get(0)).getAttribute("op").equals(((Element)list.get(2)).getAttribute("op")));
                cell.setLabel(((Element)list.get(0)).getAttribute("op"));
                cell.setContents(MaudeKRun.parseXML((Element)list.get(1), context));
                return cell;
            }
            if ((sort.equals("BagItem") || sort.equals("[Bag]")) && op.equals("BagItem")) {
                MaudeKRun.assertXMLTerm(list.size() == 1);
                return new BagItem(MaudeKRun.parseXML((Element)list.get(0), context));
            }
            if ((sort.equals("MapItem") || sort.equals("[Map]")) && op.equals("_|->_")) {
                MaudeKRun.assertXMLTerm(list.size() == 2);
                return new MapItem(MaudeKRun.parseXML((Element)list.get(0), context), MaudeKRun.parseXML((Element)list.get(1), context));
            }
            if ((sort.equals("SetItem") || sort.equals("[Set]")) && op.equals("SetItem")) {
                MaudeKRun.assertXMLTerm(list.size() == 1);
                return new SetItem(MaudeKRun.parseXML((Element)list.get(0), context));
            }
            if ((sort.equals("ListItem") || sort.equals("[List]")) && op.equals("ListItem")) {
                MaudeKRun.assertXMLTerm(list.size() == 1);
                return new ListItem(MaudeKRun.parseXML((Element)list.get(0), context));
            }
            if (op.equals("_`,`,_") && sort.equals("NeKList")) {
                MaudeKRun.assertXMLTerm(list.size() >= 2);
                ArrayList<Term> l = new ArrayList<Term>();
                for (Element elem : list) {
                    l.add(MaudeKRun.parseXML(elem, context));
                }
                return new KList(l);
            }
            if (sort.equals("K") && op.equals("_~>_")) {
                MaudeKRun.assertXMLTerm(list.size() >= 2);
                ArrayList<Term> l = new ArrayList<Term>();
                for (Element elem : list) {
                    l.add(MaudeKRun.parseXML(elem, context));
                }
                return new KSequence(l);
            }
            if (op.equals("__") && (sort.equals("NeList") || sort.equals("List") || sort.equals("[List]"))) {
                MaudeKRun.assertXMLTerm(list.size() >= 2);
                ArrayList<Term> l = new ArrayList<Term>();
                for (Element elem : list) {
                    l.add(MaudeKRun.parseXML(elem, context));
                }
                return new org.kframework.kil.List(l);
            }
            if (op.equals("__") && (sort.equals("NeBag") || sort.equals("Bag") || sort.equals("[Bag]"))) {
                MaudeKRun.assertXMLTerm(list.size() >= 2);
                ArrayList<Term> l = new ArrayList<Term>();
                for (Element elem : list) {
                    l.add(MaudeKRun.parseXML(elem, context));
                }
                return new Bag(l);
            }
            if (op.equals("__") && (sort.equals("NeSet") || sort.equals("Set") || sort.equals("[Set]"))) {
                MaudeKRun.assertXMLTerm(list.size() >= 2);
                ArrayList<Term> l = new ArrayList<Term>();
                for (Element elem : list) {
                    l.add(MaudeKRun.parseXML(elem, context));
                }
                return new Set(l);
            }
            if (op.equals("__") && (sort.equals("NeMap") || sort.equals("Map") || sort.equals("[Map]"))) {
                MaudeKRun.assertXMLTerm(list.size() >= 2);
                ArrayList<Term> l = new ArrayList<Term>();
                for (Element elem : list) {
                    l.add(MaudeKRun.parseXML(elem, context));
                }
                return new Map(l);
            }
            if ((op.equals("#_") || op.equals("List2KLabel_") || op.equals("Map2KLabel_") || op.equals("Set2KLabel_") || op.equals("Bag2KLabel_") || op.equals("KList2KLabel_") || op.equals("KLabel2KLabel_")) && (sort.equals("KLabel") || sort.equals("[KLabel]"))) {
                MaudeKRun.assertXMLTerm(list.size() == 1);
                Term term = MaudeKRun.parseXML((Element)list.get(0), context);
                if (op.equals("#_") && term instanceof Token) {
                    return term;
                }
                return new KInjectedLabel(term);
            }
            if (sort.equals("#NzInt") && op.equals("--Int_")) {
                MaudeKRun.assertXMLTerm(list.size() == 1);
                return IntBuiltin.of("-" + ((IntBuiltin)MaudeKRun.parseXML((Element)list.get(0), context)).value());
            }
            if (sort.equals("#NzNat") && op.equals("sNat_")) {
                MaudeKRun.assertXMLTerm(list.size() == 1 && MaudeKRun.parseXML((Element)list.get(0), context).equals(IntBuiltin.ZERO_TOKEN));
                return IntBuiltin.of(xml2.getAttribute("number"));
            }
            if (sort.equals("#Zero") && op.equals("0")) {
                MaudeKRun.assertXMLTerm(list.size() == 0);
                return IntBuiltin.ZERO_TOKEN;
            }
            if (sort.equals("#Bool") && (op.equals("true") || op.equals("false"))) {
                MaudeKRun.assertXMLTerm(list.size() == 0);
                return BoolBuiltin.of(op);
            }
            if (sort.equals("#Char") || sort.equals("#String")) {
                MaudeKRun.assertXMLTerm(list.size() == 0);
                MaudeKRun.assertXMLTerm(op.startsWith("\"") && op.endsWith("\""));
                return StringBuiltin.of(StringUtil.unescape(op.substring(1, op.length() - 1)));
            }
            if (op.equals("#token") && sort.equals("KLabel")) {
                MaudeKRun.assertXMLTerm(list.size() == 2);
                StringBuiltin sortString = (StringBuiltin)MaudeKRun.parseXML((Element)list.get(0), context);
                StringBuiltin valueString = (StringBuiltin)MaudeKRun.parseXML((Element)list.get(1), context);
                return GenericToken.of(sortString.stringValue(), valueString.stringValue());
            }
            if (sort.equals("#FiniteFloat")) {
                MaudeKRun.assertXMLTerm(list.size() == 0);
                return GenericToken.of("#Float", op);
            }
            if (emptyPattern.matcher(op).matches() && (sort.equals("Bag") || sort.equals("List") || sort.equals("Map") || sort.equals("Set") || sort.equals("K"))) {
                MaudeKRun.assertXMLTerm(list.size() == 0);
                if (sort.equals("Bag")) {
                    return Bag.EMPTY;
                }
                if (sort.equals("List")) {
                    return org.kframework.kil.List.EMPTY;
                }
                if (sort.equals("Map")) {
                    return Map.EMPTY;
                }
                if (sort.equals("Set")) {
                    return Set.EMPTY;
                }
                return KSequence.EMPTY;
            }
            if (op.equals(".KList") && sort.equals("KList")) {
                MaudeKRun.assertXMLTerm(list.size() == 0);
                return KList.EMPTY;
            }
            if (op.equals("_`(_`)") && (sort.equals("KItem") || sort.equals("[KList]"))) {
                MaudeKRun.assertXMLTerm(list.size() == 2);
                Term child = MaudeKRun.parseXML((Element)list.get(1), context);
                if (!(child instanceof KList)) {
                    ArrayList<Term> terms = new ArrayList<Term>();
                    terms.add(child);
                    child = new KList(terms);
                }
                return new KApp(MaudeKRun.parseXML((Element)list.get(0), context), child);
            }
            if (sort.equals("KLabel") && list.size() == 0) {
                return KLabelConstant.of(StringUtil.unescapeMaude(op), context);
            }
            if (sort.equals("KLabel") && op.equals("#freezer_")) {
                MaudeKRun.assertXMLTerm(list.size() == 1);
                return new FreezerLabel(MaudeKRun.parseXML((Element)list.get(0), context));
            }
            if (op.equals("HOLE")) {
                MaudeKRun.assertXMLTerm(list.size() == 0 && sort.equals("KItem"));
                return Hole.KITEM_HOLE;
            }
            java.util.Set<String> conses = context.labels.get(StringUtil.unescapeMaude(op));
            HashSet<String> validConses = new HashSet<String>();
            ArrayList<Term> possibleTerms = new ArrayList<Term>();
            MaudeKRun.assertXMLTerm(conses != null);
            for (String cons : conses) {
                Production p = (Production)context.conses.get(cons);
                if (!p.getSort().equals(sort) || p.getArity() != list.size()) continue;
                validConses.add(cons);
            }
            MaudeKRun.assertXMLTerm(validConses.size() > 0);
            ArrayList<Term> contents = new ArrayList<Term>();
            for (Element elem : list) {
                contents.add(MaudeKRun.parseXML(elem, context));
            }
            for (String cons : validConses) {
                possibleTerms.add(new TermCons(sort, cons, contents, context));
            }
            if (possibleTerms.size() == 1) {
                return (Term)possibleTerms.get(0);
            }
            return new Ambiguity(sort, possibleTerms);
        }
        catch (Exception e) {
            return new BackendTerm(sort, MaudeKRun.flattenXML(xml2));
        }
    }

    public static String flattenXML(Element xml2) {
        ArrayList<Element> children = XmlUtil.getChildElements(xml2);
        if (children.size() == 0) {
            return xml2.getAttribute("op");
        }
        String result = xml2.getAttribute("op");
        if (!xml2.getAttribute("number").equals("")) {
            result = result + "^" + xml2.getAttribute("number");
        }
        String conn = "(";
        for (Element child : children) {
            result = result + conn;
            conn = ",";
            result = result + MaudeKRun.flattenXML(child);
        }
        result = result + ")";
        return result;
    }

    private static String getSearchType(SearchType s) {
        if (s == SearchType.ONE) {
            return "1";
        }
        if (s == SearchType.PLUS) {
            return "+";
        }
        if (s == SearchType.STAR) {
            return "*";
        }
        if (s == SearchType.FINAL) {
            return "!";
        }
        return null;
    }

    @Override
    public KRunResult<SearchResults> search(Integer bound, Integer depth, SearchType searchType, Rule pattern, Term cfg, RuleCompilerSteps compilationInfo) throws KRunExecutionException {
        StringBuilder cmd = new StringBuilder();
        if (K.trace) {
            cmd.append("set trace on .").append(K.lineSeparator);
        }
        cmd.append("set show command off .").append(K.lineSeparator).append(this.setCounter()).append("search ");
        if (bound != null && depth != null) {
            cmd.append("[").append(bound).append(",").append(depth).append("] ");
        } else if (bound != null) {
            cmd.append("[").append(bound).append("] ");
        } else if (depth != null) {
            cmd.append("[,").append(depth).append("] ");
        }
        MaudeFilter maudeFilter = new MaudeFilter(this.context);
        cfg.accept(maudeFilter);
        cmd.append((CharSequence)maudeFilter.getResult()).append(" ");
        MaudeFilter patternBody = new MaudeFilter(this.context);
        pattern.getBody().accept(patternBody);
        String patternString = "=>" + MaudeKRun.getSearchType(searchType) + " " + patternBody.getResult();
        if (pattern.getRequires() != null) {
            MaudeFilter patternCondition = new MaudeFilter(this.context);
            pattern.getRequires().accept(patternCondition);
            patternString = patternString + " such that " + patternCondition.getResult() + " = # true(.KList)";
        }
        cmd.append(patternString).append(" .");
        if (K.showSearchGraph || K.debug || K.guidebug) {
            cmd.append(K.lineSeparator).append("show search graph .");
        }
        cmd.append(this.getCounter());
        this.executeKRun(cmd);
        try {
            List<SearchResult> solutions = this.parseSearchResults(pattern, compilationInfo);
            boolean matches = patternString.trim().matches("=>[!*1+] <_>_</_>\\(generatedTop, B:Bag, generatedTop\\)");
            DirectedGraph<KRunState, Transition> graph = K.showSearchGraph || K.debug || K.guidebug ? this.parseSearchGraph() : null;
            SearchResults results = new SearchResults(solutions, graph, matches, this.context);
            K.stateCounter += graph != null ? graph.getVertexCount() : 0;
            KRunResult<SearchResults> result = new KRunResult<SearchResults>(results);
            result.setRawOutput(FileUtil.getFileContent(K.maude_out));
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Pretty-printer threw exception", e);
        }
    }

    private DirectedGraph<KRunState, Transition> parseSearchGraph() throws Exception {
        try (Scanner scanner = new Scanner(new File(K.maude_output));
             OutputStreamWriter writer = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(K.processed_maude_output)));){
            scanner.useDelimiter("\n");
            while (scanner.hasNext()) {
                String text = scanner.next();
                text = text.replaceAll("<data key=\"((rule)|(term))\">", "<data key=\"$1\"><![CDATA[");
                text = text.replaceAll("</data>", "]]></data>");
                ((Writer)writer).write(text, 0, text.length());
            }
        }
        Document doc = XmlUtil.readXMLFromFile(K.processed_maude_output);
        NodeList list = doc.getElementsByTagName("graphml");
        MaudeKRun.assertXML(list.getLength() == 1);
        Node nod = list.item(0);
        MaudeKRun.assertXML(nod != null && nod.getNodeType() == 1);
        XmlUtil.serializeXML(nod, K.processed_maude_output);
        Transformer<GraphMetadata, DirectedGraph<KRunState, Transition>> graphTransformer = new Transformer<GraphMetadata, DirectedGraph<KRunState, Transition>>(){

            @Override
            public DirectedGraph<KRunState, Transition> transform(GraphMetadata g) {
                return new DirectedSparseGraph<KRunState, Transition>();
            }
        };
        Transformer<NodeMetadata, KRunState> nodeTransformer = new Transformer<NodeMetadata, KRunState>(){

            @Override
            public KRunState transform(NodeMetadata n) {
                String nodeXmlString = n.getProperty("term");
                Element xmlTerm = XmlUtil.readXMLFromString(nodeXmlString).getDocumentElement();
                KRunState ret = MaudeKRun.this.parseElement(xmlTerm, MaudeKRun.this.context);
                String id = n.getId();
                id = id.substring(1);
                ret.setStateId(Integer.parseInt(id) + K.stateCounter);
                return ret;
            }
        };
        Transformer<EdgeMetadata, Transition> edgeTransformer = new Transformer<EdgeMetadata, Transition>(){

            @Override
            public Transition transform(EdgeMetadata e) {
                String edgeXmlString = e.getProperty("rule");
                Element elem = XmlUtil.readXMLFromString(edgeXmlString).getDocumentElement();
                String metadataAttribute = elem.getAttribute("metadata");
                Pattern pattern = Pattern.compile("([a-z]*)=\\((.*?)\\)");
                Matcher matcher = pattern.matcher(metadataAttribute);
                String location = null;
                String filename = null;
                while (matcher.find()) {
                    String name = matcher.group(1);
                    if (name.equals("location")) {
                        location = matcher.group(2);
                    }
                    if (!name.equals("filename")) continue;
                    filename = matcher.group(2);
                }
                if (location == null || location.equals("generated") || filename == null) {
                    String labelAttribute = elem.getAttribute("label");
                    if (labelAttribute == null) {
                        return Transition.unlabelled(MaudeKRun.this.context);
                    }
                    return Transition.label(labelAttribute, MaudeKRun.this.context);
                }
                return Transition.rule(MaudeKRun.this.context.locations.get(filename + ":(" + location + ")"), MaudeKRun.this.context);
            }
        };
        Transformer<HyperEdgeMetadata, Transition> hyperEdgeTransformer = new Transformer<HyperEdgeMetadata, Transition>(){

            @Override
            public Transition transform(HyperEdgeMetadata h) {
                throw new RuntimeException("Found a hyper-edge. Has someone been tampering with our intermediate files?");
            }
        };
        try (BufferedReader processedMaudeOutputReader = new BufferedReader(new FileReader(K.processed_maude_output));){
            GraphMLReader2<DirectedGraph<KRunState, Transition>, KRunState, Transition> graphmlParser = new GraphMLReader2<DirectedGraph<KRunState, Transition>, KRunState, Transition>(processedMaudeOutputReader, graphTransformer, nodeTransformer, edgeTransformer, hyperEdgeTransformer);
            DirectedGraph<KRunState, Transition> directedGraph = graphmlParser.readGraph();
            return directedGraph;
        }
    }

    private List<SearchResult> parseSearchResults(Rule pattern, RuleCompilerSteps compilationInfo) {
        Node nod;
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        Document doc = XmlUtil.readXMLFromFile(K.maude_output);
        NodeList list = doc.getElementsByTagName("search-result");
        for (int i = 0; i < list.getLength(); ++i) {
            Object result;
            nod = list.item(i);
            MaudeKRun.assertXML(nod != null && nod.getNodeType() == 1);
            Element elem = (Element)nod;
            if (elem.getAttribute("solution-number").equals("NONE")) continue;
            int stateNum = Integer.parseInt(elem.getAttribute("state-number"));
            HashMap<String, Term> rawSubstitution = new HashMap<String, Term>();
            NodeList assignments = elem.getElementsByTagName("assignment");
            for (int j = 0; j < assignments.getLength(); ++j) {
                nod = assignments.item(j);
                MaudeKRun.assertXML(nod != null && nod.getNodeType() == 1);
                elem = (Element)nod;
                ArrayList<Element> child = XmlUtil.getChildElements(elem);
                MaudeKRun.assertXML(child.size() == 2);
                result = MaudeKRun.parseXML((Element)child.get(1), this.context);
                rawSubstitution.put(((Element)child.get(0)).getAttribute("op"), (Term)result);
            }
            try {
                Term rawResult = (Term)pattern.getBody().accept(new SubstitutionFilter(rawSubstitution, this.context));
                KRunState state = new KRunState(rawResult, this.context);
                state.setStateId(stateNum + K.stateCounter);
                result = new SearchResult(state, rawSubstitution, compilationInfo, this.context);
                results.add((SearchResult)result);
                continue;
            }
            catch (TransformerException e) {
                e.report();
            }
        }
        list = doc.getElementsByTagName("result");
        nod = list.item(1);
        this.parseCounter(nod);
        return results;
    }

    @Override
    public KRunProofResult<DirectedGraph<KRunState, Transition>> modelCheck(Term formula, Term cfg) throws KRunExecutionException {
        MaudeFilter formulaFilter = new MaudeFilter(this.context);
        formula.accept(formulaFilter);
        MaudeFilter cfgFilter = new MaudeFilter(this.context);
        cfg.accept(cfgFilter);
        StringBuilder cmd = new StringBuilder().append("mod MCK is").append(K.lineSeparator).append(" including ").append(K.main_module).append(" .").append(K.lineSeparator).append(K.lineSeparator).append(" op #initConfig : -> Bag .").append(K.lineSeparator).append(K.lineSeparator).append(" eq #initConfig  =").append(K.lineSeparator).append((CharSequence)cfgFilter.getResult()).append(" .").append(K.lineSeparator).append("endm").append(K.lineSeparator).append(K.lineSeparator).append("red").append(K.lineSeparator).append("_`(_`)(('modelCheck`(_`,_`)).KLabel,_`,`,_(_`(_`)(Bag2KLabel(#initConfig),.KList),").append(K.lineSeparator).append((CharSequence)formulaFilter.getResult()).append(")").append(K.lineSeparator).append(") .");
        boolean io = this.ioServer;
        this.ioServer = false;
        this.executeKRun(cmd);
        this.ioServer = io;
        KRunProofResult<DirectedGraph<KRunState, Transition>> result = this.parseModelCheckResult();
        result.setRawOutput(FileUtil.getFileContent(K.maude_out));
        return result;
    }

    @Override
    public KRunResult<TestGenResults> generate(Integer bound, Integer depth, SearchType searchType, Rule pattern, Term cfg, RuleCompilerSteps compilationInfo) throws KRunExecutionException {
        throw new UnsupportedOperationException("--generate-tests");
    }

    private KRunProofResult<DirectedGraph<KRunState, Transition>> parseModelCheckResult() {
        Document doc = XmlUtil.readXMLFromFile(K.maude_output);
        NodeList list = doc.getElementsByTagName("result");
        MaudeKRun.assertXML(list.getLength() == 1);
        Node nod = list.item(0);
        MaudeKRun.assertXML(nod != null && nod.getNodeType() == 1);
        Element elem = (Element)nod;
        ArrayList<Element> child = XmlUtil.getChildElements(elem);
        MaudeKRun.assertXML(child.size() == 1);
        String sort = ((Element)child.get(0)).getAttribute("sort");
        String op = ((Element)child.get(0)).getAttribute("op");
        MaudeKRun.assertXML(op.equals("_`(_`)") && sort.equals("KItem"));
        child = XmlUtil.getChildElements((Node)child.get(0));
        MaudeKRun.assertXML(child.size() == 2);
        sort = ((Element)child.get(0)).getAttribute("sort");
        op = ((Element)child.get(0)).getAttribute("op");
        MaudeKRun.assertXML(op.equals("#_") && sort.equals("KLabel"));
        sort = ((Element)child.get(1)).getAttribute("sort");
        op = ((Element)child.get(1)).getAttribute("op");
        MaudeKRun.assertXML(op.equals(".KList") && sort.equals("KList"));
        child = XmlUtil.getChildElements((Node)child.get(0));
        MaudeKRun.assertXML(child.size() == 1);
        elem = (Element)child.get(0);
        if (elem.getAttribute("op").equals("true") && elem.getAttribute("sort").equals("#Bool")) {
            return new KRunProofResult<Object>(true, null);
        }
        sort = elem.getAttribute("sort");
        op = elem.getAttribute("op");
        MaudeKRun.assertXML(op.equals("LTLcounterexample") && sort.equals("#ModelCheckResult"));
        child = XmlUtil.getChildElements(elem);
        MaudeKRun.assertXML(child.size() == 2);
        ArrayList<MaudeTransition> initialPath = new ArrayList<MaudeTransition>();
        ArrayList<MaudeTransition> loop = new ArrayList<MaudeTransition>();
        MaudeKRun.parseCounterexample((Element)child.get(0), initialPath, this.context);
        MaudeKRun.parseCounterexample((Element)child.get(1), loop, this.context);
        DirectedOrderedSparseMultigraph<KRunState, Transition> graph = new DirectedOrderedSparseMultigraph<KRunState, Transition>();
        Transition edge = null;
        KRunState vertex = null;
        for (MaudeTransition trans : initialPath) {
            graph.addVertex(trans.state);
            if (edge != null) {
                graph.addEdge(edge, vertex, trans.state);
            }
            edge = trans.label;
            vertex = trans.state;
        }
        for (MaudeTransition trans : loop) {
            graph.addVertex(trans.state);
            if (edge != null) {
                graph.addEdge(edge, vertex, trans.state);
            }
            edge = trans.label;
            vertex = trans.state;
        }
        graph.addEdge(edge, vertex, ((MaudeTransition)loop.get((int)0)).state);
        return new KRunProofResult<DirectedGraph<KRunState, Transition>>(false, graph);
    }

    private static void parseCounterexample(Element elem, List<MaudeTransition> list, Context context) {
        String sort = elem.getAttribute("sort");
        String op = elem.getAttribute("op");
        ArrayList<Element> child = XmlUtil.getChildElements(elem);
        if (sort.equals("#TransitionList") && op.equals("_LTL_")) {
            MaudeKRun.assertXML(child.size() >= 2);
            for (Element e : child) {
                MaudeKRun.parseCounterexample(e, list, context);
            }
        } else if (sort.equals("#Transition") && op.equals("LTL`{_`,_`}")) {
            MaudeKRun.assertXML(child.size() == 2);
            Term t = MaudeKRun.parseXML((Element)child.get(0), context);
            ArrayList<Element> child2 = XmlUtil.getChildElements((Node)child.get(1));
            sort = ((Element)child.get(1)).getAttribute("sort");
            op = ((Element)child.get(1)).getAttribute("op");
            MaudeKRun.assertXML(child2.size() == 0 && (sort.equals("#Qid") || sort.equals("#RuleName") || sort.equals("#Sort")));
            String label = op;
            Transition trans = sort.equals("#RuleName") && op.equals("UnlabeledLtl") ? Transition.unlabelled(context) : (sort.equals("#RuleName") && op.equals("deadlockLtl") ? Transition.deadlock(context) : Transition.label(label, context));
            list.add(new MaudeTransition(new KRunState(t, context), trans));
        } else if (sort.equals("#TransitionList") && op.equals("LTLnil")) {
            MaudeKRun.assertXML(child.size() == 0);
        } else {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Cannot parse result xml from maude due to production " + op + " of sort " + sort + ". Please file an error on the issue tracker which includes this error message."));
            MaudeKRun.assertXML(false);
        }
    }

    @Override
    public KRunDebugger debug(Term cfg) throws KRunExecutionException {
        return new KRunApiDebugger(this, cfg, this.context);
    }

    @Override
    public KRunDebugger debug(DirectedGraph<KRunState, Transition> graph) {
        return new KRunApiDebugger(this, graph);
    }

    @Override
    public KRunProofResult<java.util.Set<Term>> prove(Module m, Term KAST) {
        throw new UnsupportedBackendOptionException("--prove");
    }

    private static class MaudeTransition {
        public KRunState state;
        public Transition label;

        public MaudeTransition(KRunState state, Transition label) {
            this.state = state;
            this.label = label;
        }
    }
}

