/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.pdmc.automaton;

import com.google.common.base.Joiner;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kframework.backend.pdmc.automaton.AutomatonInterface;
import org.kframework.backend.pdmc.automaton.Transition;
import org.kframework.backend.pdmc.automaton.TransitionIndex;

public class BasicAutomaton<State, Alphabet>
implements AutomatonInterface<State, Alphabet> {
    private final Map<TransitionIndex<State, Alphabet>, Set<Transition<State, Alphabet>>> deltaIndex;
    private final State initialState;
    private final Set<State> finalStates;
    private final Set<Alphabet> letters;

    @Override
    public Set<Transition<State, Alphabet>> getTransitions(State state, Alphabet letter) {
        Set<Transition<State, Alphabet>> transitions = this.deltaIndex.get(TransitionIndex.of(state, letter));
        if (transitions == null) {
            transitions = Collections.emptySet();
        }
        return transitions;
    }

    @Override
    public State initialState() {
        return this.initialState;
    }

    @Override
    public Set<State> getFinalStates() {
        return this.finalStates;
    }

    public BasicAutomaton(Collection<Transition<State, Alphabet>> delta, State initialState, Collection<State> finalStates) {
        this.initialState = initialState;
        this.finalStates = new HashSet<State>(finalStates);
        this.letters = new HashSet<Alphabet>();
        this.deltaIndex = new HashMap<TransitionIndex<State, Alphabet>, Set<Transition<State, Alphabet>>>();
        for (Transition<State, Alphabet> transition : delta) {
            Set<Transition<State, Alphabet>> transitions;
            TransitionIndex index = transition.getIndex();
            if (index.getLetter() != null) {
                this.letters.add(index.getLetter());
            }
            if ((transitions = this.deltaIndex.get(index)) == null) {
                transitions = new HashSet<Transition<State, Alphabet>>();
                this.deltaIndex.put(index, transitions);
            }
            transitions.add(transition);
        }
    }

    public BasicAutomaton(Map<TransitionIndex<State, Alphabet>, Set<Transition<State, Alphabet>>> deltaIndex, State initialState, Set<State> finalStates) {
        this.letters = new HashSet<Alphabet>();
        for (TransitionIndex<State, Alphabet> index : deltaIndex.keySet()) {
            if (index.getLetter() == null) continue;
            this.letters.add(index.getLetter());
        }
        this.deltaIndex = deltaIndex;
        this.initialState = initialState;
        this.finalStates = finalStates;
    }

    public Collection<Set<Transition<State, Alphabet>>> getTransitions() {
        return this.deltaIndex.values();
    }

    public String toString() {
        Joiner joiner = Joiner.on(";\n");
        ArrayList<StringBuilder> builders = new ArrayList<StringBuilder>();
        for (Set<Transition<State, Alphabet>> transitions : this.deltaIndex.values()) {
            StringBuilder builder = new StringBuilder();
            joiner.appendTo(builder, (Iterable<?>)transitions);
            builders.add(builder);
        }
        builders.add(new StringBuilder(this.initialState.toString()));
        Joiner joiner1 = Joiner.on(" ");
        StringBuilder builder = new StringBuilder();
        joiner1.appendTo(builder, (Iterable<?>)this.finalStates);
        builders.add(builder);
        builder = new StringBuilder();
        joiner.appendTo(builder, (Iterable<?>)builders);
        return builder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public Deque<Transition<State, Alphabet>> getPath(State initialState, State finalState) {
        ArrayDeque<Object> toProcess = new ArrayDeque<Object>();
        HashMap considered = new HashMap();
        toProcess.add(initialState);
        considered.put(initialState, null);
        while (!toProcess.isEmpty()) {
            Object next = toProcess.remove();
            for (Set transitions : this.getFrontTransitions(next)) {
                for (Transition transition : transitions) {
                    Object endState = transition.getEnd();
                    if (endState.equals(finalState)) {
                        void var9_10;
                        ArrayDeque<Transition<State, Alphabet>> result = new ArrayDeque<Transition<State, Alphabet>>();
                        while (var9_10 != null) {
                            result.push((Transition<State, Alphabet>)var9_10);
                            Transition transition2 = (Transition)considered.get(var9_10.getStart());
                        }
                        return result;
                    }
                    if (considered.containsKey(endState)) continue;
                    considered.put(endState, transition);
                    toProcess.add(endState);
                }
            }
        }
        return null;
    }

    private Collection<Set<Transition<State, Alphabet>>> getFrontTransitions(State state) {
        ArrayList<Set<Transition<State, Alphabet>>> result = new ArrayList<Set<Transition<State, Alphabet>>>();
        for (Alphabet letter : this.letters) {
            Set<Transition<State, Alphabet>> transitions = this.getTransitions(state, letter);
            if (transitions.isEmpty()) continue;
            result.add(transitions);
        }
        return result;
    }
}

