/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.pdmc.automaton;

import java.util.HashMap;
import java.util.Map;
import org.kframework.backend.pdmc.automaton.TransitionIndex;
import org.kframework.backend.pdmc.pda.pautomaton.PAutomatonState;

public class Transition<State, Alphabet> {
    private static Map<TransitionIndex, Map<Object, Transition>> cache;
    private final State startState;
    private final State endState;
    private final Alphabet letter;

    public State getEnd() {
        return this.endState;
    }

    public Alphabet getLetter() {
        return this.letter;
    }

    protected Transition(State startState, Alphabet letter, State endState) {
        this.startState = startState;
        this.endState = endState;
        this.letter = letter;
    }

    public static <State, Alphabet> Transition<State, Alphabet> of(State startState, Alphabet letter, State endState) {
        Transition<State, Alphabet> transition;
        TransitionIndex<State, Alphabet> index;
        Map<Object, Transition> map;
        if (cache == null) {
            cache = new HashMap<TransitionIndex, Map<Object, Transition>>();
        }
        if ((map = cache.get(index = TransitionIndex.of(startState, letter))) == null) {
            map = new HashMap<Object, Transition>();
            cache.put(index, map);
        }
        if ((transition = map.get(endState)) == null) {
            transition = new Transition<State, Alphabet>(startState, letter, endState);
            map.put(endState, transition);
        }
        return transition;
    }

    public State getStart() {
        return this.startState;
    }

    public TransitionIndex getIndex() {
        return TransitionIndex.of(this.startState, this.letter);
    }

    public static Transition<PAutomatonState<String, String>, String> of(String transitionString) {
        String[] strings = transitionString.split("\\s+");
        assert (strings.length == 3 || strings.length == 2);
        PAutomatonState<String, String> startState = PAutomatonState.ofString(strings[0]);
        int i = 1;
        String letter = null;
        if (strings.length == 3) {
            letter = strings[i++];
        }
        PAutomatonState<String, String> endState = PAutomatonState.ofString(strings[i]);
        return new Transition<PAutomatonState<String, String>, String>(startState, letter, endState);
    }

    public String toString() {
        return this.startState + " " + (this.letter != null ? this.letter + " " : "") + this.endState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transition that = (Transition)o;
        if (!this.endState.equals(that.endState)) {
            return false;
        }
        if (this.letter != null ? !this.letter.equals(that.letter) : that.letter != null) {
            return false;
        }
        return this.startState.equals(that.startState);
    }

    public int hashCode() {
        int result = this.startState.hashCode();
        result = 31 * result + this.endState.hashCode();
        result = 31 * result + (this.letter != null ? this.letter.hashCode() : 0);
        return result;
    }
}

