/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.pdmc.pda;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.Stack;
import org.kframework.backend.pdmc.pda.ConfigurationHead;

public class Configuration<Control, Alphabet> {
    private static Stack emptyStack = null;
    ConfigurationHead<Control, Alphabet> head;
    Stack<Alphabet> stack;

    public Configuration(ConfigurationHead<Control, Alphabet> head, Stack<Alphabet> stack) {
        this.head = head;
        this.stack = stack;
    }

    public Configuration(Control control, Stack<Alphabet> stack) {
        if (stack.isEmpty()) {
            this.head = ConfigurationHead.of(control, null);
            this.stack = Configuration.emptyStack();
        } else {
            this.head = ConfigurationHead.of(control, stack.peek());
            if (stack.size() == 1) {
                this.stack = Configuration.emptyStack();
            } else {
                this.stack = new Stack();
                this.stack.addAll(stack);
                this.stack.pop();
            }
        }
    }

    public Configuration(Configuration<Control, Alphabet> configuration, Stack<Alphabet> stack) {
        this.head = configuration.getHead();
        if (stack.isEmpty()) {
            this.stack = configuration.getStack();
        } else {
            Stack<Alphabet> newStack = new Stack<Alphabet>();
            newStack.addAll(stack);
            newStack.addAll(configuration.getStack());
            if (!this.head.isProper()) {
                this.head = ConfigurationHead.of(this.head.getState(), newStack.pop());
            }
            this.stack = newStack;
        }
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 47 + this.head.hashCode();
        hash = hash * 47 + this.stack.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Configuration)) {
            return false;
        }
        Configuration configuration = (Configuration)obj;
        return this.head.equals(configuration.head) && this.stack.equals(configuration.stack);
    }

    public boolean isFinal() {
        return !this.head.isProper();
    }

    public ConfigurationHead<Control, Alphabet> getHead() {
        return this.head;
    }

    public Stack<Alphabet> getStack() {
        return this.stack;
    }

    public static <Alphabet> Stack<Alphabet> emptyStack() {
        if (emptyStack == null) {
            emptyStack = new Stack();
        }
        Stack returnStack = emptyStack;
        return returnStack;
    }

    public static Configuration<String, String> of(String confString) {
        assert (confString.charAt(0) == '<') : "Configuration must start with '<'.";
        assert (confString.charAt(confString.length() - 1) == '>') : "Configuration must start with '>'.";
        String[] strings = confString.substring(1, confString.length() - 1).split(",");
        assert (strings.length >= 1) : "Configuration must have a state.";
        assert (strings.length <= 2) : "Configuration cannot have more than a stack.";
        String control = strings[0].trim();
        Stack<String> stack = new Stack<String>();
        if (strings.length == 2) {
            String[] letters = strings[1].trim().split("\\s+");
            int i = letters.length;
            while (i-- > 0) {
                stack.push(letters[i]);
            }
        }
        return new Configuration<String, String>(control, stack);
    }

    public String toString() {
        Stack stack = (Stack)this.stack.clone();
        if (this.head.isProper()) {
            stack.add(this.head.getLetter());
        }
        Collections.reverse(stack);
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        builder.append(this.head.getState().toString());
        if (!stack.isEmpty()) {
            builder.append(", ");
            Joiner joiner = Joiner.on(" ");
            joiner.appendTo(builder, (Iterable<?>)stack);
        }
        builder.append(">");
        return builder.toString();
    }
}

