/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.pdmc.pda;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kframework.backend.pdmc.pda.Configuration;
import org.kframework.backend.pdmc.pda.ConfigurationHead;
import org.kframework.backend.pdmc.pda.PushdownSystemInterface;
import org.kframework.backend.pdmc.pda.Rule;

public class PushdownSystem<Control, Alphabet>
implements PushdownSystemInterface<Control, Alphabet> {
    Configuration<Control, Alphabet> initialConfiguration;
    Map<ConfigurationHead<Control, Alphabet>, Set<Rule<Control, Alphabet>>> deltaIndex = new HashMap<ConfigurationHead<Control, Alphabet>, Set<Rule<Control, Alphabet>>>();

    public PushdownSystem(Collection<Rule<Control, Alphabet>> rules, Configuration<Control, Alphabet> initialState) {
        for (Rule<Control, Alphabet> rule : rules) {
            ConfigurationHead<Control, Alphabet> head = rule.getHead();
            Set<Rule<Control, Alphabet>> headRules = this.deltaIndex.get(head);
            if (headRules == null) {
                headRules = new HashSet<Rule<Control, Alphabet>>();
                this.deltaIndex.put(head, headRules);
            }
            headRules.add(rule);
        }
        this.setInitialConfiguration(initialState);
    }

    public void setInitialConfiguration(Configuration<Control, Alphabet> initialConfiguration) {
        this.initialConfiguration = initialConfiguration;
    }

    @Override
    public Configuration<Control, Alphabet> initialConfiguration() {
        return this.initialConfiguration;
    }

    @Override
    public Set<Rule<Control, Alphabet>> getRules(ConfigurationHead<Control, Alphabet> configurationHead) {
        Set<Rule<Control, Alphabet>> rules = this.deltaIndex.get(configurationHead);
        if (rules == null) {
            rules = Collections.emptySet();
        }
        return rules;
    }

    public static PushdownSystem<String, String> of(String s) {
        ArrayList rules = new ArrayList();
        String[] stringRules = s.split("\\s*;\\s*");
        int n = stringRules.length - 1;
        Configuration<String, String> initialState = Configuration.of(stringRules[n]);
        for (int i = 0; i < n; ++i) {
            Rule<String, String> rule = Rule.of(stringRules[i]);
            rules.add(rule);
        }
        return new PushdownSystem<String, String>(rules, initialState);
    }

    public String toString() {
        Joiner joiner = Joiner.on(";\n");
        StringBuilder builder = new StringBuilder();
        joiner.appendTo(builder, (Iterable<?>)this.getRules());
        if (this.initialConfiguration != null) {
            builder.append(";\n");
            builder.append(this.initialConfiguration.toString());
        }
        return builder.toString();
    }

    private Collection<Rule<Control, Alphabet>> getRules() {
        ArrayList<Rule<Control, Alphabet>> rules = new ArrayList<Rule<Control, Alphabet>>();
        for (Set<Rule<Control, Alphabet>> values : this.deltaIndex.values()) {
            rules.addAll(values);
        }
        return rules;
    }
}

