/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.backend.pdmc.pda.buchi;

import org.kframework.backend.pdmc.pda.buchi.Evaluator;
import org.kframework.backend.pdmc.pda.buchi.Expression;
import org.kframework.backend.pdmc.pda.buchi.parser.PromelaBuchiParserConstants;

public class BooleanExpression
extends Expression
implements PromelaBuchiParserConstants {
    private final Expression rand1;
    private final Expression rand2;
    private final int opCode;

    public String toString() {
        switch (this.opCode) {
            case 15: {
                return "!" + this.rand1.toString();
            }
            case 16: {
                return this.rand1.toString() + " && " + this.rand2.toString();
            }
            case 17: {
                return this.rand1.toString() + " || " + this.rand2.toString();
            }
        }
        return super.toString();
    }

    public BooleanExpression(int opCode, Expression rand1) {
        this(opCode, rand1, null);
    }

    public BooleanExpression(int opCode, Expression rand1, Expression rand2) {
        this.rand1 = rand1;
        this.rand2 = rand2;
        this.opCode = opCode;
    }

    @Override
    public boolean evaluate(Evaluator evaluator) {
        switch (this.opCode) {
            case 15: {
                return !this.rand1.evaluate(evaluator);
            }
            case 16: {
                return this.rand1.evaluate(evaluator) && this.rand2.evaluate(evaluator);
            }
            case 17: {
                return this.rand1.evaluate(evaluator) || this.rand2.evaluate(evaluator);
            }
        }
        assert (false) : "Unsupported operation";
        return false;
    }
}

